/*
 * Decompiled with CFR 0.152.
 */
package tigase.component.adhoc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Consumer;
import tigase.server.Command;
import tigase.server.DataForm;
import tigase.xml.Element;

public class AdHocResponse {
    private final State currentState;
    private final ArrayList<Element> elements = new ArrayList();
    private State newState = State.completed;
    private String sessionid;

    AdHocResponse(String sessionid, State currState) {
        this.sessionid = sessionid;
        this.currentState = currState;
    }

    public void cancelSession() {
        this.newState = State.canceled;
    }

    public void completeSession() {
        this.newState = State.completed;
    }

    public Collection<Element> getElements() {
        return this.elements;
    }

    public Element addDataForm(Command.DataType dataType) {
        Element data = DataForm.createDataForm(dataType);
        this.elements.add(data);
        return data;
    }

    public Element addDataForm(Command.DataType dataType, Consumer<Element> consumer) {
        Element data = this.addDataForm(dataType);
        consumer.accept(data);
        return data;
    }

    public void startSession() {
        this.newState = State.executing;
        this.sessionid = UUID.randomUUID().toString();
    }

    State getCurrentState() {
        return this.currentState;
    }

    public State getNewState() {
        return this.newState;
    }

    public void setNewState(State newState) {
        this.newState = newState;
    }

    String getSessionid() {
        return this.sessionid;
    }

    void setSessionid(String sessionid) {
        this.sessionid = sessionid;
    }

    public static enum State {
        canceled,
        completed,
        executing;

    }
}

