/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.mechanisms;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import tigase.auth.mechanisms.AbstractSaslSCRAM;

public class SCRAMHelper {
    public static AuthenticationData encodePlainPassword(String algorithm, byte[] salt, int iterations, String plainPassword) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] saltedPassword = AbstractSaslSCRAM.hi(algorithm, AbstractSaslSCRAM.normalize(plainPassword), salt, iterations);
        return SCRAMHelper.transcode(algorithm, saltedPassword);
    }

    public static AuthenticationData transcode(String algorithm, byte[] saltedPassword) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] ck = AbstractSaslSCRAM.hmac(algorithm, saltedPassword, AbstractSaslSCRAM.DEFAULT_CLIENT_KEY);
        byte[] storedKey = AbstractSaslSCRAM.h(algorithm, ck);
        byte[] serverKey = AbstractSaslSCRAM.hmac(algorithm, saltedPassword, AbstractSaslSCRAM.DEFAULT_SERVER_KEY);
        return new AuthenticationData(algorithm, storedKey, serverKey);
    }

    private SCRAMHelper() {
    }

    public record AuthenticationData(String algorithm, byte[] storedKey, byte[] serverKey) {
    }
}

