/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.credentials.entries;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.auth.credentials.Credentials;
import tigase.auth.credentials.entries.PlainCredentialsEntry;
import tigase.auth.mechanisms.SCRAMHelper;
import tigase.kernel.beans.config.ConfigField;
import tigase.util.Base64;
import tigase.xmpp.jid.BareJID;

public class ScramCredentialsEntry
implements Credentials.Entry {
    private static final Logger log = Logger.getLogger(ScramCredentialsEntry.class.getCanonicalName());
    private final String algorithm;
    private final int iterations;
    private final byte[] salt;
    private final byte[] serverKey;
    private final byte[] storedKey;

    public ScramCredentialsEntry(String algorithm, PlainCredentialsEntry entry) throws NoSuchAlgorithmException, InvalidKeyException {
        SecureRandom random = new SecureRandom();
        this.algorithm = algorithm;
        this.iterations = 4096;
        this.salt = new byte[10];
        random.nextBytes(this.salt);
        SCRAMHelper.AuthenticationData authData = SCRAMHelper.encodePlainPassword(algorithm, this.salt, this.iterations, entry.getPassword());
        this.storedKey = authData.storedKey();
        this.serverKey = authData.serverKey();
    }

    public ScramCredentialsEntry(String algorithm, byte[] salt, int iterations, byte[] saltedPassword) throws NoSuchAlgorithmException, InvalidKeyException {
        this.algorithm = algorithm;
        this.iterations = iterations;
        this.salt = salt;
        SCRAMHelper.AuthenticationData authData = SCRAMHelper.transcode(algorithm, saltedPassword);
        this.storedKey = authData.storedKey();
        this.serverKey = authData.serverKey();
    }

    public ScramCredentialsEntry(String algorithm, byte[] salt, int iterations, byte[] storedKey, byte[] serverKey) {
        this.algorithm = algorithm;
        this.iterations = iterations;
        this.salt = salt;
        this.storedKey = storedKey;
        this.serverKey = serverKey;
    }

    public int getIterations() {
        return this.iterations;
    }

    @Override
    public String getMechanism() {
        return "SCRAM-" + this.algorithm;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getServerKey() {
        return this.serverKey;
    }

    public byte[] getStoredKey() {
        return this.storedKey;
    }

    @Override
    public boolean verifyPlainPassword(String password) {
        try {
            SCRAMHelper.AuthenticationData expAuthData = SCRAMHelper.encodePlainPassword(this.algorithm, this.salt, this.iterations, password);
            return Arrays.equals(this.serverKey, expAuthData.serverKey()) && Arrays.equals(this.storedKey, expAuthData.storedKey());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            log.log(Level.FINE, "Password comparison failed", ex);
            return false;
        }
    }

    public static class Encoder
    implements Credentials.Encoder<ScramCredentialsEntry> {
        @ConfigField(desc="Number of iterations")
        private final int iterations = 4096;
        private final SecureRandom random = new SecureRandom();
        @ConfigField(desc="Hash algorithm")
        private String algorithm;
        @ConfigField(desc="Mechanism name")
        private String name;

        public Encoder() {
        }

        protected Encoder(String algorithm) {
            this.algorithm = algorithm;
        }

        public static String encode(byte[] salt, int iterations, byte[] storedKey, byte[] serverKey) {
            return "s=" + Base64.encode((byte[])salt) + ",i=" + iterations + ",t=" + Base64.encode((byte[])storedKey) + ",e=" + Base64.encode((byte[])serverKey);
        }

        public static String encode(ScramCredentialsEntry entry) {
            return Encoder.encode(entry.getSalt(), entry.getIterations(), entry.getStoredKey(), entry.getServerKey());
        }

        @Override
        public String encode(BareJID user, ScramCredentialsEntry entry) {
            return Encoder.encode(entry);
        }

        @Override
        public String encode(BareJID user, String password) {
            SCRAMHelper.AuthenticationData authData;
            byte[] salt = new byte[10];
            this.random.nextBytes(salt);
            try {
                authData = SCRAMHelper.encodePlainPassword(this.algorithm, salt, 4096, password);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new RuntimeException("Could not encode password", e);
            }
            return Encoder.encode(salt, 4096, authData.storedKey(), authData.serverKey());
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static class Decoder
    implements Credentials.Decoder<ScramCredentialsEntry> {
        @ConfigField(desc="Hash algorithm")
        private String algorithm;
        @ConfigField(desc="Mechanism name")
        private String name;

        public Decoder() {
        }

        protected Decoder(String algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public ScramCredentialsEntry decode(BareJID user, String value) {
            byte[] salt = null;
            byte[] saltedPassword = null;
            byte[] storedKey = null;
            byte[] serverKey = null;
            int iterations = 0;
            int pos = 0;
            while (pos < value.length()) {
                char c = value.charAt(pos);
                int x = value.indexOf(",", pos + 2);
                String part = value.substring(pos + 2, x == -1 ? value.length() : x);
                switch (c) {
                    case 's': {
                        salt = Base64.decode((String)part);
                        break;
                    }
                    case 'i': {
                        iterations = Integer.parseInt(part);
                        break;
                    }
                    case 'p': {
                        saltedPassword = Base64.decode((String)part);
                        break;
                    }
                    case 't': {
                        storedKey = Base64.decode((String)part);
                        break;
                    }
                    case 'e': {
                        serverKey = Base64.decode((String)part);
                    }
                }
                if (x == -1) break;
                pos = x + 1;
            }
            if ((storedKey == null || serverKey == null) && saltedPassword != null) {
                return this.newInstance(salt, iterations, saltedPassword);
            }
            if (storedKey != null && serverKey != null) {
                return this.newInstance(salt, iterations, storedKey, serverKey);
            }
            throw new RuntimeException("saltedPassword or storedKey&serverKey pair must be not null.");
        }

        @Override
        public String getName() {
            return this.name;
        }

        protected ScramCredentialsEntry newInstance(byte[] salt, int iterations, byte[] saltedPassword) {
            try {
                return new ScramCredentialsEntry(this.algorithm, salt, iterations, saltedPassword);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }

        protected ScramCredentialsEntry newInstance(byte[] salt, int iterations, byte[] storedKey, byte[] serverKey) {
            return new ScramCredentialsEntry(this.algorithm, salt, iterations, storedKey, serverKey);
        }
    }
}

