/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import org.junit.Assert;
import org.junit.Test;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.ElementMatcher;

public class ElementMatcherTest {
    @Test
    public void testXMLNSOnly() throws TigaseStringprepException {
        String matcherStr = "[urn:ietf:params:xml:ns:xmpp-sasl]";
        ElementMatcher matcher = ElementMatcher.create((String)matcherStr);
        Assert.assertNotNull((Object)matcher);
        Assert.assertEquals((Object)matcherStr, (Object)matcher.toString());
        Packet packet = Packet.packetInstance((Element)new Element("message", new String[]{"xmlns"}, new String[]{"jabber:client"}));
        Assert.assertFalse((boolean)matcher.matches(packet));
        packet = Packet.packetInstance((Element)new Element("message", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl"}));
        Assert.assertTrue((boolean)matcher.matches(packet));
    }

    @Test
    public void testXMLNSAndType() throws TigaseStringprepException {
        String matcherStr = "[urn:ietf:params:xml:ns:xmpp-sasl,type=headline]";
        ElementMatcher matcher = ElementMatcher.create((String)matcherStr);
        Assert.assertNotNull((Object)matcher);
        Assert.assertEquals((Object)matcherStr, (Object)matcher.toString());
        Packet packet = Packet.packetInstance((Element)new Element("message", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl"}));
        Assert.assertFalse((boolean)matcher.matches(packet));
        packet = Packet.packetInstance((Element)new Element("message", new String[]{"xmlns", "type"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl", "headline"}));
        Assert.assertTrue((boolean)matcher.matches(packet));
    }

    @Test
    public void testAttr() throws TigaseStringprepException {
        String matcherStr = "/message/dummy[type=headline]";
        ElementMatcher matcher = ElementMatcher.create((String)matcherStr);
        Assert.assertNotNull((Object)matcher);
        Assert.assertEquals((Object)matcherStr, (Object)matcher.toString());
        Packet packet = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("dummy", new String[]{"type"}, new String[]{"fail"})}, new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl"}));
        Assert.assertFalse((boolean)matcher.matches(packet));
        packet = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("dummy", new String[]{"type"}, new String[]{"headline"})}, new String[]{"xmlns", "type"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl", "headline"}));
        Assert.assertTrue((boolean)matcher.matches(packet));
    }

    @Test
    public void testAllWithXMLNS() throws TigaseStringprepException {
        String matcherStr = "/message/*[http://jabber.org/protocol/chatstates]";
        ElementMatcher matcher = ElementMatcher.create((String)matcherStr);
        Assert.assertNotNull((Object)matcher);
        Assert.assertEquals((Object)matcherStr, (Object)matcher.toString());
        Packet packet = Packet.packetInstance((Element)new Element("message", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl"}));
        Assert.assertFalse((boolean)matcher.matches(packet));
        packet = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("active", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/chatstates"})}, new String[]{"xmlns", "type"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl", "headline"}));
        Assert.assertTrue((boolean)matcher.matches(packet));
    }
}

