/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver;

import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.junit.Test;
import tigase.TestLogger;
import tigase.server.xmppserver.S2SConnectionManager;

public class S2SConnectionManagerDomainServerNameMapperTest
extends TestCase {
    private static final Logger log = TestLogger.getLogger(S2SConnectionManagerDomainServerNameMapperTest.class);

    @Test
    public void testSortingOfMappings() {
        S2SConnectionManager.DomainServerNameMapper mapper = new S2SConnectionManager.DomainServerNameMapper();
        mapper.addEntry("*", "test1");
        mapper.addEntry("*.local", "test2");
        mapper.addEntry("*.test", "test3");
        mapper.addEntry("*.test.local", "test4");
        mapper.addEntry("test", "test5");
        mapper.addEntry("local", "test6");
        mapper.addEntry("test1.test", "test7");
        mapper.addEntry("test1.test.local", "test8");
        log.log(Level.FINE, mapper.toString());
        S2SConnectionManagerDomainServerNameMapperTest.assertEquals((String)"test1", (String)mapper.getServerNameForDomain("tigase.org"));
        S2SConnectionManagerDomainServerNameMapperTest.assertEquals((String)"test4", (String)mapper.getServerNameForDomain("test.local"));
        S2SConnectionManagerDomainServerNameMapperTest.assertEquals((String)"test2", (String)mapper.getServerNameForDomain("test1.local"));
        S2SConnectionManagerDomainServerNameMapperTest.assertEquals((String)"test5", (String)mapper.getServerNameForDomain("test"));
        S2SConnectionManagerDomainServerNameMapperTest.assertEquals((String)"test6", (String)mapper.getServerNameForDomain("local"));
        S2SConnectionManagerDomainServerNameMapperTest.assertEquals((String)"test3", (String)mapper.getServerNameForDomain("test.test"));
        S2SConnectionManagerDomainServerNameMapperTest.assertEquals((String)"test4", (String)mapper.getServerNameForDomain("test.test.local"));
        S2SConnectionManagerDomainServerNameMapperTest.assertEquals((String)"test7", (String)mapper.getServerNameForDomain("test1.test"));
        S2SConnectionManagerDomainServerNameMapperTest.assertEquals((String)"test8", (String)mapper.getServerNameForDomain("test1.test.local"));
    }
}

