/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.TrustManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.cert.CertificateEntry;
import tigase.cert.CertificateGenerator;
import tigase.cert.CertificateGeneratorFactory;
import tigase.cert.CertificateUtil;
import tigase.eventbus.EventBusFactory;
import tigase.io.CertificateContainer;
import tigase.io.CertificateContainerIfc;
import tigase.io.SSLContextContainer;
import tigase.io.SSLContextContainerAbstract;
import tigase.io.repo.CertificateItem;
import tigase.io.repo.CertificateRepository;
import tigase.kernel.AbstractKernelWithUserRepositoryTestCase;
import tigase.kernel.core.Kernel;

public class CertificateContainerTest
extends AbstractKernelWithUserRepositoryTestCase {
    private static final Logger LOGGER = Logger.getLogger(CertificateContainerTest.class.getName());
    private final String domain = "example.com";
    private final String mucDomain = "muc.example.com";
    private final String wildcardDomain = "*.example.com";
    private CertificateContainer certificateContainer;
    private SSLContextContainer sslContextContainer;

    @Test
    public void testRegularDomainForExistingCertificate() throws Exception {
        this.testDomain("example.com", "example.com", true);
    }

    @Test
    public void testSubdomainAgainstWildcardCertificate() throws Exception {
        this.testDomain("push.example.com", "*.example.com", true);
    }

    @Test
    public void testUpperCaseDomain() throws Exception {
        this.testDomain("example.com".toUpperCase(), "example.com", true);
    }

    @Test
    public void testDomainForNonexistentCertificate() throws Exception {
        this.testDomain("xmpp.org", "xmpp.org", false);
    }

    @Override
    protected void registerBeans(Kernel kernel) {
        super.registerBeans(kernel);
        kernel.registerBean("eventBus").asInstance((Object)EventBusFactory.getInstance()).exportable().exec();
        kernel.registerBean(TestCertificateRepositoryWithoutStore.class).setActive(true).exportable().exec();
        kernel.registerBean(TestCertificateContainerWithoutStore.class).exec();
        kernel.registerBean(SSLContextContainer.class).exec();
    }

    @Before
    public void setup() throws GeneralSecurityException, IOException {
        this.certificateContainer = (CertificateContainer)this.getKernel().getInstance(CertificateContainer.class);
        this.sslContextContainer = (SSLContextContainer)this.getKernel().getInstance(SSLContextContainer.class);
        this.addCertificateForDomain("example.com", true);
        this.addCertificateForDomain("*.example.com", true);
    }

    @Test
    public void testAddingCertificate() throws GeneralSecurityException, IOException {
        this.addCertificateForDomain("muc.example.com", false);
        this.addCertificateForDomain("*.example.com", true);
        CertificateEntry domainEntry = this.certificateContainer.getCertificateEntry("example.com");
        Assert.assertNotNull((Object)domainEntry);
        Assert.assertEquals((Object)CertificateUtil.getCertCName((X509Certificate)((X509Certificate)domainEntry.getCertificate().get())), (Object)"example.com");
        CertificateEntry wildcardDomainEntry = this.certificateContainer.getCertificateEntry("*.example.com");
        Assert.assertNotNull((Object)wildcardDomainEntry);
        Assert.assertEquals((Object)CertificateUtil.getCertCName((X509Certificate)((X509Certificate)wildcardDomainEntry.getCertificate().get())), (Object)"*.example.com");
        CertificateEntry mucDomainEntry = this.certificateContainer.getCertificateEntry("muc.example.com");
        Assert.assertNotNull((Object)mucDomainEntry);
        Assert.assertEquals((Object)"muc.example.com", (Object)CertificateUtil.getCertCName((X509Certificate)((X509Certificate)mucDomainEntry.getCertificate().get())));
    }

    private void testDomain(String hostname, String expectedDomain, boolean expectsExist) throws Exception {
        CertificateEntry certificateEntry = this.certificateContainer.getCertificateEntry(hostname);
        LOGGER.log(Level.INFO, "Certificate for hostname " + hostname + ": " + (certificateEntry != null ? certificateEntry.toString(true) : "n/a"));
        if (expectsExist) {
            Assert.assertNotNull((Object)certificateEntry);
        } else {
            Assert.assertNull((Object)certificateEntry);
        }
        SSLContextContainerAbstract.SSLHolder ssl = this.sslContextContainer.createContextHolder("SSL", hostname, hostname, false, new TrustManager[0]);
        Assert.assertNotNull((Object)ssl);
        Assert.assertNotNull((Object)ssl.domainCertificate);
        String cNname = CertificateUtil.getCertCName((X509Certificate)ssl.domainCertificate);
        if (expectsExist) {
            Assert.assertEquals((Object)certificateEntry.getCertChain()[0], (Object)ssl.domainCertificate);
        } else {
            CertificateEntry generatedEntry = this.certificateContainer.getCertificateEntry(hostname);
            Assert.assertNotNull((Object)generatedEntry);
        }
        Assert.assertEquals((Object)expectedDomain, (Object)cNname);
    }

    private void addCertificateForDomain(String domain, boolean includeWildcardSubdomain) throws GeneralSecurityException, IOException {
        CertificateGenerator generator = CertificateGeneratorFactory.getGenerator();
        CertificateEntry selfSignedCertificate = generator.generateSelfSignedCertificateEntry("test@mail.com", domain, "OU", "O", "City", "State", "Country", CertificateUtil.createKeyPair((int)1024, (String)"secret"), includeWildcardSubdomain);
        String pemCertificate = CertificateUtil.exportToPemFormat((CertificateEntry)selfSignedCertificate);
        CertificateContainerIfc.CertificateEntity certificateEntity = new CertificateContainerIfc.CertificateEntity(pemCertificate, domain, false, false);
        this.certificateContainer.addCertificates(certificateEntity);
    }

    public static class TestCertificateRepositoryWithoutStore
    extends CertificateRepository {
        protected void storeSingleItem(CertificateItem item) {
            LOGGER.log(Level.SEVERE, "Storing certificate to repository (we shouldn't?");
            super.storeSingleItem(item);
        }
    }

    public static class TestCertificateContainerWithoutStore
    extends CertificateContainer {
        void storeCertificateToFile(CertificateEntry entry, String filename) throws CertificateEncodingException, IOException {
            throw new RuntimeException(new IOException("We tried storing certificate to file, even though we shouldn't"));
        }
    }
}

