/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.CommandListener;
import tigase.cluster.api.SessionManagerClusteredIfc;
import tigase.cluster.strategy.DefaultClusteringStrategy;
import tigase.cluster.strategy.DefaultClusteringStrategyAbstract;
import tigase.eventbus.EventBusFactory;
import tigase.kernel.AbstractKernelTestCase;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.util.Algorithms;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class DefaultClusterStrategyTest
extends AbstractKernelTestCase {
    @Override
    protected void registerBeans(Kernel kernel) {
        super.registerBeans(kernel);
        kernel.registerBean("eventbus").asInstance((Object)EventBusFactory.getInstance()).exportable().exec();
        kernel.registerBean("sess-man").asInstance((Object)new DummySessionManagerClustered(this)).exportable().exec();
        kernel.registerBean("cluster-contr").asInstance((Object)new DummyClusterController(this)).exportable().exec();
        kernel.registerBean("strategy").asClass(this.getStrategyClass()).setActive(true).exportable().exec();
    }

    protected Class<? extends DefaultClusteringStrategyAbstract> getStrategyClass() {
        return DefaultClusteringStrategy.class;
    }

    @Test
    public void testIqResponseRedirection() throws TigaseStringprepException {
        DefaultClusteringStrategyAbstract strategy = this.getInstance(DefaultClusteringStrategyAbstract.class);
        Assert.assertEquals(Collections.emptyList(), (Object)strategy.getNodesConnected());
        String node1 = UUID.randomUUID().toString();
        String node2 = UUID.randomUUID().toString();
        String node3 = UUID.randomUUID().toString();
        JID senderJid = JID.jidInstance((String)UUID.randomUUID().toString(), (String)UUID.randomUUID().toString(), null);
        DummySessionManagerClustered sm = this.getInstance(DummySessionManagerClustered.class);
        sm.nodeConnected(node1);
        strategy.nodeConnected(JID.jidInstance((String)"sess-man", (String)node1));
        sm.nodeConnected(node2);
        strategy.nodeConnected(JID.jidInstance((String)"sess-man", (String)node2));
        Packet packet = Packet.packetInstance((Element)new Element("iq").withAttribute("type", "result"), (JID)senderJid, (JID)JID.jidInstance(null, (String)"localhost", (String)Algorithms.sha256((String)node2)));
        TestCase.assertTrue((boolean)strategy.isSuitableForForward(packet));
        TestCase.assertTrue((boolean)strategy.isIqResponseToNode(packet));
        Assert.assertEquals(Collections.singletonList(JID.jidInstance((String)"sess-man", (String)node2)), (Object)strategy.getNodesForIqResponse(packet));
        Assert.assertEquals(Collections.singletonList(JID.jidInstance((String)"sess-man", (String)node2)), (Object)strategy.getNodesForPacketForward(sm.getComponentId(), null, packet));
        packet = Packet.packetInstance((Element)new Element("iq").withAttribute("type", "result"), (JID)senderJid, (JID)JID.jidInstance(null, (String)"localhost", (String)Algorithms.sha256((String)node3)));
        TestCase.assertTrue((boolean)strategy.isSuitableForForward(packet));
        TestCase.assertTrue((boolean)strategy.isIqResponseToNode(packet));
        Assert.assertEquals(null, (Object)strategy.getNodesForIqResponse(packet));
        Assert.assertEquals(null, (Object)strategy.getNodesForPacketForward(sm.getComponentId(), null, packet));
    }

    private class DummySessionManagerClustered
    implements SessionManagerClusteredIfc {
        private List<JID> connectedNodes = new ArrayList<JID>();

        private DummySessionManagerClustered(DefaultClusterStrategyTest defaultClusterStrategyTest) {
        }

        public boolean fastAddOutPacket(Packet packet) {
            return false;
        }

        public void processPacket(Packet el_packet, XMPPResourceConnection conn) {
        }

        public void processPresenceUpdate(XMPPSession session, Element element) {
        }

        public XMPPResourceConnection getXMPPResourceConnection(Packet el_packet) {
            return null;
        }

        public ConcurrentHashMap<JID, XMPPResourceConnection> getXMPPResourceConnections() {
            return null;
        }

        public ConcurrentHashMap<BareJID, XMPPSession> getXMPPSessions() {
            return null;
        }

        public boolean hasXMPPResourceConnectionForConnectionJid(JID connJid) {
            return false;
        }

        public JID getComponentId() {
            return JID.jidInstanceNS((String)("sess-man@" + UUID.randomUUID().toString()));
        }

        public void handleLogin(BareJID userId, XMPPResourceConnection conn) {
        }

        public void handleDomainChange(String domain, XMPPResourceConnection conn) {
        }

        public void handleLogout(BareJID userId, XMPPResourceConnection conn) {
        }

        public void handlePresenceSet(XMPPResourceConnection conn) {
        }

        public void handleResourceBind(XMPPResourceConnection conn) {
        }

        public boolean isLocalDomain(String domain, boolean includeComponents) {
            return "localhost".equals(domain);
        }

        public List<JID> getNodesConnected() {
            return this.connectedNodes;
        }

        public String getName() {
            return "sess-man";
        }

        public void nodeConnected(String node) {
            JID jid = JID.jidInstanceNS((String)this.getName(), (String)node, null);
            if (!this.connectedNodes.contains(jid) && !this.getComponentId().equals((Object)jid)) {
                Object[] tmp = this.connectedNodes.toArray(new JID[this.connectedNodes.size() + 1]);
                tmp[tmp.length - 1] = jid;
                Arrays.sort(tmp);
                int pos = Arrays.binarySearch(tmp, jid);
                this.connectedNodes.add(pos, jid);
            }
        }

        public void nodeDisconnected(String node) {
            JID jid = JID.jidInstanceNS((String)this.getName(), (String)node, null);
            this.connectedNodes.remove(jid);
        }
    }

    private class DummyClusterController
    implements ClusterControllerIfc {
        private List<String> nodes = new ArrayList<String>();

        private DummyClusterController(DefaultClusterStrategyTest defaultClusterStrategyTest) {
        }

        public void handleClusterPacket(Element packet) {
        }

        public void nodeConnected(String addr) {
            if (!this.nodes.contains(addr)) {
                this.nodes.add(addr);
            }
        }

        public void nodeDisconnected(String addr) {
            this.nodes.remove(addr);
        }

        public void removeCommandListener(CommandListener listener) {
        }

        public void sendToNodes(String command, Map<String, String> data, Queue<Element> packets, JID fromNode, Set<JID> visitedNodes, JID ... toNodes) {
        }

        public void sendToNodes(String command, Queue<Element> packets, JID fromNode, Set<JID> visitedNodes, JID ... toNodes) {
        }

        public void sendToNodes(String command, Map<String, String> data, JID fromNode, Set<JID> visitedNodes, JID ... toNodes) {
        }

        public void sendToNodes(String command, Map<String, String> data, JID fromNode, JID ... toNodes) {
        }

        public void sendToNodes(String command, JID fromNode, JID ... toNodes) {
        }

        public void sendToNodes(String command, Element packet, JID fromNode, Set<JID> visitedNodes, JID ... toNodes) {
        }

        public void sendToNodes(String command, Map<String, String> data, Element packet, JID fromNode, Set<JID> visitedNodes, JID ... toNodes) {
        }

        public void setCommandListener(CommandListener listener) {
        }
    }
}

