/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.mechanisms;

import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import tigase.auth.mechanisms.SaslANONYMOUS;

public class SaslANONYMOUSTest
extends TestCase {
    private SaslANONYMOUS sasl;

    @Before
    public void setUp() {
        HashMap props = new HashMap();
        CallbackHandler callbackHandler = new CallbackHandler(this){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (!(callback instanceof NameCallback)) {
                        throw new UnsupportedCallbackException(callback);
                    }
                    ((NameCallback)callback).setName("somerandomname@domain.com");
                }
            }
        };
        this.sasl = new SaslANONYMOUS(props, callbackHandler);
    }

    @Test
    public void testSuccess() {
        try {
            this.sasl.evaluateResponse("".getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
            SaslANONYMOUSTest.fail((String)e.getMessage());
        }
        SaslANONYMOUSTest.assertTrue((boolean)this.sasl.isComplete());
        SaslANONYMOUSTest.assertEquals((String)"somerandomname@domain.com", (String)this.sasl.getAuthorizationID());
        SaslANONYMOUSTest.assertTrue((boolean)((Boolean)this.sasl.getNegotiatedProperty("IS_ANONYMOUS")));
    }
}

