/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.server.xmppsession.SessionManager;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.PresenceState;
import tigase.xmpp.impl.VCardXMPPProcessorAbstract;
import tigase.xmpp.impl.annotation.DiscoFeatures;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Id(value="vcard-temp")
@Handles(value={@Handle(path={"iq", "vCard"}, xmlns="vcard-temp"), @Handle(path={"iq", "VCARD"}, xmlns="vcard-temp")})
@DiscoFeatures(value={"vcard-temp"})
@Bean(name="vcard-temp", parent=SessionManager.class, active=true)
public class VCardTemp
extends VCardXMPPProcessorAbstract
implements PresenceState.ExtendedPresenceProcessorIfc {
    public static final String VCARD_KEY = "vCard";
    protected static final String vCard = "vCard";
    protected static final String VCARD = "VCARD";
    protected static final String XMLNS = "vcard-temp";
    protected static final String ID = "vcard-temp";
    private static final SimpleParser parser = SingletonFactory.getParserInstance();
    private static Logger log = Logger.getLogger(VCardTemp.class.getName());
    private final String PEP_VCARD_TEMP_HASH_KEY = "pep-vcard-temp-conv-hash";
    @Inject
    private UserRepository userRepository;

    @Override
    public void processFromUserOutPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (session.isLocalDomain(packet.getStanzaTo().getDomain(), false)) {
            try {
                String strvCard = repo.getPublicData(packet.getStanzaTo().getBareJID(), "vcard-temp", "vCard", null);
                Packet result = null;
                result = strvCard != null ? this.parseXMLData(strvCard, packet) : packet.okResult((String)null, 1);
                result.setPacketTo(connectionId);
                results.offer(result);
            }
            catch (UserNotFoundException e) {
                results.offer(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "User not found", true));
            }
        } else {
            results.offer(packet.copyElementOnly());
        }
    }

    @Override
    public void processFromUserToServerPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (packet.getType() != null) {
            try {
                Packet result = null;
                switch (packet.getType()) {
                    case get: {
                        String strvCard = session.getPublicData("vcard-temp", "vCard", null);
                        if (strvCard != null) {
                            result = this.parseXMLData(strvCard, packet);
                            break;
                        }
                        result = packet.okResult((String)null, 1);
                        break;
                    }
                    case set: {
                        Element elvCard = packet.getElement().getChild("vCard");
                        if (elvCard == null) {
                            elvCard = packet.getElement().getChild(VCARD);
                        }
                        this.setVCard(session, elvCard);
                        result = packet.okResult((String)null, 0);
                        break;
                    }
                }
                if (result != null) {
                    result.setPacketTo(session.getConnectionId());
                    results.offer(result);
                }
            }
            catch (NoConnectionIdException ex) {
                log.log(Level.FINE, "This should not happen, unless this is a vcard result packet sent to the server, which should not happen: " + String.valueOf(packet));
            }
            catch (NotAuthorizedException ex) {
                log.log(Level.FINE, "Received vCard request but user session is not authorized yet: " + String.valueOf(packet));
                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
            }
            catch (TigaseDBException ex) {
                log.log(Level.WARNING, "Database problem, please contact admin: " + String.valueOf(ex));
                results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database access problem, please contact administrator.", true));
            }
        }
    }

    @Override
    public void processNullSessionPacket(Packet packet, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (packet.getType() == StanzaType.get) {
            try {
                String strvCard = repo.getPublicData(packet.getStanzaTo().getBareJID(), "vcard-temp", "vCard", null);
                if (strvCard != null) {
                    results.offer(this.parseXMLData(strvCard, packet));
                } else {
                    results.offer(packet.okResult((String)null, 1));
                }
            }
            catch (UserNotFoundException e) {
                results.offer(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "User not found", true));
            }
        }
    }

    @Override
    public void processServerSessionPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
    }

    @Override
    public void processToUserPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        this.processNullSessionPacket(packet, repo, results, settings);
        if (session != null && session.isAuthorized() && packet.getType() != StanzaType.get) {
            try {
                JID conId = session.getConnectionId(packet.getStanzaTo());
                if (conId == null) {
                    return;
                }
                Packet result = packet.copyElementOnly();
                result.setPacketTo(session.getConnectionId(packet.getStanzaTo()));
                results.offer(result);
            }
            catch (NoConnectionIdException ex) {
                log.log(Level.WARNING, "This should not happen, unless this is a vcard result packet sent to the server, which should not happen: " + String.valueOf(packet));
            }
        }
    }

    public void pepToVCardTemp_onPublication(BareJID userJid, XMPPResourceConnection session, String itemId, String mimeType, Supplier<JID> pubsubComponentJidSupplier, Consumer<Packet> writer) {
        Element iqEl = new Element("iq", new String[]{"type", "id"}, new String[]{"get", "sm-query-vcard-pep-" + mimeType});
        iqEl.withElement("pubsub", "http://jabber.org/protocol/pubsub", pubsubEl -> pubsubEl.withElement("items", itemsEl -> {
            itemsEl.setAttribute("node", "urn:xmpp:avatar:data");
            itemsEl.withElement("item", itemEl -> itemEl.setAttribute("id", itemId));
        }));
        Iq iq = (Iq)Packet.packetInstance(iqEl, JID.jidInstanceNS((BareJID)userJid), JID.jidInstanceNS((BareJID)userJid));
        iq.setPacketTo(pubsubComponentJidSupplier.get());
        iq.setPriority(Priority.LOW);
        writer.accept(iq);
    }

    public void pepToVCardTemp_onDataRetrieved(Packet packet, XMPPResourceConnection session) {
        Element itemEl = packet.getElement().findChild(new String[]{"iq", "pubsub", "items", "item"});
        String mimeType = packet.getAttributeStaticStr("id").replace("sm-query-vcard-pep-", "");
        if (itemEl != null && mimeType != null) {
            String id = itemEl.getAttributeStaticStr("id");
            Element data = itemEl.getChild("data", "urn:xmpp:avatar:data");
            if (id != null && data != null) {
                try {
                    Element vCard = this.parseXMLDataToElement(this.userRepository.getData(packet.getStanzaFrom().getBareJID(), "public/vcard-temp", "vCard")).orElseGet(() -> new Element("vCard", new String[]{"xmlns"}, new String[]{"vcard-temp"}));
                    Element photoEl = vCard.findChild(new String[]{"vCard", "PHOTO"});
                    if (photoEl != null) {
                        vCard.removeChild(photoEl);
                    }
                    if (data.getCData() != null) {
                        photoEl = new Element("PHOTO");
                        photoEl.withElement("TYPE", null, mimeType);
                        photoEl.withElement("BINVAL", null, data.getCData());
                        vCard.addChild((XMLNodeIfc)photoEl);
                    }
                    this.userRepository.setData(packet.getStanzaFrom().getBareJID(), "vcard-temp", "pep-vcard-temp-conv-hash", id);
                    if (session != null) {
                        session.putCommonSessionData("pep-vcard-temp-conv-hash", id);
                    }
                    this.setVCard(session, vCard);
                    log.log(Level.FINEST, "Updated vCard, avatar hash: {0}, payload: {1}!", new Object[]{id, vCard});
                }
                catch (RepositoryException | NotAuthorizedException ex) {
                    log.log(Level.FINEST, "failed to update VCardTemp avatar on PEP User Avatar change!");
                }
            }
        }
    }

    @Override
    public Element extend(Element presence, XMPPResourceConnection session, Queue<Packet> results) {
        Element photoEl;
        Element x = presence.getChild("x", "vcard-temp:x:update");
        Element element = photoEl = x == null ? null : x.getChild("photo");
        if (photoEl != null) {
            return null;
        }
        String hash = (String)session.computeCommonSessionDataIfAbsent("pep-vcard-temp-conv-hash", key -> {
            try {
                return Optional.ofNullable(this.userRepository.getData(session.getBareJID(), "vcard-temp", "pep-vcard-temp-conv-hash")).orElse("");
            }
            catch (NotAuthorizedException ex) {
                log.log(Level.FINEST, "failed to retrieve VCardTemp avatar hash - session not authorized yet!", ex);
            }
            catch (RepositoryException ex) {
                log.log(Level.FINEST, "failed to retrieve VCardTemp avatar hash!", ex);
            }
            return null;
        });
        if (hash == null || hash.isEmpty()) {
            return null;
        }
        if (x == null) {
            x = new Element("x");
            x.setXMLNS("vcard-temp:x:update");
        } else if (photoEl != null) {
            presence.removeChild(x);
            x.removeChild(photoEl);
        }
        photoEl = new Element("photo", hash);
        x.addChild((XMLNodeIfc)photoEl);
        return x;
    }

    @Override
    public Element extend(XMPPResourceConnection session, Queue<Packet> results) {
        throw new UnsupportedOperationException("It should never be called!");
    }

    @Override
    protected String getVCardXMLNS() {
        return "vcard-temp";
    }

    @Override
    protected void storeVCard(XMPPResourceConnection session, Element elvCard) throws TigaseDBException, NotAuthorizedException {
        if (elvCard != null) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Adding vCard: " + String.valueOf(elvCard));
            }
            session.setPublicData("vcard-temp", "vCard", elvCard.toString());
        } else {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Removing vCard");
            }
            session.removePublicData("vcard-temp", "vCard");
        }
    }

    private Packet parseXMLData(String data, Packet packet) {
        DomBuilderHandler domHandler = new DomBuilderHandler();
        parser.parse((SimpleHandler)domHandler, data.toCharArray(), 0, data.length());
        Queue elems = domHandler.getParsedElements();
        Packet result = packet.okResult((Element)null, 0);
        result.setPacketFrom(null);
        result.setPacketTo(null);
        for (Element el : elems) {
            result.getElement().addChild((XMLNodeIfc)el);
        }
        return result;
    }

    private Optional<Element> parseXMLDataToElement(String data) {
        if (data == null) {
            return Optional.empty();
        }
        DomBuilderHandler domHandler = new DomBuilderHandler();
        parser.parse((SimpleHandler)domHandler, data.toCharArray(), 0, data.length());
        Queue elems = domHandler.getParsedElements();
        return Optional.ofNullable((Element)elems.poll());
    }
}

