/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.UnregisterAware;

public class TokenBucketPool
implements Initializable,
UnregisterAware {
    private static final Logger log = Logger.getLogger(TokenBucketPool.class.getName());
    private final ConcurrentHashMap<String, TokenBucket> items = new ConcurrentHashMap();
    private boolean autoPurgeEnabled = true;
    private final TimerTask purgerTask = new TimerTask(){

        @Override
        public void run() {
            if (TokenBucketPool.this.autoPurgeEnabled) {
                TokenBucketPool.this.purge();
            }
        }
    };
    private long defaultRate = 100000L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private long defaultPer = this.timeUnit.toNanos(1L);
    private Timer timer;

    public TokenBucketPool(long rate, long per, TimeUnit timeUnit) {
        this.defaultRate = rate;
        this.defaultPer = timeUnit.toNanos(per);
        this.timeUnit = timeUnit;
    }

    public TokenBucketPool(long rate, long per) {
        this.defaultRate = rate;
        this.defaultPer = this.timeUnit.toNanos(per);
    }

    public TokenBucketPool() {
    }

    public void setAutoPurgeEnabled(boolean enabled) {
        this.autoPurgeEnabled = enabled;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public long getDefaultRate() {
        return this.defaultRate;
    }

    public void setDefaultRate(long defaultRate) {
        this.defaultRate = defaultRate;
    }

    public long getDefaultPer() {
        return this.timeUnit.convert(this.defaultPer, TimeUnit.NANOSECONDS);
    }

    public void setDefaultPer(long defaultPer) {
        this.defaultPer = this.timeUnit.toNanos(defaultPer);
    }

    public boolean consume(String key) {
        TokenBucket item = this.items.get(key);
        if (item == null) {
            item = new TokenBucket(System.nanoTime(), this.defaultRate, this.defaultPer);
            this.items.put(key, item);
        }
        return this.consume(item);
    }

    public void purge() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Purging full TokenBuckets...");
        }
        Iterator<Map.Entry<String, TokenBucket>> iterator = this.items.entrySet().iterator();
        long current = System.nanoTime();
        while (iterator.hasNext()) {
            Map.Entry<String, TokenBucket> entry = iterator.next();
            if (!(entry.getValue().estimateAllowance(current) >= entry.getValue().rate)) continue;
            iterator.remove();
        }
    }

    @Override
    public void beforeUnregister() {
        if (this.timer == null) {
            this.timer.cancel();
        }
        this.timer = null;
    }

    @Override
    public void initialize() {
        if (this.timer != null) {
            this.beforeUnregister();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("TokenBucketPool Created. Auto purge task created.");
        }
        this.timer = new Timer("TokenBuckerPoolTimerThread", true);
        this.timer.schedule(this.purgerTask, TimeUnit.HOURS.toMillis(4L));
    }

    int size() {
        return this.items.size();
    }

    private boolean consume(TokenBucket item) {
        return item.consume();
    }

    public static class TokenBucket {
        private final float per;
        private final float rate;
        private float allowance = 1.0f;
        private long lastCheck;

        TokenBucket(long lastCheck, float rate, float per) {
            this.per = per;
            this.rate = rate;
            this.lastCheck = lastCheck;
        }

        public TokenBucket(long rate, long per) {
            this.lastCheck = System.nanoTime();
            this.per = per;
            this.rate = rate;
        }

        public boolean consume() {
            long current = System.nanoTime();
            this.updateAllowance(current);
            return this.consumeNoUpdate();
        }

        final boolean consumeNoUpdate() {
            if ((double)this.allowance < 1.0) {
                return false;
            }
            this.allowance = (float)((double)this.allowance - 1.0);
            return true;
        }

        float getAllowance() {
            return this.allowance;
        }

        final float estimateAllowance(long current) {
            float timePassed = current - this.lastCheck;
            this.lastCheck = current;
            return this.allowance + timePassed * (this.rate / this.per);
        }

        final void updateAllowance(long current) {
            long timePassed = current - this.lastCheck;
            this.lastCheck = current;
            this.allowance += (float)timePassed * (this.rate / this.per);
            if (this.allowance > this.rate) {
                this.allowance = this.rate;
            }
        }
    }
}

