/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="message-vhost-forward", parent=SessionManager.class, active=false)
public class MessageForwarding
extends XMPPProcessor
implements XMPPProcessorIfc {
    protected static final String ID = "message-vhost-forward";
    private static final String FORWARD_EL = "forward";
    private static final String FORWARD_XMLNS = "http://tigase.org/protocol/forward#v1";
    private static final Logger log = Logger.getLogger(MessageForwarding.class.getName());
    private static final String XMLNS = "jabber:client";
    private static final String[][] ELEMENTS = new String[][]{{"message"}};
    private static final String[] XMLNSS = new String[]{"jabber:client"};
    private static final String[] MESSAGE_FORWARD_PATH = new String[]{"message", "forward"};
    private static final Element forw_el = new Element("forward", new String[]{"xmlns"}, new String[]{"http://tigase.org/protocol/forward#v1"});

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing packet: {0}", packet);
        }
        if (session == null) {
            return;
        }
        if (packet.getElemCDataStaticStr(Message.MESSAGE_BODY_PATH) == null) {
            return;
        }
        if (packet.isXMLNSStaticStr(MESSAGE_FORWARD_PATH, FORWARD_XMLNS)) {
            return;
        }
        JID forwardAddr = session.getDomain().getMessageForward();
        if (forwardAddr == null) {
            return;
        }
        try {
            BareJID id;
            JID user = null;
            BareJID bareJID = id = packet.getStanzaTo() != null ? packet.getStanzaTo().getBareJID() : null;
            if (session.isUserId(id)) {
                user = packet.getStanzaTo();
            } else {
                BareJID bareJID2 = id = packet.getStanzaFrom() != null ? packet.getStanzaFrom().getBareJID() : null;
                if (session.isUserId(id)) {
                    user = packet.getStanzaFrom();
                }
            }
            if (user == null) {
                user = session.getJID();
            }
            Element forward_payload = forw_el.clone();
            forward_payload.addAttribute("from", packet.getStanzaFrom().toString());
            forward_payload.addAttribute("to", packet.getStanzaTo().toString());
            Packet result = Packet.packetInstance(packet.getElement(), user, forwardAddr);
            result.getElement().addChild((XMLNodeIfc)forward_payload);
            results.offer(result);
        }
        catch (NotAuthorizedException e) {
            log.warning("NotAuthorizedException for packet: " + String.valueOf(packet));
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }
}

