/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.MobileV2;
import tigase.xmpp.impl.annotation.AnnotatedXMPPProcessor;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.impl.annotation.StreamFeature;
import tigase.xmpp.impl.annotation.StreamFeatures;

@Id(value="urn:xmpp:csi:0")
@Handles(value={@Handle(path={"active"}, xmlns="urn:xmpp:csi:0"), @Handle(path={"inactive"}, xmlns="urn:xmpp:csi:0")})
@StreamFeatures(value={@StreamFeature(elem="csi", xmlns="urn:xmpp:csi:0")})
@Bean(name="urn:xmpp:csi:0", parent=SessionManager.class, active=true)
public class ClientStateIndication
extends AnnotatedXMPPProcessor
implements XMPPProcessorIfc,
XMPPPacketFilterIfc,
RegistrarBean {
    protected static final String XMLNS = "urn:xmpp:csi:0";
    protected static final String ID = "urn:xmpp:csi:0";
    protected static final String ACTIVE_NAME = "active";
    protected static final String INACTIVE_NAME = "inactive";
    private static final Logger log = Logger.getLogger(ClientStateIndication.class.getCanonicalName());
    @Inject
    private Logic logic;

    @Override
    public void filter(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        this.logic.filter(packet, session, repo, results);
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        if (!session.isAuthorized()) {
            try {
                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "Session is not yet authorized.", false));
            }
            catch (PacketErrorTypeException ex) {
                log.log(Level.FINEST, "ignoring packet from not authorized session which is already of type error");
            }
            return;
        }
        switch (packet.getElemName()) {
            case "active": {
                this.logic.deactivate(session, results);
                break;
            }
            case "inactive": {
                this.logic.activate(session, results);
                break;
            }
            default: {
                results.offer(Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, null, true));
            }
        }
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session == null || !session.isAuthorized()) {
            return null;
        }
        return super.supStreamFeatures(session);
    }

    @Override
    public void register(Kernel kernel) {
        kernel.registerBean("logic").asClass(MobileV2.class).exec();
    }

    @Override
    public void unregister(Kernel kernel) {
    }

    public static interface Logic
    extends XMPPPacketFilterIfc {
        public void activate(XMPPResourceConnection var1, Queue<Packet> var2);

        public void deactivate(XMPPResourceConnection var1, Queue<Packet> var2);
    }
}

