/*
 * Decompiled with CFR 0.152.
 */
package tigase.vhosts;

import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.Repository;
import tigase.db.comp.UserRepoRepository;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigAlias;
import tigase.kernel.beans.config.ConfigAliases;
import tigase.kernel.beans.config.ConfigField;
import tigase.util.dns.DNSEntry;
import tigase.util.dns.DNSResolverFactory;
import tigase.util.dns.DNSResolverIfc;
import tigase.vhosts.VHostComponentRepositoryDataSourceAware;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostItemDefaults;
import tigase.vhosts.VHostItemExtensionManager;
import tigase.vhosts.VHostItemImpl;
import tigase.vhosts.VHostRepoDefaults;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Repository.Meta(supportedUris={".*"}, isDefault=true)
@ConfigAliases(value={@ConfigAlias(field="items", alias="virtual-hosts")})
public class VHostJDBCRepository
extends UserRepoRepository<VHostItem>
implements VHostComponentRepositoryDataSourceAware<DataSource> {
    private static final Logger log = Logger.getLogger(VHostJDBCRepository.class.getName());
    @ConfigField(desc="Default IP to which VHost should resolve", alias="dns-def-ip")
    private String def_ip_address = null;
    @ConfigField(desc="Default hostname to which VHost should resolve", alias="dns-srv-def-addr")
    private String def_srv_address = null;
    @ConfigField(desc="Max allowed number of domains per user", alias="domains-per-user-limit")
    private int max_domains_per_user = 25;
    private Map<String, Map<String, Object>> pendingItemsToSet = null;
    private String[] pendingItemsToSetOld = null;
    @ConfigField(desc="Main VHost name", alias="default-virtual-host")
    private String mainVHostName;
    @ConfigField(desc="DNS address under which whole installation is accessible (ie. name pointing to all cluster nodes or to the load balancer)", alias="installation-dns-address")
    private String installationDnsAddress = null;
    @Inject
    private VHostItemExtensionManager extensionManager;
    @Inject
    private VHostItemDefaults vhostDefaultValues;
    private VHostItem defaultVHost = null;

    public VHostJDBCRepository() {
        DNSResolverIfc resolver = DNSResolverFactory.getInstance();
        this.def_srv_address = resolver.getDefaultHost();
        try {
            this.def_ip_address = resolver.getHostIP(resolver.getDefaultHost());
        }
        catch (Exception e) {
            this.def_ip_address = resolver.getDefaultHost();
        }
        this.autoReloadInterval = 60L;
    }

    @Override
    public void destroy() {
    }

    @Override
    public String getConfigKey() {
        return VHostRepoDefaults.getConfigKey();
    }

    @Override
    public String[] getDefaultPropetyItems() {
        return VHostRepoDefaults.getDefaultPropetyItems();
    }

    @Override
    public VHostItem getItemInstance() {
        VHostItemImpl item = VHostRepoDefaults.getItemInstance();
        item.setExtensionManager(this.extensionManager);
        VHostItemImpl.VHostItemWrapper wrapper = new VHostItemImpl.VHostItemWrapper();
        wrapper.setItem(item);
        wrapper.setDefaultVHost(this.defaultVHost);
        wrapper.setVHostDefaults(this.vhostDefaultValues);
        return wrapper;
    }

    @Override
    public String getItemsListPKey() {
        return VHostRepoDefaults.getItemsListPKey();
    }

    @Override
    public String getPropertyKey() {
        return VHostRepoDefaults.getPropertyKey();
    }

    @Override
    public BareJID getRepoUser() {
        return VHostRepoDefaults.getRepoUser();
    }

    @Override
    @Deprecated
    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
    }

    @Override
    public void reload() {
        if (this.vhostDefaultValues == null) {
            return;
        }
        super.reload();
        VHostItem defaultVHost = (VHostItem)this.getItem("default");
        if (defaultVHost == null) {
            this.defaultVHost = new VHostItemImpl(JID.jidInstanceNS((String)"default"));
            ((VHostItemImpl)this.defaultVHost).initializeFromDefaults(this.vhostDefaultValues);
            ((VHostItemImpl)this.defaultVHost).setExtensionManager(this.extensionManager);
            this.addItem(this.defaultVHost);
        } else {
            this.defaultVHost = defaultVHost;
        }
    }

    @Override
    public void addItemNoStore(VHostItem item) {
        if (item instanceof VHostItemImpl.VHostItemWrapper) {
            ((VHostItemImpl.VHostItemWrapper)item).readOnly();
            if (this.defaultVHost != null) {
                ((VHostItemImpl.VHostItemWrapper)item).setDefaultVHost(this.defaultVHost);
            }
        }
        super.addItemNoStore(item);
        if ("default".equals(item.getKey())) {
            this.defaultVHost = item;
            for (VHostItem it : this.allItems()) {
                if (!(it instanceof VHostItemImpl.VHostItemWrapper) || it == item) continue;
                ((VHostItemImpl.VHostItemWrapper)it).setDefaultVHost(item);
            }
        }
    }

    public void setDef_srv_address(String address) {
        this.def_srv_address = address;
        if (this.def_srv_address != null && !this.def_srv_address.endsWith(".")) {
            this.def_srv_address = this.def_srv_address + ".";
        }
    }

    @Override
    public String validateItem(VHostItem item) {
        if (item.getVhost() == null || item.getVhost().getDomain() == null || item.getVhost().getDomain().isEmpty()) {
            return "Domain name not specified";
        }
        int vhost_count = 0;
        for (VHostItem it : this.allItems()) {
            if (!it.isOwner(item.getOwner())) continue;
            ++vhost_count;
        }
        if (vhost_count >= this.max_domains_per_user) {
            return "Maximum number of domains exceeded for the user! Current number is: " + vhost_count;
        }
        if (item.getS2sSecret() == null) {
            return "S2S Secret is required";
        }
        if (this.vhostDefaultValues.isTlsRequired() && !item.isTlsRequired()) {
            return "This installation forces VHost to require TLS. If you need to use unencrypted connections set 'vhost-tls-required' property to 'false' in the installation configuration file.";
        }
        if (!this.vhostDefaultValues.isCheckDns()) {
            return null;
        }
        if (this.installationDnsAddress != null) {
            String[] installationIpAddresses = DNSResolverFactory.getInstance().getHostIPs(this.installationDnsAddress);
            if (installationIpAddresses == null) {
                return "No DNS settings for load balancer DNS name: " + this.installationDnsAddress;
            }
            List<String> installationIpAddressesList = Arrays.asList(installationIpAddresses);
            try {
                DNSEntry[] entries = DNSResolverFactory.getInstance().getHostSRV_Entries(item.getKey());
                if (entries != null) {
                    List invalidAddresses = Arrays.stream(entries).flatMap(dnsEntry -> Arrays.stream(dnsEntry.getIps())).filter(ip -> !this.installationDnsAddress.equals(ip) && !installationIpAddressesList.contains(ip)).collect(Collectors.toList());
                    if (invalidAddresses.isEmpty()) {
                        return null;
                    }
                    return "Incorrect DNS SRV settings" + String.valueOf(Arrays.asList(entries)) + ", invalid addresses: " + String.valueOf(invalidAddresses);
                }
            }
            catch (UnknownHostException entries) {
                // empty catch block
            }
            try {
                String[] ipAddress = DNSResolverFactory.getInstance().getHostIPs(item.getKey());
                if (ipAddress != null) {
                    List invalidAddresses = Arrays.stream(ipAddress).filter(ip -> !installationIpAddressesList.contains(ip)).collect(Collectors.toList());
                    if (invalidAddresses.isEmpty()) {
                        return null;
                    }
                    return "Incorrect IP address: '" + String.valueOf(ipAddress) + "' found in DNS for the given host: " + item.getKey();
                }
                return "No DNS settings found for given host: " + item.getKey();
            }
            catch (UnknownHostException ex1) {
                try {
                    return "There is no DNS settings for given host: " + item.getKey();
                }
                catch (UnknownHostException ex) {
                    return "There is no DNS settings for load balancer DNS name: " + this.installationDnsAddress;
                }
            }
        }
        try {
            DNSEntry[] entries = DNSResolverFactory.getInstance().getHostSRV_Entries(item.getKey());
            if (entries != null) {
                for (DNSEntry dNSEntry : entries) {
                    log.finest("Validating DNS SRV settings ('" + String.valueOf(dNSEntry) + "') for the given hostname: " + item.getKey() + " (defaults: " + this.def_ip_address + ", " + this.def_srv_address);
                    if (!Arrays.asList(dNSEntry.getIps()).contains(this.def_ip_address) && !this.def_srv_address.equals(dNSEntry.getDnsResultHost())) continue;
                    return null;
                }
                return "Incorrect DNS SRV settings" + String.valueOf(Arrays.asList(entries));
            }
        }
        catch (UnknownHostException entries) {
            // empty catch block
        }
        try {
            String[] ipAddress = DNSResolverFactory.getInstance().getHostIPs(item.getKey());
            if (ipAddress != null) {
                if (Arrays.asList(ipAddress).contains(this.def_ip_address)) {
                    return null;
                }
                return "Incorrect IP address: '" + String.valueOf(Arrays.asList(ipAddress)) + "' found in DNS for the given host: " + item.getKey();
            }
            return "No DNS settings found for given host: " + item.getKey();
        }
        catch (UnknownHostException ex1) {
            return "There is no DNS settings for given host: " + item.getKey();
        }
    }

    @Override
    public void setDataSource(DataSource dataSource) {
    }

    public String getMainVHostName() {
        return this.mainVHostName;
    }

    public void setMainVHostName(String vhost) {
        this.mainVHostName = vhost;
        this.reloadIfReady();
    }

    @Override
    public VHostItem getDefaultVHostItem() {
        return (VHostItem)this.getItem(this.getMainVHostName());
    }

    public void setExtensionManager(VHostItemExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
        this.reloadIfReady();
    }

    @Override
    public void setItemsOld(String[] items_arr) {
        if (this.vhostDefaultValues == null) {
            this.pendingItemsToSetOld = items_arr;
        } else {
            super.setItemsOld(items_arr);
            super.reload();
        }
    }

    public void setVhostDefaultValues(VHostItemDefaults vhostDefaultValues) {
        this.vhostDefaultValues = vhostDefaultValues;
        if (this.pendingItemsToSetOld != null) {
            this.setItemsOld(this.pendingItemsToSetOld);
            this.pendingItemsToSetOld = null;
        }
        this.setMainVHostName(this.mainVHostName);
    }

    private void reloadIfReady() {
        if (this.vhostDefaultValues != null && this.extensionManager != null) {
            this.reload();
            if (!this.contains(this.mainVHostName)) {
                VHostItem item = this.getItemInstance();
                item.setKey(this.mainVHostName);
                if (item instanceof VHostItemImpl.VHostItemWrapper) {
                    ((VHostItemImpl.VHostItemWrapper)item).readOnly();
                }
                this.addItem(item);
            }
        }
    }
}

