/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.setup;

import java.util.Arrays;
import java.util.List;
import tigase.cluster.ClusterConnectionManager;
import tigase.cluster.ClusterController;
import tigase.disteventbus.component.EventBusComponent;
import tigase.kernel.beans.Bean;
import tigase.server.MessageRouter;
import tigase.server.ServerComponent;
import tigase.server.xmppsession.SessionManager;
import tigase.stats.StatisticsCollector;
import tigase.vhosts.VHostManager;

public class BeanDefinition {
    public static final List<Class<? extends ServerComponent>> CORE_COMPONENTS = Arrays.asList(SessionManager.class, VHostManager.class, MessageRouter.class, ClusterConnectionManager.class, ClusterController.class, EventBusComponent.class, EventBusComponent.class, StatisticsCollector.class);
    private final boolean active;
    private final Class<?> clazz;
    private final String name;

    public BeanDefinition(Class<?> cls) {
        Bean bean = cls.getAnnotation(Bean.class);
        this.name = bean.name();
        this.clazz = cls;
        this.active = bean.active();
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isCoreComponent() {
        return CORE_COMPONENTS.contains(this.clazz) || CORE_COMPONENTS.stream().filter(cmp -> cmp.isAssignableFrom(this.clazz)).findAny().isPresent();
    }
}

