/*
 * Decompiled with CFR 0.152.
 */
package tigase.sys;

import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public class NMTScope {
    Long arena;
    Long committed;
    Long malloc;
    Long mmapCommitted;
    Long mmapReserved;
    Long reserved;
    String scopeType;

    NMTScope(String scopeType, Long reserved, Long committed) {
        this(scopeType, reserved, committed, null, null, null, null);
    }

    NMTScope(String scopeType, Long reserved, Long committed, Long malloc, Long mmapReserved, Long mmapCommitted, Long arena) {
        Objects.nonNull(scopeType);
        this.scopeType = scopeType;
        Objects.nonNull(reserved);
        this.reserved = reserved;
        Objects.nonNull(committed);
        this.committed = committed;
        this.malloc = malloc;
        this.mmapReserved = mmapReserved;
        this.mmapCommitted = mmapCommitted;
        this.arena = arena;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public Long getReserved() {
        return this.reserved;
    }

    public Long getCommitted() {
        return this.committed;
    }

    public Optional<Long> getMalloc() {
        return Optional.ofNullable(this.malloc);
    }

    public Optional<Long> getMmapReserved() {
        return Optional.ofNullable(this.mmapReserved);
    }

    public Optional<Long> getMmapCommitted() {
        return Optional.ofNullable(this.mmapCommitted);
    }

    public Optional<Long> getArena() {
        return Optional.ofNullable(this.arena);
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", this.scopeType + " (KB): ", "").add("reserved=" + this.reserved).add("committed=" + this.committed);
        this.getMalloc().ifPresent(val -> joiner.add("malloc=" + val));
        this.getMmapReserved().ifPresent(val -> joiner.add("mmapReserved=" + val));
        this.getMmapCommitted().ifPresent(val -> joiner.add("mmapCommitted=" + val));
        this.getArena().ifPresent(val -> joiner.add("arena=" + val));
        return joiner.toString();
    }

    static final class NMTScopeBuilder {
        Long arena;
        Long committed;
        Long malloc;
        Long mmapCommitted;
        Long mmapReserved;
        Long reserved;
        String scopeType;

        static NMTScopeBuilder aNMTScope(String scopeType, Long reserved, Long committed) {
            return new NMTScopeBuilder(scopeType, reserved, committed);
        }

        private NMTScopeBuilder(String scopeType, Long reserved, Long committed) {
            Objects.nonNull(scopeType);
            this.scopeType = scopeType;
            Objects.nonNull(reserved);
            this.reserved = reserved;
            Objects.nonNull(committed);
            this.committed = committed;
        }

        NMTScopeBuilder withMalloc(Long malloc) {
            this.malloc = malloc;
            return this;
        }

        NMTScopeBuilder withMmapReserved(Long mmapReserved) {
            this.mmapReserved = mmapReserved;
            return this;
        }

        NMTScopeBuilder withMmapCommitted(Long mmapCommitted) {
            this.mmapCommitted = mmapCommitted;
            return this;
        }

        NMTScopeBuilder withArena(Long arena) {
            this.arena = arena;
            return this;
        }

        NMTScope build() {
            return new NMTScope(this.scopeType, this.reserved, this.committed, this.malloc, this.mmapReserved, this.mmapCommitted, this.arena);
        }
    }

    static enum COMMON_SCOPES {
        TOTAL("Total"),
        JAVA_HEAP("Java Heap"),
        CLASS("Class"),
        THREAD("Thread"),
        CODE("Code"),
        GC("GC"),
        COMPILER("Compiler"),
        INTERNAL("Internal"),
        OTHER("Other"),
        SYMBOL("Symbol"),
        NATIVE_MEMORY_TRACKING("Native Memory Tracking"),
        ARENA_CHUNK("Arena Chunk"),
        LOGGING("Logging"),
        ARGUMENTS("Arguments"),
        MODULE("Module"),
        SYNCHRONIZER("Synchronizer"),
        SAFEPOINT("Safepoint");

        String name;

        private COMMON_SCOPES(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

