/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import tigase.stats.StatisticsList;

public class StatisticsInvocationHandler<S>
implements InvocationHandler {
    private final S instance;
    private final Class[] monitoredIfcs;
    private final String name;
    private final ConcurrentHashMap<Method, MethodStatistics> statistics = new ConcurrentHashMap();

    public StatisticsInvocationHandler(String name, S instance, Class ... monitoredIfcs) {
        this.name = name;
        this.instance = instance;
        for (Class clazz : this.monitoredIfcs = monitoredIfcs) {
            for (Method m : clazz.getDeclaredMethods()) {
                this.statistics.put(m, new MethodStatistics(m));
            }
        }
    }

    public void everyHour() {
        this.statistics.values().forEach(Statistics::everyHour);
    }

    public void everyMinute() {
        this.statistics.values().forEach(Statistics::everyMinute);
    }

    public void everySecond() {
        this.statistics.values().forEach(Statistics::everySecond);
    }

    public void getStatistics(String compName, String prefix, StatisticsList list) {
        String subprefix = prefix != null ? prefix + "/" + this.name : this.name;
        this.statistics.values().forEach(methodStatistics -> methodStatistics.getStatistics(compName, subprefix, list));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodStatistics methodStatistics = this.statistics.get(method);
        if (methodStatistics != null) {
            long start = System.currentTimeMillis();
            try {
                Object object = method.invoke(this.instance, args);
                return object;
            }
            catch (Throwable ex) {
                methodStatistics.executionFailed();
                if (ex instanceof UndeclaredThrowableException) {
                    ex = ((UndeclaredThrowableException)ex).getUndeclaredThrowable();
                }
                if (ex instanceof InvocationTargetException) {
                    throw ((InvocationTargetException)ex).getTargetException();
                }
                throw ex;
            }
            finally {
                methodStatistics.updateExecutionTime(System.currentTimeMillis() - start);
            }
        }
        try {
            return method.invoke(this.instance, args);
        }
        catch (Throwable ex) {
            if (ex instanceof UndeclaredThrowableException) {
                ex = ((UndeclaredThrowableException)ex).getUndeclaredThrowable();
            }
            if (ex instanceof InvocationTargetException) {
                throw ((InvocationTargetException)ex).getTargetException();
            }
            throw ex;
        }
    }

    public static class MethodStatistics
    extends Statistics {
        private final Method method;

        private static String generateMethodName(Method method) {
            StringBuilder sb = new StringBuilder(method.getName());
            sb.append("(");
            boolean first = true;
            for (Class<?> parameter : method.getParameterTypes()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(parameter.getSimpleName());
            }
            sb.append(")");
            return sb.toString();
        }

        public MethodStatistics(Method method) {
            super(MethodStatistics.generateMethodName(method));
            this.method = method;
        }
    }

    public static class Statistics {
        private final String name;
        private long avgProcessingTime = 0L;
        private long exceptions_counter = 0L;
        private long executions_counter = 0L;
        private long last_hour_counter = 0L;
        private long last_minute_counter = 0L;
        private long last_second_counter = 0L;
        private long per_hour = 0L;
        private long per_minute = 0L;
        private long per_second = 0L;

        public Statistics(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public synchronized void everyHour() {
            this.per_hour = this.executions_counter - this.last_hour_counter;
            this.last_hour_counter = this.executions_counter;
        }

        public synchronized void everyMinute() {
            this.per_minute = this.executions_counter - this.last_minute_counter;
            this.last_minute_counter = this.executions_counter;
        }

        public synchronized void everySecond() {
            this.per_second = this.executions_counter - this.last_second_counter;
            this.last_second_counter = this.executions_counter;
        }

        public void getStatistics(String compName, String prefix, StatisticsList list) {
            if (list.checkLevel(Level.FINEST)) {
                list.add(compName, prefix + "/" + this.getName() + "/Excutions last hour", this.per_hour, Level.FINEST);
                list.add(compName, prefix + "/" + this.getName() + "/Excutions last minute", this.per_minute, Level.FINEST);
                list.add(compName, prefix + "/" + this.getName() + "/Excutions last second", this.per_second, Level.FINEST);
            }
            list.add(compName, prefix + "/" + this.getName() + "/Average processing time", this.avgProcessingTime, Level.FINE);
            list.add(compName, prefix + "/" + this.getName() + "/Executions", this.executions_counter, Level.FINE);
            list.add(compName, prefix + "/" + this.getName() + "/Exceptions during execution", this.exceptions_counter, Level.FINE);
        }

        public void updateExecutionTime(long executionTime) {
            ++this.executions_counter;
            this.avgProcessingTime = (this.avgProcessingTime + executionTime) / 2L;
        }

        public void executionFailed() {
            ++this.exceptions_counter;
        }
    }
}

