/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver.proc;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.net.ConnectionType;
import tigase.server.Packet;
import tigase.server.xmppserver.CID;
import tigase.server.xmppserver.CIDConnections;
import tigase.server.xmppserver.KnownDomainsListProvider;
import tigase.server.xmppserver.S2SConnection;
import tigase.server.xmppserver.S2SConnectionManager;
import tigase.server.xmppserver.S2SIOService;
import tigase.server.xmppserver.proc.AuthenticationProcessor;
import tigase.stats.StatisticsList;
import tigase.stats.StatisticsProviderIfc;

@Bean(name="authenticator-selector-manager", parent=S2SConnectionManager.class, active=true)
public class AuthenticatorSelectorManager
implements StatisticsProviderIfc {
    public static final String S2S_METHOD_USED = "S2S_METHOD_USED";
    public static final String S2S_METHODS_ADVERTISED = "S2S_METHODS_ADVERTISED";
    public static final String S2S_METHODS_AVAILABLE = "S2S_METHODS_AVAILABLE";
    private static final Logger log = Logger.getLogger(AuthenticatorSelectorManager.class.getName());
    @Inject
    public List<AuthenticationProcessor> authenticationProcessors;
    private Map<String, AtomicInteger> failedAuthenticationDomains = new ConcurrentHashMap<String, AtomicInteger>();
    @Inject
    private KnownDomainsListProvider knownDomainsListProvider;

    public boolean isAllowed(Packet p, S2SIOService serv, AuthenticationProcessor processor, Queue<Packet> results) {
        boolean authenticated = serv.isAuthenticated();
        SortedSet<AuthenticationProcessor> methodsAvailable = this.getAuthenticationProcessors(serv);
        Optional<AuthenticationProcessor> currentAuthenticationProcessor = this.getCurrentAuthenticationProcessor(serv);
        if (authenticated) {
            log.log(Level.FINE, "Connection already authenticated, skipping processor: {1}, methodsAvailable: {2}, checking packet: {3} [{0}]", new Object[]{serv, processor, methodsAvailable, p});
            return false;
        }
        log.log(Level.FINE, "Processor {1}, methodsAvailable: {2}, checking packet: {3} [{0}]", new Object[]{serv, processor.getMethodName(), methodsAvailable, p});
        boolean canHandle = processor.canHandle(p, serv, results);
        if (canHandle) {
            methodsAvailable.add(processor);
        }
        boolean result = !currentAuthenticationProcessor.isPresent() && canHandle;
        log.log(Level.FINEST, "Processor {1}, canHandle: {2}, currentAuthenticationProcessor: {3}, result: {4}, methodsAvailable: {5}, packet: {6} [{0}]", new Object[]{serv, processor.getMethodName(), canHandle, currentAuthenticationProcessor, result, methodsAvailable, p});
        if (result) {
            methodsAvailable.remove(processor);
            serv.getSessionData().put(S2S_METHOD_USED, processor);
            log.log(Level.FINE, "Allowing auth for: {1}, remaining: {2} [{0}]", new Object[]{serv, processor.getMethodName(), methodsAvailable});
        }
        return result;
    }

    public void authenticateConnection(String sessionId, CIDConnections cid_conns, CID cidPacket) {
        S2SConnection s2s_conn = cid_conns.getS2SConnectionForSessionId(sessionId);
        if (s2s_conn != null) {
            this.authenticateConnection(s2s_conn.getS2SIOService(), cid_conns, cidPacket);
        }
    }

    public void authenticateConnection(S2SIOService serv, CIDConnections cid_conns, CID cidPacket) {
        log.log(Level.FINE, "Authenticating connection [{0}]", new Object[]{serv});
        serv.getSessionData().remove(S2S_METHOD_USED);
        cid_conns.connectionAuthenticated(serv, cidPacket);
        this.knownDomainsListProvider.addRemoteDomain(cidPacket.getRemoteHost());
    }

    @Override
    public void getStatistics(String compName, StatisticsList list) {
        String keyName = compName + "/AuthenticationFailures";
        for (Map.Entry<String, AtomicInteger> entry : this.failedAuthenticationDomains.entrySet()) {
            list.add(keyName, entry.getKey(), entry.getValue().intValue(), Level.FINER);
        }
    }

    public void authenticationFailed(Packet packet, S2SIOService serv, AuthenticationProcessor processor, Queue<Packet> results) {
        this.markConnectionAsFailed(processor.getMethodName(), serv);
        serv.getSessionData().remove(S2S_METHOD_USED);
        SortedSet<AuthenticationProcessor> methodsAvailable = this.getAuthenticationProcessors(serv);
        methodsAvailable.remove(processor);
        log.log(Level.FINE, "Authentication failed for: {1}, remaining methodsAvailable: {2} [{0}]", new Object[]{serv, processor.getMethodName(), methodsAvailable});
        if (methodsAvailable.isEmpty()) {
            log.log(Level.WARNING, "All authentication methods failed, stopping connection [{0}]", new Object[]{serv});
            this.flushRemainingPackets(serv, results);
            serv.forceStop();
        }
        if (serv.connectionType() == ConnectionType.connect) {
            Optional nextAuthenticationProcessor = methodsAvailable.stream().findFirst();
            if (nextAuthenticationProcessor.isPresent()) {
                log.log(Level.FINE, "Restarting authentication with: {1} [{0}]", new Object[]{serv, ((AuthenticationProcessor)nextAuthenticationProcessor.get()).getMethodName()});
                methodsAvailable.remove(nextAuthenticationProcessor.get());
                ((AuthenticationProcessor)nextAuthenticationProcessor.get()).restartAuth(packet, serv, results);
            } else {
                log.log(Level.WARNING, "No more authenticators for outgoing connections, stopping [{0}]", new Object[]{serv});
                this.flushRemainingPackets(serv, results);
                serv.forceStop();
            }
        }
    }

    public void markConnectionAsFailed(String prefix, S2SIOService serv) {
        CID cid = (CID)serv.getSessionData().get("cid");
        log.log(Level.FINEST, () -> "Adding entry to stats, prefix: " + prefix + ", cid: " + String.valueOf(cid));
        this.failedAuthenticationDomains.computeIfAbsent(prefix + "/" + String.valueOf(cid), s -> new AtomicInteger()).incrementAndGet();
    }

    SortedSet<AuthenticationProcessor> getAuthenticationProcessors(S2SIOService serv) {
        SortedSet<AuthenticationProcessor> mechanisms = (SortedSet<AuthenticationProcessor>)serv.getSessionData().get(S2S_METHODS_AVAILABLE);
        if (mechanisms == null) {
            mechanisms = this.getAuthenticationProcessors();
            serv.getSessionData().put(S2S_METHODS_AVAILABLE, mechanisms);
        }
        return mechanisms;
    }

    private void flushRemainingPackets(S2SIOService serv, Queue<Packet> results) {
        for (Packet result : results) {
            serv.addPacketToSend(result);
        }
        try {
            serv.processWaitingPackets();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Error while writing packets before closing the stream [" + String.valueOf(serv) + "]", e);
        }
    }

    private SortedSet<AuthenticationProcessor> getAuthenticationProcessors() {
        log.log(Level.FINEST, "preparing empty processor list!");
        return new ConcurrentSkipListSet<AuthenticationProcessor>();
    }

    public void setAuthenticationProcessors(List<AuthenticationProcessor> authenticationProcessors) {
        this.authenticationProcessors = new CopyOnWriteArrayList<AuthenticationProcessor>(authenticationProcessors);
    }

    private Optional<AuthenticationProcessor> getCurrentAuthenticationProcessor(S2SIOService serv) {
        return Optional.ofNullable((AuthenticationProcessor)serv.getSessionData().get(S2S_METHOD_USED));
    }
}

