/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.JID;

public enum StreamManagementCommand {
    ENABLE,
    ENABLED,
    MOVE_STREAM,
    STREAM_MOVED;

    private static final Map<String, StreamManagementCommand> COMMANDS;
    private final String cmdId = this.name().toLowerCase().replace('_', '-');

    public static StreamManagementCommand fromPacket(Packet packet) {
        return StreamManagementCommand.valueof(Command.getFieldValue(packet, "cmd"));
    }

    public static StreamManagementCommand valueof(String cmdId) {
        return COMMANDS.get(cmdId);
    }

    public Packet create(JID from, JID to) {
        Packet packet = Command.STREAM_MOVED.getPacket(from, to, StanzaType.set, UUID.randomUUID().toString());
        Command.addFieldValue(packet, "cmd", this.getId());
        return packet;
    }

    public String getId() {
        return this.cmdId;
    }

    static {
        COMMANDS = Arrays.stream(StreamManagementCommand.values()).collect(Collectors.toMap(StreamManagementCommand::getId, Function.identity()));
    }
}

