/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.test;

import java.util.Arrays;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.component.exceptions.ComponentException;
import tigase.component.modules.AbstractModule;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.criteria.Or;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.test.TestComponent;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.JID;

@Bean(name="test-spam-module", parent=TestComponent.class, active=true)
public class TestSpamModule
extends AbstractModule {
    private static final Logger log = Logger.getLogger(TestSpamModule.class.getCanonicalName());
    private static final String BAD_WORDS_KEY = "bad-words";
    private static final String WHITELIST_KEY = "white-list";
    @ConfigField(desc="Bad words", alias="bad-words")
    protected String[] badWords = new String[]{"word1", "word2", "word3"};
    @ConfigField(desc="White listed addresses", alias="white-list")
    protected String[] whiteList = new String[]{"admin@localhost"};
    private Criteria CRITERIA = ElementCriteria.name((String)"message");
    @ConfigField(desc="Abuse notification address", alias="abuse-address")
    private JID abuseAddress = JID.jidInstanceNS((String)"abuse@locahost");
    @Inject
    private TestComponent component;
    private int delayCounter = 0;
    private long messagesCounter = 0L;
    @ConfigField(desc="Frequency of notification", alias="notification-frequency")
    private int notificationFrequency = 10;
    @ConfigField(desc="Logged packet types", alias="packet-types")
    private String[] packetTypes = new String[]{"message", "presence", "iq"};
    @ConfigField(desc="Prefix", alias="log-prepend")
    private String prependText = "Spam detected: ";
    @ConfigField(desc="Secure logging", alias="secure-logging")
    private boolean secureLogging = false;
    private long spamCounter = 0L;
    private long totalSpamCounter = 0L;

    public void everyMinute() {
        if (++this.delayCounter >= this.notificationFrequency) {
            this.write(Message.getMessage(this.abuseAddress, this.component.getComponentId(), StanzaType.chat, "Detected spam messages: " + this.spamCounter, "Spam counter", null, this.component.newPacketId("spam-")));
            this.delayCounter = 0;
            this.spamCounter = 0L;
        }
    }

    @Override
    public Criteria getModuleCriteria() {
        return this.CRITERIA;
    }

    @Override
    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        if ("message" == packet.getElemName()) {
            String body;
            ++this.messagesCounter;
            String from = packet.getStanzaFrom().toString();
            if (Arrays.binarySearch(this.whiteList, from) < 0 && (body = packet.getElemCDataStaticStr(Message.MESSAGE_BODY_PATH)) != null && !body.isEmpty()) {
                body = body.toLowerCase();
                for (String word : this.badWords) {
                    if (!body.contains(word)) continue;
                    log.finest(this.prependText + packet.toString(this.secureLogging));
                    ++this.spamCounter;
                    this.component.updateServiceDiscoveryItem(this.component.getName(), "spam", "Spam caught: [" + ++this.totalSpamCounter + "]", true);
                    return;
                }
            }
        }
        Packet result = packet.swapFromTo();
        this.write(result);
    }

    public long getMessagesCounter() {
        return this.messagesCounter;
    }

    public long getTotalSpamCounter() {
        return this.totalSpamCounter;
    }

    public void setPacketTypes(String[] packetTypes) {
        this.packetTypes = packetTypes;
        Or crit = new Or(new Criteria[0]);
        for (String packetType : packetTypes) {
            crit.add((Criteria)ElementCriteria.name((String)packetType));
        }
        this.CRITERIA = crit;
    }

    public void initBindings(Bindings binds) {
        binds.put(BAD_WORDS_KEY, (Object)this.badWords);
        binds.put(WHITELIST_KEY, (Object)this.whiteList);
    }
}

