/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.filters;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.core.Kernel;
import tigase.server.AbstractMessageReceiver;
import tigase.server.PacketFilterIfc;
import tigase.server.QueueType;

public class PacketFiltersBean
implements RegistrarBean {
    private final QueueType queueType;
    private String name;
    @Inject
    private CopyOnWriteArrayList<PacketFilterIfc> filters = new CopyOnWriteArrayList();

    protected PacketFiltersBean(QueueType queueType) {
        this.queueType = queueType;
    }

    public void setName(String name) {
        this.name = name;
        this.initializeFilters();
    }

    public void setFilters(List<PacketFilterIfc> filters) {
        this.filters = new CopyOnWriteArrayList<PacketFilterIfc>(filters);
        this.initializeFilters();
    }

    public List<PacketFilterIfc> getFilters() {
        return this.filters;
    }

    @Override
    public void register(Kernel kernel) {
    }

    @Override
    public void unregister(Kernel kernel) {
    }

    protected void initializeFilters() {
        this.filters.forEach(filter -> filter.init(Optional.ofNullable(this.name).orElse("UNKNOWN"), this.queueType));
    }

    @Bean(name="outgoingFilters", parent=AbstractMessageReceiver.class, active=true)
    public static class OutgoingPacketFiltersBean
    extends PacketFiltersBean {
        public OutgoingPacketFiltersBean() {
            super(QueueType.OUT_QUEUE);
        }
    }

    @Bean(name="incomingFilters", parent=AbstractMessageReceiver.class, active=true)
    public static class IncomingPacketFiltersBean
    extends PacketFiltersBean {
        public IncomingPacketFiltersBean() {
            super(QueueType.IN_QUEUE);
        }
    }
}

