/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.amp.cond;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.amp.ConditionIfc;
import tigase.xml.Element;

public class ExpireAt
implements ConditionIfc {
    public static final String NAME = "expire-at";
    private static Logger log = Logger.getLogger(ExpireAt.class.getName());
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private final SimpleDateFormat formatter2;

    public ExpireAt() {
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.formatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        this.formatter2.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean match(Packet packet, Element rule) {
        String value = rule.getAttributeStaticStr("value");
        if (value != null) {
            try {
                Date val_date = null;
                if (value.contains(".")) {
                    SimpleDateFormat simpleDateFormat = this.formatter;
                    synchronized (simpleDateFormat) {
                        val_date = this.formatter.parse(value);
                    }
                }
                SimpleDateFormat simpleDateFormat = this.formatter2;
                synchronized (simpleDateFormat) {
                    val_date = this.formatter2.parse(value);
                }
                return val_date.before(new Date());
            }
            catch (ParseException ex) {
                log.log(Level.CONFIG, "Incorrect expire-at condition value for rule: " + String.valueOf(rule));
            }
        } else {
            log.log(Level.CONFIG, "No value set for rule: " + String.valueOf(rule));
        }
        return false;
    }
}

