/*
 * Decompiled with CFR 0.152.
 */
package tigase.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.TrustManager;
import org.jspecify.annotations.Nullable;
import tigase.annotations.TigaseDeprecated;
import tigase.cert.CertCheckResult;
import tigase.cert.CertificateUtil;
import tigase.io.BufferUnderflowException;
import tigase.io.CertificateContainerIfc;
import tigase.io.IOInterface;
import tigase.io.SSLContextContainerIfc;
import tigase.io.SocketIO;
import tigase.io.TLSEventHandler;
import tigase.io.TLSIO;
import tigase.io.TLSWrapper;
import tigase.io.ZLibIO;
import tigase.net.ConnectionType;
import tigase.net.IOServiceListener;
import tigase.stats.StatisticsList;
import tigase.util.IOListener;
import tigase.xmpp.jid.JID;

public abstract class IOService<RefObject>
implements Callable<IOService<?>>,
TLSEventHandler,
IOListener {
    public static final String CERT_CHECK_RESULT = "cert-check-result";
    public static final String LOCAL_CERT_CHECK_RESULT = "local-cert-check-result";
    public static final String CERT_REQUIRED_DOMAIN = "cert-required-domain";
    public static final String HOSTNAME_KEY = "hostname-key";
    public static final String PORT_TYPE_PROP_KEY = "type";
    public static final String SESSION_ID_KEY = "sessionID";
    public static final String SSL_PROTOCOLS_KEY = "ssl-protocols";
    private static final Logger log = Logger.getLogger(IOService.class.getName());
    private static final long MAX_ALLOWED_EMPTY_CALLS = 1000L;
    private final ReentrantLock readInProgress = new ReentrantLock();
    private final ReentrantLock writeInProgress = new ReentrantLock();
    protected CharBuffer cb = CharBuffer.allocate(2048);
    protected CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
    protected CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
    protected byte[] partialCharacterBytes = null;
    private int bufferLimit = 0;
    private CertificateContainerIfc certificateContainer;
    private JID connectionId = null;
    private @Nullable ConnectionType connectionType = null;
    private JID dataReceiver = null;
    private long empty_read_call_count = 0L;
    private String id = null;
    private long lastTransferTime = 0L;
    private Certificate localCertificate;
    private String local_address = null;
    private Certificate peerCertificate;
    private long[] rdData = new long[60];
    private RefObject refObject = null;
    private String remote_address = null;
    private IOServiceListener<IOService<RefObject>> serviceListener = null;
    private ConcurrentMap<String, Object> sessionData = new ConcurrentHashMap<String, Object>(4, 0.75f, 4);
    private IOInterface socketIO = null;
    private ByteBuffer socketInput = null;
    private int socketInputSize = 2048;
    private boolean socketServiceReady = false;
    private SSLContextContainerIfc sslContextContainer;
    private boolean stopping = false;
    private byte[] tlsUniqueId;
    private byte[] tlsExporter;
    private long[] wrData = new long[60];
    private TrustManager[] x509TrustManagers;

    private static String getRemoteHostname(IOService ios) {
        String tls_hostname = (String)ios.getSessionData().get(HOSTNAME_KEY);
        String tls_remote_hostname = (String)ios.getSessionData().get("remote-host");
        if (tls_remote_hostname == null && (tls_remote_hostname = (String)ios.getSessionData().get("remote-hostname")) == null) {
            tls_remote_hostname = tls_hostname;
        }
        return tls_remote_hostname;
    }

    @Deprecated
    @TigaseDeprecated(since="8.3.0", removeIn="9.0.0", note="Please use version with 'socketInputSize' parameter")
    public void accept(SocketChannel socketChannel) throws IOException {
        this.accept(socketChannel, socketChannel.socket().getReceiveBufferSize());
    }

    public void accept(SocketChannel socketChannel, Integer socketInputSize) throws IOException {
        try {
            if (socketChannel.isConnectionPending()) {
                socketChannel.finishConnect();
            }
            this.socketIO = new SocketIO(socketChannel);
        }
        catch (IOException e) {
            String host = (String)this.sessionData.get("remote-hostname");
            if (host == null) {
                host = (String)this.sessionData.get("remote-host");
            }
            String sock_str = null;
            try {
                sock_str = socketChannel.socket().toString();
            }
            catch (Exception ex) {
                sock_str = ex.toString();
            }
            log.log(Level.FINER, "Problem connecting to remote host: {0}, address: {1}, socket: {2} - exception: {3}, session data: {4}", new Object[]{host, this.remote_address, sock_str, e, this.sessionData});
            throw e;
        }
        this.socketInputSize = socketInputSize;
        this.socketInput = ByteBuffer.allocate(socketInputSize);
        this.socketInput.order(this.byteOrder());
        Socket sock = this.socketIO.getSocketChannel().socket();
        this.local_address = sock.getLocalAddress().getHostAddress();
        this.remote_address = sock.getInetAddress().getHostAddress();
        this.id = this.local_address + "_" + sock.getLocalPort() + "_" + this.remote_address + "_" + sock.getPort();
        this.setLastTransferTime();
    }

    @Override
    public IOService<?> call() throws IOException {
        this.writeData(null);
        boolean readLock = true;
        if (this.stopping) {
            this.stop();
        } else {
            readLock = this.readInProgress.tryLock();
            if (readLock) {
                try {
                    this.processSocketData();
                    if (this.receivedPackets() > 0 && this.serviceListener != null) {
                        this.serviceListener.packetsReady(this);
                    }
                }
                finally {
                    this.readInProgress.unlock();
                    if (!this.isConnected()) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Stopping connection due to the fact that it was disconnected, forceStop() [{0}]", this.toString());
                        }
                        this.forceStop();
                    }
                }
            }
        }
        return readLock && this.socketServiceReady ? this : null;
    }

    public boolean checkBufferLimit(int bufferSize) {
        return this.bufferLimit == 0 || bufferSize <= this.bufferLimit;
    }

    public ConnectionType connectionType() {
        return this.connectionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceStop() {
        block16: {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Force stop called... Socket: {0}, ", this.socketIO);
            }
            try {
                if (this.socketIO == null || !this.socketIO.isConnected()) break block16;
                IOInterface iOInterface = this.socketIO;
                synchronized (iOInterface) {
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Calling stop on: {0}", this.socketIO);
                    }
                    this.socketIO.stop();
                }
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Socket: " + String.valueOf(this.socketIO) + ", Exception while stopping service: " + String.valueOf(this.connectionId), e);
                }
            }
            finally {
                if (this.serviceListener != null) {
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Calling stop on the listener: {0}", this.serviceListener);
                    }
                    IOServiceListener<IOService<RefObject>> tmp = this.serviceListener;
                    this.serviceListener = null;
                    if (tmp != null) {
                        tmp.serviceStopped(this);
                    }
                } else if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Service listener is null: {0}", this.socketIO);
                }
            }
        }
    }

    @Override
    public void handshakeCompleted(TLSWrapper wrapper) {
        Certificate[] certs;
        CertCheckResult certCheckResult;
        block17: {
            String reqCertDomain = (String)this.getSessionData().get(CERT_REQUIRED_DOMAIN);
            certCheckResult = wrapper.getCertificateStatus(false, this.sslContextContainer);
            if (reqCertDomain != null) {
                try {
                    certs = wrapper.getPeerCertificates();
                    if (certs != null && certs.length > 0) {
                        Certificate peerCert = certs[0];
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "TLS handshake verifying if certificate from connection matches domain {1} [{0}]", new Object[]{this, reqCertDomain});
                        }
                        if (!CertificateUtil.verifyCertificateForDomain((X509Certificate)((X509Certificate)peerCert), (String)reqCertDomain)) {
                            certCheckResult = CertCheckResult.invalid;
                            if (log.isLoggable(Level.FINEST)) {
                                log.log(Level.FINEST, "TLS handshake: certificate doesn't match domain) [{0}]", new Object[]{this});
                            }
                        }
                    }
                }
                catch (Exception e) {
                    certCheckResult = CertCheckResult.invalid;
                    if (!log.isLoggable(Level.CONFIG)) break block17;
                    log.log(Level.CONFIG, "Certificate validation failed, CertCheckResult: " + String.valueOf(certCheckResult) + ") [" + String.valueOf(this) + "]", e);
                }
            }
        }
        this.sessionData.put(CERT_CHECK_RESULT, certCheckResult);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "TLS handshake completed: {1} [{0}]", new Object[]{this, certCheckResult});
        }
        if (!wrapper.isClientMode()) {
            this.tlsUniqueId = wrapper.getTlsUniqueBindingData();
        }
        if (!wrapper.isClientMode()) {
            this.tlsExporter = wrapper.getTlsExporterBindingData();
        }
        try {
            certs = wrapper.getLocalCertificates();
            Certificate certificate = this.localCertificate = certs == null || certs.length == 0 ? null : certs[0];
            if (certs != null) {
                KeyStore trustStore = this.sslContextContainer.getTrustStore();
                CertCheckResult checkResult = CertificateUtil.validateCertificate((Certificate[])certs, (KeyStore)trustStore, (boolean)false);
                this.sessionData.put(LOCAL_CERT_CHECK_RESULT, checkResult);
            }
        }
        catch (Exception e) {
            this.localCertificate = null;
            log.log(Level.WARNING, "Cannot get local certificate", e);
        }
        if (!wrapper.isClientMode() && (wrapper.wantClientAuth() || wrapper.isNeedClientAuth())) {
            try {
                certs = wrapper.getPeerCertificates();
                this.peerCertificate = certs[0];
            }
            catch (SSLPeerUnverifiedException e) {
                this.peerCertificate = null;
            }
            catch (Exception e) {
                this.peerCertificate = null;
                log.log(Level.WARNING, "Problem with extracting subjectAltName", e);
            }
        }
        this.serviceListener.tlsHandshakeCompleted(this);
    }

    public abstract void processWaitingPackets() throws IOException;

    public void startSSL(boolean clientMode, boolean wantClientAuth, boolean needClientAuth) throws IOException {
        if (this.socketIO instanceof TLSIO) {
            throw new IllegalStateException("SSL mode is already activated.");
        }
        if (this.sslContextContainer == null) {
            throw new IllegalStateException("SSL cannot be activated - sslContextContainer is not set for " + String.valueOf(this.connectionId));
        }
        String tls_hostname = null;
        int port = 0;
        String tls_remote_hostname = null;
        if (clientMode) {
            tls_remote_hostname = IOService.getRemoteHostname(this);
            port = ((InetSocketAddress)this.socketIO.getSocketChannel().getRemoteAddress()).getPort();
        }
        this.socketIO = this.sslContextContainer.createIoInterface("SSL", tls_hostname, tls_remote_hostname, port, clientMode, wantClientAuth, needClientAuth, this.byteOrder(), this.x509TrustManagers, this, this.socketIO, this.certificateContainer);
        this.setLastTransferTime();
        this.encoder.reset();
        this.decoder.reset();
    }

    public CertificateContainerIfc getCertificateContainer() {
        return this.certificateContainer;
    }

    public void setCertificateContainer(CertificateContainerIfc certificateContainer) {
        this.certificateContainer = certificateContainer;
    }

    public void startTLS(boolean clientMode, boolean wantClientAuth, boolean needClientAuth) throws IOException {
        if (this.socketIO.checkCapabilities("tls-caps")) {
            throw new IllegalStateException("TLS mode is already activated " + String.valueOf(this.connectionId));
        }
        if (this.sslContextContainer == null) {
            throw new IllegalStateException("TLS cannot be activated - sslContextContainer is not set for " + String.valueOf(this.connectionId));
        }
        int counter = 0;
        while (this.isConnected() && this.waitingToSend() && ++counter < 10) {
            this.writeData(null);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (counter >= 10) {
            this.stop();
        } else {
            String tls_hostname = (String)this.sessionData.get(HOSTNAME_KEY);
            String tls_remote_hostname = null;
            int port = 0;
            if (clientMode) {
                port = ((InetSocketAddress)this.socketIO.getSocketChannel().getRemoteAddress()).getPort();
                tls_remote_hostname = IOService.getRemoteHostname(this);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Starting TLS for domain: {1} [{0}]", new Object[]{this, tls_hostname});
            }
            this.socketIO = this.sslContextContainer.createIoInterface("TLS", tls_hostname, tls_remote_hostname, port, clientMode, wantClientAuth, needClientAuth, this.byteOrder(), this.x509TrustManagers, this, this.socketIO, this.certificateContainer);
            this.setLastTransferTime();
            this.encoder.reset();
            this.decoder.reset();
        }
    }

    public void startZLib(int level) {
        if (this.socketIO.checkCapabilities("zlib-caps")) {
            throw new IllegalStateException("ZLIB mode is already activated.");
        }
        this.socketIO = new ZLibIO(this.socketIO, level);
        ((ZLibIO)this.socketIO).setIOListener(this);
    }

    public void stop() {
        if (this.socketIO != null && this.socketIO.waitingToSend()) {
            this.stopping = true;
        } else {
            this.forceStop();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", UniqueId: " + this.getUniqueId() + ", type: " + (this.connectionType != null ? this.connectionType.toStringPretty() : null) + ", " + String.valueOf(this.socketIO);
    }

    public boolean waitingToRead() {
        return true;
    }

    public boolean waitingToSend() {
        return this.socketIO.waitingToSend();
    }

    public int waitingToSendSize() {
        return this.socketIO.waitingToSendSize();
    }

    public long getBuffOverflow(boolean reset) {
        return this.socketIO.getBuffOverflow(reset);
    }

    public long getBytesReceived(boolean reset) {
        return this.socketIO.getBytesReceived(reset);
    }

    public long getBytesSent(boolean reset) {
        return this.socketIO.getBytesSent(reset);
    }

    public JID getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(JID connectionId) {
        this.connectionId = connectionId;
        this.socketIO.setLogId(connectionId.toString());
    }

    public JID getDataReceiver() {
        return this.dataReceiver;
    }

    public void setDataReceiver(JID address) {
        this.dataReceiver = address;
    }

    public long getLastTransferTime() {
        return this.lastTransferTime;
    }

    public String getLocalAddress() {
        return this.local_address;
    }

    public byte[] getTlsUniqueId() {
        return this.tlsUniqueId;
    }

    public byte[] getTlsExporter() {
        return this.tlsExporter;
    }

    public int getLocalPort() {
        Socket sock = this.socketIO.getSocketChannel().socket();
        return sock.getLocalPort();
    }

    public long[] getReadCounters() {
        return this.rdData;
    }

    public RefObject getRefObject() {
        return this.refObject;
    }

    public void setRefObject(RefObject refObject) {
        this.refObject = refObject;
    }

    public String getRemoteAddress() {
        return this.remote_address;
    }

    public ConcurrentMap<String, Object> getSessionData() {
        return this.sessionData;
    }

    public void setSessionData(Map<String, Object> props) {
        this.sessionData = new ConcurrentHashMap<String, Object>(props.size());
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            if (entry.getValue() == null) continue;
            this.sessionData.put(entry.getKey(), entry.getValue());
        }
        this.connectionType = ConnectionType.valueOf(String.valueOf(this.sessionData.get(PORT_TYPE_PROP_KEY)));
    }

    @Override
    public int getSocketInputSize() {
        return this.socketInputSize;
    }

    public SocketChannel getSocketChannel() {
        return this.socketIO.getSocketChannel();
    }

    public void getStatistics(StatisticsList list, boolean reset) {
        if (this.socketIO != null) {
            this.socketIO.getStatistics(list, reset);
        }
    }

    public long getTotalBuffOverflow() {
        return this.socketIO.getTotalBuffOverflow();
    }

    public long getTotalBytesReceived() {
        return this.socketIO.getTotalBytesReceived();
    }

    public long getTotalBytesSent() {
        return this.socketIO.getTotalBytesSent();
    }

    public String getUniqueId() {
        return this.id;
    }

    public long[] getWriteCounters() {
        return this.wrData;
    }

    public boolean isConnected() {
        boolean result;
        boolean bl = result = this.socketIO != null && this.socketIO.isConnected();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Connected: {1} [{0}]", new Object[]{this.socketIO, result});
        }
        return result;
    }

    public void setBufferLimit(int bufferLimit) {
        this.bufferLimit = bufferLimit;
    }

    public void setIOServiceListener(IOServiceListener<IOService<RefObject>> sl) {
        this.serviceListener = sl;
    }

    public void setSslContextContainer(SSLContextContainerIfc sslContextContainer) {
        this.sslContextContainer = sslContextContainer;
    }

    public void setX509TrustManagers(TrustManager[] trustManager) {
        this.x509TrustManagers = trustManager;
    }

    public Certificate getPeerCertificate() {
        return this.peerCertificate;
    }

    public Certificate getLocalCertificate() {
        return this.localCertificate;
    }

    protected ByteOrder byteOrder() {
        return ByteOrder.BIG_ENDIAN;
    }

    protected boolean debug(char[] msg) {
        if (msg != null) {
            System.out.print(new String(msg));
        }
        return true;
    }

    protected boolean debug(String msg, String prefix) {
        if (log.isLoggable(Level.FINEST) && msg != null && msg.trim().length() > 0) {
            String log_msg = "\n" + (this.connectionType() != null ? this.connectionType().toString() : "null-type") + " " + prefix + "\n" + msg + "\n";
            log.finest(log_msg);
        }
        return true;
    }

    protected abstract void processSocketData() throws IOException;

    protected ByteBuffer readBytes() throws IOException {
        this.setLastTransferTime();
        if (log.isLoggable(Level.FINEST) && this.empty_read_call_count > 10L) {
            Throwable thr = new Throwable();
            thr.fillInStackTrace();
            log.log(Level.FINEST, "Socket: " + String.valueOf(this.socketIO), thr);
        }
        try {
            ByteBuffer tmpBuffer = this.socketIO.read(this.socketInput);
            if (this.socketIO.bytesRead() > 0) {
                this.empty_read_call_count = 0L;
                return tmpBuffer;
            }
            if (++this.empty_read_call_count > 1000L && !this.writeInProgress.isLocked()) {
                log.log(Level.WARNING, "Max allowed empty calls exceeded, closing connection. [{0}]", this.socketIO);
                this.forceStop();
            }
        }
        catch (BufferUnderflowException ex) {
            this.resizeInputBuffer();
            return this.readBytes();
        }
        catch (SSLHandshakeException e) {
            if (log.isLoggable(Level.CONFIG)) {
                log.log(Level.CONFIG, "Exception starting connection [" + String.valueOf(this.socketIO) + "]: " + String.valueOf(e));
            }
            this.forceStop();
        }
        catch (Exception eof) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Exception reading data [" + String.valueOf(this.socketIO) + "]: " + String.valueOf(eof));
            }
            this.forceStop();
        }
        return null;
    }

    protected void readCompleted() {
        this.decoder.reset();
    }

    protected char[] readData() throws IOException {
        this.setLastTransferTime();
        if (log.isLoggable(Level.FINEST) && this.empty_read_call_count > 10L) {
            Throwable thr = new Throwable();
            thr.fillInStackTrace();
            log.log(Level.FINEST, "Socket: " + String.valueOf(this.socketIO), thr);
        }
        try {
            if (this.socketInput.capacity() > this.socketInputSize && this.socketInput.remaining() == this.socketInput.capacity()) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Resizing socketInput down to {1} bytes. [{0}]", new Object[]{this.socketIO, this.socketInputSize});
                }
                this.socketInput = ByteBuffer.allocate(this.socketInputSize);
                this.socketInput.order(this.byteOrder());
                this.cb = CharBuffer.allocate(this.socketInputSize * 4);
            }
            ByteBuffer tmpBuffer = this.socketIO.read(this.socketInput);
            if (this.socketIO.bytesRead() > 0) {
                this.empty_read_call_count = 0L;
                char[] result = null;
                if (tmpBuffer != null) {
                    CoderResult cr;
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Reading network binary data: {1} [{0}]", new Object[]{this.socketIO, this.socketIO.bytesRead()});
                    }
                    if (this.partialCharacterBytes != null) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Reloading partial bytes: {1} [{0}]", new Object[]{this.socketIO, this.partialCharacterBytes.length});
                        }
                        ByteBuffer oldTmpBuffer = tmpBuffer;
                        tmpBuffer = ByteBuffer.allocate(this.partialCharacterBytes.length + oldTmpBuffer.remaining() + 2);
                        tmpBuffer.order(this.byteOrder());
                        tmpBuffer.put(this.partialCharacterBytes);
                        tmpBuffer.put(oldTmpBuffer);
                        tmpBuffer.flip();
                        oldTmpBuffer.clear();
                        this.partialCharacterBytes = null;
                    }
                    if (this.cb.capacity() < tmpBuffer.remaining() * 4) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Resizing character buffer to: {1} [{0}]", new Object[]{this.socketIO, tmpBuffer.remaining()});
                        }
                        this.cb = CharBuffer.allocate(tmpBuffer.remaining() * 4);
                    }
                    if ((cr = this.decoder.decode(tmpBuffer, this.cb, false)).isMalformed() && !this.handleMalformedInput(tmpBuffer, this.cb)) {
                        throw new MalformedInputException(tmpBuffer.remaining());
                    }
                    if (this.cb.remaining() > 0) {
                        this.cb.flip();
                        result = new char[this.cb.remaining()];
                        this.cb.get(result);
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Decoded character data: {1} [{0}]", new Object[]{this.socketIO, new String(result)});
                        }
                    }
                    if (cr.isUnderflow() && tmpBuffer.remaining() > 0) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "UTF-8 decoder data underflow: {1} [{0}]", new Object[]{this.socketIO, tmpBuffer.remaining()});
                        }
                        this.partialCharacterBytes = new byte[tmpBuffer.remaining()];
                        tmpBuffer.get(this.partialCharacterBytes);
                    }
                    tmpBuffer.clear();
                    this.cb.clear();
                    return result;
                }
            } else if (++this.empty_read_call_count > 1000L && !this.writeInProgress.isLocked()) {
                log.log(Level.WARNING, "Max allowed empty calls exceeded, closing connection. [{0}]", this.socketIO);
                this.forceStop();
            }
        }
        catch (BufferUnderflowException ex) {
            this.resizeInputBuffer();
            return null;
        }
        catch (SSLHandshakeException | SSLProtocolException e) {
            if (log.isLoggable(Level.CONFIG)) {
                log.log(Level.CONFIG, "Exception starting connection [" + String.valueOf(this.socketIO) + "] " + String.valueOf(e));
            }
            this.forceStop();
        }
        catch (Exception eof) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Exception reading data [" + String.valueOf(this.socketIO) + "] " + String.valueOf(eof));
            }
            this.forceStop();
        }
        return null;
    }

    protected abstract int receivedPackets();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeBytes(ByteBuffer data) {
        boolean locked = this.writeInProgress.tryLock();
        if (!locked && data == null) {
            return;
        }
        if (!locked) {
            this.writeInProgress.lock();
        }
        try {
            if (data != null && data.hasRemaining()) {
                int length = data.remaining();
                this.socketIO.write(data);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Wrote: {1} [{0}]", new Object[]{this.socketIO, length});
                }
                this.setLastTransferTime();
                this.empty_read_call_count = 0L;
            } else if (this.socketIO.waitingToSend()) {
                this.socketIO.write(null);
                this.setLastTransferTime();
                this.empty_read_call_count = 0L;
            }
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Data writing exception [" + String.valueOf(this.socketIO) + "] " + String.valueOf(e));
            }
            this.forceStop();
        }
        finally {
            this.writeInProgress.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeData(String data) {
        boolean locked = this.writeInProgress.tryLock();
        if (!locked && data == null) {
            return;
        }
        if (!locked) {
            this.writeInProgress.lock();
        }
        try {
            if (data != null && data.length() > 0) {
                if (log.isLoggable(Level.FINEST)) {
                    if (data.length() < 256) {
                        log.log(Level.FINEST, "Writing data ({1}): {2} [{0}]", new Object[]{this.socketIO, data.length(), data});
                    } else {
                        log.log(Level.FINEST, "Writing data: {1} [{0}]", new Object[]{this.socketIO, data.length()});
                    }
                }
                ByteBuffer dataBuffer = null;
                this.encoder.reset();
                dataBuffer = this.encoder.encode(CharBuffer.wrap(data));
                this.encoder.flush(dataBuffer);
                this.socketIO.write(dataBuffer);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Wrote: {1} [{0}]", new Object[]{this.socketIO, data.length()});
                }
                this.setLastTransferTime();
                this.empty_read_call_count = 0L;
            } else if (this.socketIO.waitingToSend()) {
                this.socketIO.write(null);
                this.setLastTransferTime();
                this.empty_read_call_count = 0L;
            }
        }
        catch (SSLHandshakeException e) {
            if (log.isLoggable(Level.CONFIG)) {
                log.log(Level.CONFIG, "Exception starting connection [" + String.valueOf(this.socketIO) + "]" + String.valueOf(e));
            }
            this.forceStop();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Data [" + data + "] writing exception [" + String.valueOf(this.socketIO) + "]" + String.valueOf(e));
            }
            this.forceStop();
        }
        finally {
            this.writeInProgress.unlock();
        }
    }

    protected boolean isSocketServiceReady() {
        return this.socketServiceReady;
    }

    protected void setSocketServiceReady(boolean value) {
        this.socketServiceReady = value;
    }

    protected boolean handleMalformedInput(ByteBuffer buffer, CharBuffer cb) {
        return false;
    }

    protected boolean isInputBufferEmpty() {
        return this.socketInput != null && this.socketInput.remaining() == this.socketInput.capacity();
    }

    protected IOInterface getIO() {
        return this.socketIO;
    }

    private void resizeInputBuffer() throws IOException {
        int netSize = this.socketIO.getInputPacketSize();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Resize? netSize: {1}, capacity: {2}, remaining: {3}. [{0}]", new Object[]{this.socketIO, netSize, this.socketInput.capacity(), this.socketInput.remaining()});
        }
        if (netSize > this.socketInput.capacity() - this.socketInput.remaining()) {
            int newSize = this.socketInput.capacity() * 2;
            if (this.bufferLimit > 0 && newSize > this.bufferLimit && this.socketInput.capacity() < this.bufferLimit) {
                newSize = this.bufferLimit;
            }
            if (!this.checkBufferLimit(this.bufferLimit)) {
                throw new IOException("Input buffer size limit exceeded");
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Resizing socketInput to {1} bytes. [{0}]", new Object[]{this.socketIO, newSize});
            }
            ByteBuffer b = ByteBuffer.allocate(newSize);
            b.order(this.byteOrder());
            b.put(this.socketInput);
            this.socketInput = b;
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Compacting socketInput. [{0}]", this.socketIO);
            }
            this.socketInput.compact();
        }
    }

    private void setLastTransferTime() {
        this.lastTransferTime = System.currentTimeMillis();
    }
}

