/*
 * Decompiled with CFR 0.152.
 */
package tigase.kernel.core;

import java.util.HashSet;
import tigase.kernel.core.BeanConfig;
import tigase.kernel.core.Dependency;
import tigase.kernel.core.DependencyManager;
import tigase.kernel.core.Kernel;

public class DependencyGrapher {
    private Kernel kernel;

    public DependencyGrapher() {
    }

    public DependencyGrapher(Kernel krnl) {
        this.setKernel(krnl);
    }

    public String getDependencyGraph() {
        StringBuilder sb = new StringBuilder();
        sb.append("digraph ").append("Context").append(" {\n");
        sb.append("label=").append("\"").append(this.kernel.getName()).append("\"\n");
        sb.append("node[shape=record,style=filled,fillcolor=khaki1, color=brown]\n");
        sb.append("edge[color=brown]\n");
        HashSet<String> connections = new HashSet<String>();
        this.drawContext(sb, connections, this.kernel);
        for (String string : connections) {
            sb.append(string).append('\n');
        }
        sb.append("}\n");
        return sb.toString();
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    private void drawContext(StringBuilder structureSB, HashSet<String> connections, Kernel kernel) {
        DependencyManager dependencyManager = kernel.getDependencyManager();
        structureSB.append("subgraph ").append(" {\n");
        for (BeanConfig bc : dependencyManager.getBeanConfigs()) {
            if (bc.getClazz().equals(Kernel.class)) continue;
            structureSB.append('\"').append(bc.getKernel().getName() + "." + bc.getBeanName()).append('\"').append("[");
            if (bc instanceof Kernel.DelegatedBeanConfig) {
                structureSB.append("label=\"");
                structureSB.append(bc.getBeanName());
                structureSB.append("\"");
                structureSB.append("shape=oval");
            } else {
                structureSB.append("label=\"{");
                structureSB.append(bc.getBeanName()).append("\\n").append("(").append(bc.getClazz().getName()).append(")");
                structureSB.append("}\"");
            }
            structureSB.append("];\n");
        }
        structureSB.append("}\n");
        int c = 0;
        for (BeanConfig bc : dependencyManager.getBeanConfigs()) {
            StringBuilder sbi;
            ++c;
            if (bc.getFactory() != null) {
                BeanConfig dBean = bc.getFactory();
                sbi = new StringBuilder();
                sbi.append('\"').append(bc.getKernel().getName() + "." + bc.getBeanName()).append('\"');
                sbi.append("->");
                sbi.append('\"').append(dBean.getKernel().getName() + "." + dBean.getBeanName()).append('\"').append("[style=\"dashed\"]");
                connections.add(sbi.toString());
            }
            if (bc instanceof Kernel.DelegatedBeanConfig) {
                BeanConfig oryginal = ((Kernel.DelegatedBeanConfig)bc).getOriginal();
                sbi = new StringBuilder();
                sbi.append('\"').append(oryginal.getKernel().getName() + "." + oryginal.getBeanName()).append('\"');
                sbi.append("->");
                sbi.append('\"').append(bc.getKernel().getName() + "." + bc.getBeanName()).append('\"').append("[style=dotted,arrowtail=none,arrowhead=none]");
                connections.add(sbi.toString());
                continue;
            }
            for (Dependency dp : bc.getFieldDependencies().values()) {
                BeanConfig[] dBeans;
                for (BeanConfig dBean : dBeans = dependencyManager.getBeanConfig(dp)) {
                    BeanConfig fromBC = bc;
                    StringBuilder sbi2 = new StringBuilder();
                    if (dBean != null && dBean.getKernel() != bc.getKernel()) {
                        sbi2.append("/* inne kernele */ ");
                        fromBC = this.findDelegateIn(bc, dBean.getKernel().getDependencyManager());
                    }
                    if (dBean == null) {
                        sbi2.append('\"').append(fromBC.getKernel().getName() + "." + fromBC.getBeanName()).append('\"');
                        sbi2.append("->");
                        sbi2.append("{UNKNOWN_").append(c).append("[label=\"").append(dp).append("\", fillcolor=red, style=filled, shape=box]}");
                    } else {
                        sbi2.append('\"').append(fromBC.getKernel().getName() + "." + fromBC.getBeanName()).append('\"');
                        sbi2.append("->");
                        sbi2.append('\"').append(dBean.getKernel().getName() + "." + dBean.getBeanName()).append('\"');
                    }
                    connections.add(sbi2.toString());
                }
            }
        }
        for (BeanConfig kc : dependencyManager.getBeanConfigs(Kernel.class, null, null)) {
            Kernel ki = (Kernel)kernel.getInstance(kc.getBeanName());
            structureSB.append("subgraph ").append("cluster_").append(ki.hashCode()).append(" {\n");
            structureSB.append("label=").append("\"").append(ki.getName()).append("\"\n");
            if (ki != kernel) {
                this.drawContext(structureSB, connections, ki);
            }
            structureSB.append("}\n");
        }
    }

    private BeanConfig findDelegateIn(BeanConfig dBean, DependencyManager dependencyManager) {
        for (BeanConfig bc : dependencyManager.getBeanConfigs()) {
            BeanConfig orig;
            if (!(bc instanceof Kernel.DelegatedBeanConfig) || (orig = ((Kernel.DelegatedBeanConfig)bc).getOriginal()) != dBean) continue;
            return bc;
        }
        return dBean;
    }
}

