/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import tigase.annotations.TigaseDeprecated;
import tigase.cert.CertCheckResult;
import tigase.io.SSLContextContainerIfc;
import tigase.io.TLSStatus;

public interface TLSWrapper {
    public int bytesConsumed();

    public void close() throws SSLException;

    public int getAppBuffSize();

    public CertCheckResult getCertificateStatus(boolean var1, SSLContextContainerIfc var2);

    public SSLEngineResult.HandshakeStatus getHandshakeStatus();

    public Certificate[] getLocalCertificates();

    public int getNetBuffSize();

    public int getPacketBuffSize();

    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException;

    public TLSStatus getStatus();

    public byte[] getTlsUniqueBindingData();

    public byte[] getTlsExporterBindingData();

    public boolean isClientMode();

    public boolean isNeedClientAuth();

    public void setDebugId(String var1);

    public ByteBuffer unwrap(ByteBuffer var1, ByteBuffer var2) throws SSLException;

    public boolean wantClientAuth();

    public void wrap(ByteBuffer var1, ByteBuffer var2) throws SSLException;

    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="This method might be replaced by checking if handshake was finished on TLSIO level but that requires API changes.")
    default public void notifyIfHandshakeFinished() {
    }
}

