/*
 * Decompiled with CFR 0.152.
 */
package tigase.eventbus.component.stores;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tigase.eventbus.component.EventBusComponent;
import tigase.eventbus.component.stores.Affiliation;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.xmpp.jid.JID;

@Bean(name="affiliations", parent=EventBusComponent.class, active=true)
public class AffiliationStore {
    private final Map<JID, Affiliation> affiliations = new ConcurrentHashMap<JID, Affiliation>();
    @ConfigField(desc="List of JIDs what can subscribe for events")
    private JID[] allowedSubscribers;

    public Affiliation getAffiliation(JID jid) {
        Affiliation a = this.affiliations.get(jid);
        if (a == null && this.allowedSubscribers != null) {
            for (JID j : this.allowedSubscribers) {
                if (j.getResource() != null && j.equals((Object)jid)) {
                    return Affiliation.member;
                }
                if (j.getResource() != null || !j.getBareJID().equals((Object)jid.getBareJID())) continue;
                return Affiliation.member;
            }
        }
        return a == null ? Affiliation.none : a;
    }

    public JID[] getAllowedSubscribers() {
        return this.allowedSubscribers;
    }

    public void setAllowedSubscribers(JID[] allowedSubscribers) {
        this.allowedSubscribers = allowedSubscribers;
    }

    public void putAffiliation(JID jid, Affiliation affiliation) {
        this.affiliations.put(jid, affiliation);
    }

    public void removeAffiliation(JID jid) {
        this.affiliations.remove(jid);
    }
}

