/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.util.importexport;

import java.io.BufferedWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import tigase.db.AbstractAuthRepositoryWithCredentials;
import tigase.db.AuthRepository;
import tigase.db.UserRepository;
import tigase.db.util.importexport.RepositoryHolder;
import tigase.db.util.importexport.RepositoryManager;
import tigase.db.util.importexport.RepositoryManagerExtension;
import tigase.util.datetime.TimestampHelper;
import tigase.util.ui.console.CommandlineParameter;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostJDBCRepository;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.impl.roster.RosterFlat;
import tigase.xmpp.jid.BareJID;

public class Exporter {
    private static final Logger log = Logger.getLogger(Exporter.class.getSimpleName());
    private static final TimestampHelper TIMESTAMP_FORMATTER = new TimestampHelper();
    public static final CommandlineParameter EXPORT_MAM_SINCE = new CommandlineParameter.Builder(null, "export-mam-since").description("Export MAM archive since").type(LocalDateTime.class).required(false).build();
    public static final CommandlineParameter EXPORT_MAM_BATCH_SIZE = new CommandlineParameter.Builder(null, "export-mam-batch-size").description("Export MAM archive batch size").type(Integer.class).defaultValue("50000").required(false).build();
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ISO_LOCAL_DATE;
    private static final DateTimeFormatter DATETIME_FORMAT = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    private final RepositoryHolder repositoryHolder;
    private final VHostJDBCRepository vhostRepository;
    private final List<RepositoryManagerExtension> extensions;
    private final Path rootPath;

    public static Optional<Date> getExportMAMSinceValue() {
        return EXPORT_MAM_SINCE.getValue().map(str -> {
            try {
                return TIMESTAMP_FORMATTER.parseTimestamp(str);
            }
            catch (Exception ex) {
                try {
                    LocalDateTime ts = Exporter.parseLocalDate(str);
                    return Date.from(ts.toInstant(ZoneOffset.UTC));
                }
                catch (Exception ex2) {
                    throw new RuntimeException("Could not parse " + str + " as timestamp", ex);
                }
            }
        });
    }

    public static Integer getExportMAMBatchSize() {
        return EXPORT_MAM_BATCH_SIZE.getValue().map(Integer::parseInt).orElse(50000);
    }

    private static LocalDateTime parseLocalDate(String str) throws Exception {
        try {
            return LocalDateTime.parse(str, DATETIME_FORMAT);
        }
        catch (Exception ex1) {
            return LocalDateTime.of(LocalDate.parse(str, DATE_FORMAT), LocalTime.MIDNIGHT);
        }
    }

    public static Date parseTimestamp(String str) {
        try {
            return TIMESTAMP_FORMATTER.parseTimestamp(str);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void exportInclude(Writer parentWriter, Path rootPath, Path filePath, RepositoryManager.ThrowingConsumer<Writer> writerConsumer) throws Exception {
        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        parentWriter.append("<xi:include href='").append(rootPath.relativize(filePath).toString()).append("'/>\n");
        Exporter.openXmlFile(filePath, writerConsumer);
    }

    public static void openXmlFile(Path filePath, RepositoryManager.ThrowingConsumer<Writer> writerConsumer) throws Exception {
        try (BufferedWriter writer = Files.newBufferedWriter(filePath, new OpenOption[0]);){
            writer.write("<?xml version='1.0' encoding='UTF-8'?>\n");
            writerConsumer.accept(writer);
        }
    }

    public Exporter(RepositoryHolder repositoryHolder, VHostJDBCRepository vhostRepository, List<RepositoryManagerExtension> extensions, Path rootPath) {
        this.repositoryHolder = repositoryHolder;
        this.vhostRepository = vhostRepository;
        this.extensions = extensions;
        this.rootPath = rootPath;
        Exporter.getExportMAMSinceValue().ifPresent(date -> log.info("exporting MAM since: " + String.valueOf(date)));
        log.info("exporting MAM in batch size of " + Exporter.getExportMAMBatchSize() + " messages");
    }

    public void export(String fileName) throws Exception {
        Exporter.openXmlFile(this.rootPath.resolve(fileName), rootWriter -> {
            rootWriter.append("<server-data xmlns='urn:xmpp:pie:0' xmlns:xi='http://www.w3.org/2001/XInclude'>\n");
            for (VHostItem item : this.vhostRepository.allItems()) {
                if ("default".equals(item.getKey())) continue;
                Path domainFileName = this.rootPath.resolve(item.getKey() + ".xml");
                Exporter.exportInclude(rootWriter, this.rootPath, domainFileName, domainWriter -> this.exportDomain(domainFileName, item.getKey(), (Writer)domainWriter));
            }
            rootWriter.append("</server-data>");
        });
    }

    protected void exportDomain(Path domainFilePath, String domain, Writer writer) throws Exception {
        log.info("exporting domain " + domain + " data...");
        writer.append("<host xmlns='urn:xmpp:pie:0' xmlns:xi='http://www.w3.org/2001/XInclude' jid=\"").append(XMLUtils.escape((String)domain)).append("\">\n");
        UserRepository userRepository = this.repositoryHolder.getRepository(UserRepository.class, domain);
        List<BareJID> users = userRepository.getUsers();
        int exportedUsers = 0;
        for (BareJID user : users) {
            if (user.getLocalpart() == null || !domain.equals(user.getDomain())) continue;
            Path userFilePath = domainFilePath.resolveSibling(domain).resolve(user.getLocalpart() + ".xml");
            Exporter.exportInclude(writer, this.rootPath, userFilePath, userWriter -> this.exportUser(userRepository, userFilePath, user, (Writer)userWriter));
            ++exportedUsers;
        }
        for (RepositoryManagerExtension extension : this.extensions) {
            extension.exportDomainData(domain, writer);
        }
        log.info("exported domain " + domain + " with " + exportedUsers + " users");
        writer.append("</host>");
    }

    protected void exportUser(UserRepository userRepository, Path userFilePath, BareJID user, Writer writer) throws Exception {
        String vcardTemp;
        log.info("exporting user " + String.valueOf(user) + " data...");
        writer.append("<user xmlns='urn:xmpp:pie:0' xmlns:xi='http://www.w3.org/2001/XInclude' name=\"").append(XMLUtils.escape((String)user.getLocalpart())).append("\"");
        AuthRepository authRepository = this.repositoryHolder.getRepository(AbstractAuthRepositoryWithCredentials.class, user.getDomain());
        try {
            AuthRepository.AccountStatus accountStatus = authRepository.getAccountStatus(user);
            writer.append(" xmlns:tigase=\"tigase:xep-0227:user:0\"");
            writer.append(" tigase:status=\"").append(accountStatus.name()).append("\"");
        }
        catch (Exception ex) {
            log.severe("error for " + String.valueOf(user) + " using " + authRepository.getClass().getSimpleName());
            throw ex;
        }
        writer.append(">");
        String rosterStr = userRepository.getData(user, null, "roster", null);
        if (rosterStr != null) {
            LinkedHashMap<BareJID, RosterElement> roster = new LinkedHashMap<BareJID, RosterElement>();
            RosterFlat.parseRosterUtil(rosterStr, roster, null);
            writer.append("<query xmlns='jabber:iq:roster'>");
            for (RosterElement re : roster.values()) {
                String[] rosterItem = re.getRosterItem();
                if (re.getMixParticipantId() != null) {
                    rosterItem.addChild((XMLNodeIfc)new Element("channel", new String[]{"xmlns", "participant-id"}, new String[]{"urn:xmpp:mix:roster:0", re.getMixParticipantId()}));
                }
                writer.append(rosterItem.toString());
            }
            writer.append("</query>");
        }
        if ((vcardTemp = userRepository.getData(user, "public/vcard-temp", "vCard")) != null) {
            writer.append(vcardTemp);
        }
        String defListName = userRepository.getData(user, "privacy", "default-list");
        String[] subnodes = userRepository.getSubnodes(user, "privacy");
        if (subnodes != null && subnodes.length > 0) {
            writer.append("<query xmlns='jabber:iq:privacy'>");
            if (defListName != null) {
                writer.append("<default name=\"").append(XMLUtils.escape((String)defListName)).append("\"/>");
                for (String node : subnodes) {
                    String list = userRepository.getData(user, "privacy/" + node, "privacy-list");
                    if (list == null) continue;
                    writer.append(list);
                }
            }
            writer.append("</query>");
        }
        Path userDirPath = userFilePath.getParent().resolve(user.getLocalpart());
        for (RepositoryManagerExtension extension : this.extensions) {
            extension.exportUserData(userDirPath, user, writer);
        }
        writer.append("</user>");
    }
}

