/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.services;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jspecify.annotations.NonNull;
import tigase.db.AuthRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.eventbus.EventBus;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.Kernel;
import tigase.server.xmppsession.DisconnectUserEBAction;
import tigase.xmpp.StreamError;
import tigase.xmpp.jid.BareJID;

@Bean(name="account-expiration-service", active=false, parent=Kernel.class, exportable=true)
public class AccountExpirationService
implements Initializable {
    public static final String ACCOUNT_EXPIRATION_DATE = "account-expiration-date";
    private static final Logger log = Logger.getLogger(AccountExpirationService.class.getCanonicalName());
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    @Inject
    private AuthRepository authRepository;
    @Inject
    private EventBus eventBus;
    private RemoveExpiredAccountsTask expiredMessagesRemovalTask = null;
    private LocalTime scheduledRemovalTimeLT = LocalTime.of(0, 5);
    @ConfigField(desc="Time at which removal of expired accounts should be executed", alias="scheduled-expired-accounts-removal-time")
    private String scheduledRemovalTime = this.scheduledRemovalTimeLT.toString();
    @Inject
    private UserRepository userRepository;

    @Override
    public void initialize() {
        LocalTime now = LocalTime.now();
        Duration initialDelay = now.isAfter(this.scheduledRemovalTimeLT) ? Duration.ofHours(24L).minus(Duration.between(this.scheduledRemovalTimeLT, now)) : Duration.between(now, this.scheduledRemovalTimeLT);
        log.log(Level.CONFIG, "Scheduling removing expired users accounts at: " + String.valueOf(this.scheduledRemovalTimeLT) + ", next run in: " + String.valueOf(initialDelay) + ", sec: " + initialDelay.getSeconds());
        scheduler.scheduleAtFixedRate(new RemoveExpiredAccountsTask(), initialDelay.getSeconds(), TimeUnit.DAYS.toSeconds(1L), TimeUnit.SECONDS);
    }

    void removeExpiredAccounts() throws TigaseDBException {
        log.log(Level.FINEST, "Running expired accounts removal task");
        Map<BareJID, String> dataMap = this.userRepository.getDataMap(ACCOUNT_EXPIRATION_DATE);
        LocalDate now = LocalDate.now();
        for (Map.Entry<BareJID, String> jidExpirationEntry : dataMap.entrySet()) {
            if (jidExpirationEntry.getValue() == null || !LocalDate.parse(jidExpirationEntry.getValue()).isBefore(now)) continue;
            log.log(Level.FINE, "Removing expired account: " + String.valueOf(jidExpirationEntry.getKey()) + ", expiration date: " + jidExpirationEntry.getValue());
            this.authRepository.removeUser(jidExpirationEntry.getKey());
            this.eventBus.fire(new DisconnectUserEBAction(jidExpirationEntry.getKey(), StreamError.Reset, "Account was deleted"));
        }
    }

    public void setScheduledRemovalTime(String scheduledRemovalTime) {
        this.scheduledRemovalTime = scheduledRemovalTime;
        this.scheduledRemovalTimeLT = LocalTime.parse(scheduledRemovalTime);
    }

    public void setUserExpiration(@NonNull BareJID userId, Integer expirationDays) throws TigaseDBException {
        Objects.requireNonNull(userId);
        log.log(Level.FINE, "Setting user expiration for " + String.valueOf(userId) + " to " + expirationDays);
        if (expirationDays != null) {
            if (expirationDays <= 0) {
                this.userRepository.removeData(userId, ACCOUNT_EXPIRATION_DATE);
            } else {
                LocalDate localDate = LocalDate.now().plusDays(expirationDays.intValue());
                this.userRepository.setData(userId, ACCOUNT_EXPIRATION_DATE, localDate.toString());
            }
        }
    }

    public Long getUserExpirationDays(@NonNull BareJID userId) {
        return this.getUserExpiration(userId).map(d -> LocalDate.now().until((Temporal)d, ChronoUnit.DAYS)).orElse(0L);
    }

    public Optional<LocalDate> getUserExpiration(@NonNull BareJID userId) {
        Objects.requireNonNull(userId);
        log.log(Level.FINE, "Getting user expiration for " + String.valueOf(userId));
        try {
            String expirationDate = this.userRepository.getData(userId, ACCOUNT_EXPIRATION_DATE);
            if (expirationDate != null) {
                return Optional.of(LocalDate.parse(expirationDate));
            }
        }
        catch (TigaseDBException e) {
            log.log(Level.WARNING, "Error obtaining user expiration date from repository", e);
        }
        return Optional.empty();
    }

    private class RemoveExpiredAccountsTask
    implements Runnable {
        private RemoveExpiredAccountsTask() {
        }

        @Override
        public void run() {
            try {
                AccountExpirationService.this.removeExpiredAccounts();
            }
            catch (TigaseDBException e) {
                log.log(Level.SEVERE, "Removing expired accounts failed", e);
            }
        }
    }
}

