/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.beans;

import java.lang.reflect.Proxy;
import tigase.db.DataSourceAware;
import tigase.db.beans.SDRepositoryBean;
import tigase.kernel.beans.config.ConfigField;
import tigase.stats.ComponentStatisticsProvider;
import tigase.stats.StatisticsInvocationHandler;
import tigase.stats.StatisticsList;

public abstract class SDRepositoryBeanWithStatistics<T extends DataSourceAware>
extends SDRepositoryBean<T>
implements ComponentStatisticsProvider {
    private final Class<T> repoClazz;
    private StatisticsInvocationHandler<T> handler;
    private T repoProxy;
    @ConfigField(desc="Enable statistics", alias="statistics")
    private boolean statisticsEnabled = false;

    public SDRepositoryBeanWithStatistics(Class<T> repoClazz) {
        this.repoClazz = repoClazz;
    }

    @Override
    public void everyHour() {
        if (this.statisticsEnabled) {
            this.handler.everyHour();
        }
    }

    @Override
    public void everyMinute() {
        if (this.statisticsEnabled) {
            this.handler.everyMinute();
        }
    }

    @Override
    public void everySecond() {
        if (this.statisticsEnabled) {
            this.handler.everySecond();
        }
    }

    @Override
    public void getStatistics(String compName, StatisticsList list) {
        if (this.handler != null) {
            this.handler.getStatistics(compName, this.getName(), list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatisticsEnabled(boolean value) {
        if (this.statisticsEnabled != value) {
            SDRepositoryBeanWithStatistics sDRepositoryBeanWithStatistics = this;
            synchronized (sDRepositoryBeanWithStatistics) {
                if (value) {
                    this.wrapInProxy(super.getRepository());
                }
                this.statisticsEnabled = value;
                if (!value) {
                    this.repoProxy = null;
                }
            }
        }
    }

    public void wrapInProxy(T repo) {
        this.handler = new StatisticsInvocationHandler<T>(this.getDataSourceName(), repo, this.repoClazz);
        this.repoProxy = (DataSourceAware)Proxy.newProxyInstance(repo.getClass().getClassLoader(), new Class[]{this.repoClazz}, this.handler);
    }

    @Override
    protected T getRepository() {
        if (this.statisticsEnabled) {
            return this.repoProxy;
        }
        return (T)super.getRepository();
    }

    @Override
    public void setRepository(T repository) {
        if (this.statisticsEnabled) {
            this.wrapInProxy(repository);
        }
        super.setRepository(repository);
    }
}

