/*
 * Decompiled with CFR 0.152.
 */
package tigase.component;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import tigase.db.AuthRepository;
import tigase.db.UserRepository;
import tigase.kernel.core.Kernel;

public class BackwardCompatibilityHelper {
    public static Object convertToArray(Collection collection) {
        Iterator iter = collection.iterator();
        if (!iter.hasNext()) {
            return null;
        }
        Class<?> objCls = iter.next().getClass();
        if (objCls == Integer.class) {
            return BackwardCompatibilityHelper.convertToIntArray(collection);
        }
        if (objCls == Long.class) {
            return BackwardCompatibilityHelper.convertToLongArray(collection);
        }
        if (objCls == Double.class) {
            return BackwardCompatibilityHelper.convertToDoubleArray(collection);
        }
        if (objCls == Float.class) {
            return BackwardCompatibilityHelper.convertToFloatArray(collection);
        }
        if (objCls == Boolean.class) {
            return BackwardCompatibilityHelper.convertToBoolArray(collection);
        }
        if (objCls == String.class) {
            return BackwardCompatibilityHelper.convertToStringArray(collection);
        }
        return null;
    }

    public static Object convertToBoolArray(Collection col) {
        boolean[] arr = new boolean[col.size()];
        int pos = 0;
        for (Boolean v : col) {
            arr[pos++] = v;
        }
        return arr;
    }

    public static Object convertToDoubleArray(Collection col) {
        double[] arr = new double[col.size()];
        int pos = 0;
        for (Number v : col) {
            arr[pos++] = v.doubleValue();
        }
        return arr;
    }

    public static Object convertToFloatArray(Collection col) {
        float[] arr = new float[col.size()];
        int pos = 0;
        for (Number v : col) {
            arr[pos++] = v.floatValue();
        }
        return arr;
    }

    public static Object convertToIntArray(Collection col) {
        int[] arr = new int[col.size()];
        int pos = 0;
        for (Number v : col) {
            arr[pos++] = v.intValue();
        }
        return arr;
    }

    public static Object convertToLongArray(Collection col) {
        long[] arr = new long[col.size()];
        int pos = 0;
        for (Number v : col) {
            arr[pos++] = v.longValue();
        }
        return arr;
    }

    public static Object convertToStringArray(Collection col) {
        String[] arr = new String[col.size()];
        int pos = 0;
        for (String v : col) {
            arr[pos++] = v;
        }
        return arr;
    }

    public static Map<String, Object> fillProps(Map<String, Object> beanProperties) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e : beanProperties.entrySet()) {
            String key = e.getKey();
            Object value = e.getValue();
            if (value instanceof Collection && (value = BackwardCompatibilityHelper.convertToArray((Collection)value)) != null) {
                result.put(key, value);
            }
            if (value instanceof Map) {
                String prefix = key;
                for (Map.Entry e1 : ((Map)value).entrySet()) {
                    result.put(key + "/" + (String)e1.getKey(), e1.getValue());
                }
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    public static Map<String, Object> getDefConfigParams(Kernel kernel, String configType, String dbUri, Map<String, Object> params) {
        HashMap<String, Object> initProperties = new HashMap<String, Object>();
        initProperties.put("config-type", configType);
        for (Map.Entry<String, Object> e : params.entrySet()) {
            if (!e.getKey().startsWith("-")) continue;
            initProperties.put(e.getKey(), e.getValue());
        }
        initProperties.put("user-repo-url", dbUri);
        initProperties.put("--user-db-uri", dbUri);
        UserRepository userRepo = kernel.getInstance(UserRepository.class);
        initProperties.put("shared-user-repo", userRepo);
        AuthRepository authRepo = kernel.getInstance(AuthRepository.class);
        initProperties.put("shared-auth-repo", authRepo);
        return initProperties;
    }
}

