/*
 * Decompiled with CFR 0.152.
 */
package tigase.component;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptEngineManager;
import tigase.component.BindingsKernel;
import tigase.component.ComponenScriptCommandProcessor;
import tigase.component.PacketWriter;
import tigase.component.adhoc.AdHocCommandManager;
import tigase.component.modules.StanzaProcessor;
import tigase.component.modules.impl.config.ConfiguratorCommand;
import tigase.component.responses.AsyncCallback;
import tigase.component.responses.ResponseManager;
import tigase.disco.XMPPService;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventBusFactory;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.core.Kernel;
import tigase.server.AbstractMessageReceiver;
import tigase.server.DisableDisco;
import tigase.server.Packet;

public abstract class AbstractKernelBasedComponent
extends AbstractMessageReceiver
implements XMPPService,
DisableDisco,
RegistrarBean {
    protected final EventBus eventBus = EventBusFactory.getInstance();
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    protected Kernel kernel = null;
    @Inject
    private StanzaProcessor stanzaProcessor;

    public String getComponentVersion() {
        String version = this.getClass().getPackage().getImplementationVersion();
        return version == null ? "0.0.0" : version;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put("kernel", (Object)this.kernel);
    }

    @Override
    public void start() {
        super.start();
    }

    public abstract boolean isDiscoNonAdmin();

    @Override
    public void processPacket(Packet packet) {
        this.stanzaProcessor.processPacket(packet);
    }

    @Override
    public void register(Kernel kernel) {
        this.kernel = kernel;
        kernel.registerBean("adHocCommandManager").asClass(AdHocCommandManager.class).exec();
        kernel.registerBean("scriptCommandProcessor").asClass(ComponenScriptCommandProcessor.class).exec();
        kernel.registerBean("writer").asClass(DefaultPacketWriter.class).exec();
        kernel.registerBean("responseManager").asClass(ResponseManager.class).exec();
        kernel.registerBean("stanzaProcessor").asClass(StanzaProcessor.class).exec();
        kernel.registerBean(ConfiguratorCommand.class).exec();
        this.registerModules(kernel);
    }

    @Override
    public void unregister(Kernel kernel) {
        this.kernel = null;
    }

    @Override
    public void updateServiceEntity() {
        super.updateServiceEntity();
        this.updateServiceDiscoveryItem(this.getName(), null, this.getDiscoDescription(), !this.isDiscoNonAdmin());
    }

    @Override
    protected ScriptEngineManager createScriptEngineManager() {
        ScriptEngineManager result = super.createScriptEngineManager();
        result.setBindings(new BindingsKernel(this.kernel));
        return result;
    }

    protected abstract void registerModules(Kernel var1);

    @Bean(name="writer", active=true)
    public static final class DefaultPacketWriter
    implements PacketWriter {
        protected final Logger log = Logger.getLogger(this.getClass().getName());
        @Inject(nullAllowed=false, bean="service")
        private AbstractKernelBasedComponent component;
        @Inject(nullAllowed=false)
        private ResponseManager responseManager;

        @Override
        public void write(Collection<Packet> elements) {
            if (elements != null) {
                for (Packet element : elements) {
                    if (element == null) continue;
                    this.write(element);
                }
            }
        }

        @Override
        public void write(Packet packet) {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Sent: " + String.valueOf(packet));
            }
            this.component.addOutPacket(packet);
        }

        @Override
        public void write(Packet packet, AsyncCallback callback) {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Sent: " + String.valueOf(packet));
            }
            this.responseManager.registerResponseHandler(packet, 60000L, callback);
            this.component.addOutPacket(packet);
        }
    }
}

