/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster.strategy;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.SessionManagerClusteredIfc;
import tigase.cluster.strategy.ClusteringStrategyIfc;
import tigase.cluster.strategy.ConnectionRecord;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.stats.StatisticsList;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public abstract class SMNonCachingAllNodes
implements ClusteringStrategyIfc<ConnectionRecord> {
    private static final Logger log = Logger.getLogger(SMNonCachingAllNodes.class.getName());
    private Random rand = new Random();
    @Inject
    private SessionManagerClusteredIfc sm = null;

    @Override
    public boolean containsJid(BareJID jid) {
        return false;
    }

    @Override
    public void nodeConnected(JID jid) {
    }

    @Override
    public void nodeDisconnected(JID jid) {
    }

    @Override
    public List<JID> getNodesConnected() {
        return this.sm.getNodesConnected();
    }

    @Override
    public JID[] getConnectionIdsForJid(BareJID jid) {
        return null;
    }

    @Override
    public Set<ConnectionRecord> getConnectionRecords(BareJID bareJID) {
        return null;
    }

    public List<JID> getNodesForJid(JID jid) {
        return this.getNodesConnected();
    }

    public List<JID> getNodesForPacketForward(JID fromNode, Set<JID> visitedNodes, Packet packet) {
        if (visitedNodes != null) {
            List<JID> result = this.selectNodes(fromNode, visitedNodes);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Visited nodes not null: {0}, selecting new node: {1}, for packet: {2}", new Object[]{visitedNodes, result, packet});
            }
            return result;
        }
        if (packet.getElemName() == "presence" && packet.getType() != StanzaType.error && packet.getStanzaFrom() != null && packet.getStanzaTo() == null) {
            List<JID> result = this.getNodesConnected();
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Presence packet found: {0}, selecting all nodes: {1}", new Object[]{packet, result});
            }
            return result;
        }
        if (this.isSuitableForForward(packet)) {
            List<JID> result = this.selectNodes(fromNode, visitedNodes);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Visited nodes null, selecting new node: {0}, for packet: {1}", new Object[]{result, packet});
            }
            return result;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Packet not suitable for forwarding: {0}", new Object[]{packet});
        }
        return null;
    }

    public List<JID> getNodesForUserConnect(JID jid) {
        return this.getNodesConnected();
    }

    public List<JID> getNodesForUserDisconnect(JID jid) {
        return this.getNodesConnected();
    }

    @Override
    public void getStatistics(StatisticsList list) {
    }

    @Override
    public boolean hasCompleteJidsInfo() {
        return false;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
    }

    protected boolean isSuitableForForward(Packet packet) {
        if (packet.getType() == StanzaType.error) {
            return false;
        }
        if (packet.getPacketFrom() != null && !this.sm.getComponentId().equals((Object)packet.getPacketFrom())) {
            return false;
        }
        if (packet.getStanzaTo() == null || this.sm.isLocalDomain(packet.getStanzaTo().toString(), false) || this.sm.getComponentId().equals((Object)packet.getStanzaTo().getBareJID())) {
            return false;
        }
        if (packet.getStanzaFrom() == null || this.sm.isLocalDomain(packet.getStanzaFrom().toString(), false) || this.sm.getComponentId().equals((Object)packet.getStanzaFrom().getBareJID())) {
            return false;
        }
        return this.sm.isLocalDomain(packet.getStanzaTo().getDomain(), false);
    }

    private List<JID> selectNodes(JID fromNode, Set<JID> visitedNodes) {
        List<JID> result;
        block13: {
            result = null;
            List<JID> cl_nodes_list = this.getNodesConnected();
            int size = cl_nodes_list.size();
            if (size == 0) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "No connected cluster nodes found, returning null");
                }
                return null;
            }
            int idx = this.rand.nextInt(size);
            if (visitedNodes == null || visitedNodes.size() == 0) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "No visited nodes yet, trying random idx: " + idx);
                }
                try {
                    result = Collections.singletonList(cl_nodes_list.get(idx));
                }
                catch (IndexOutOfBoundsException ioobe) {
                    try {
                        result = Collections.singletonList(cl_nodes_list.get(0));
                        break block13;
                    }
                    catch (IndexOutOfBoundsException ioobe2) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "IndexOutOfBoundsException twice! Should not happen very often, returning null");
                        }
                        break block13;
                    }
                }
            }
            for (JID jid : cl_nodes_list) {
                if (visitedNodes.contains(jid)) continue;
                result = Collections.singletonList(jid);
                break;
            }
            if (result == null && !this.sm.getComponentId().equals((Object)fromNode)) {
                result = Collections.singletonList(fromNode);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "All nodes visited, sending it back to the first node: " + String.valueOf(result));
                }
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "List of result nodes: " + String.valueOf(result));
        }
        return result;
    }
}

