/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.adhoc;

import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.annotations.TigaseDeprecated;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.component.modules.impl.AdHocCommandModule;
import tigase.db.AuthRepository;
import tigase.db.TigaseDBException;
import tigase.form.Form;
import tigase.kernel.beans.Inject;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public abstract class AbstractCredentialsCommand
implements AdHocCommand {
    protected static final String FIELD_JID = "jid";
    protected static final String FIELD_CREDENTIAL_ID = "credentialId";
    @Deprecated
    @TigaseDeprecated(since="8.1.0", note="Using CredentialID instead of username for clarity")
    protected static final String FIELD_USERNAME = "credentialId";
    protected static final String FIELD_PASSWORD = "password";
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    @Inject
    protected AuthRepository authRepository;
    @Inject
    private AdHocCommandModule.ScriptCommandProcessor scriptCommandProcessor;

    protected void checkIfCanModifyJID(AdhHocRequest request, BareJID jidToModify) throws AdHocCommandException {
        if (!jidToModify.equals((Object)request.getSender().getBareJID())) {
            this.log.log(Level.FINEST, "Cannot modify credentials of different user");
            throw new AdHocCommandException(Authorization.NOT_AUTHORIZED, "You are not allowed to modify credentials of user " + String.valueOf(jidToModify));
        }
    }

    @Override
    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            Element data = request.getCommand().getChild("x", "jabber:x:data");
            if (request.getAction() != null && "cancel".equals(request.getAction())) {
                response.cancelSession();
            } else if (data == null) {
                this.processNoForm(request, response);
            } else {
                Form form = new Form(data);
                this.processForm(form, request, response);
            }
        }
        catch (Exception e) {
            this.log.log(Level.FINEST, "Error during processing command", e);
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @Override
    public boolean isAllowedFor(JID jid) {
        return this.scriptCommandProcessor.isAllowed(this.getNode(), jid);
    }

    protected abstract void processForm(Form var1, AdhHocRequest var2, AdHocResponse var3) throws TigaseDBException, AdHocCommandException;

    protected abstract void processNoForm(AdhHocRequest var1, AdHocResponse var2) throws TigaseDBException;
}

