/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.roster;

import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Queue;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.db.TigaseDBException;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.server.PolicyViolationException;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.vhosts.DummyVHostManager;
import tigase.xml.Element;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.PresenceSubscription;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterFactory;
import tigase.xmpp.jid.JID;

public class PresenceSubscriptionPreApprovalTest
extends ProcessorTestCase {
    private JID connID;
    private JID userJID;
    private JID buddyJID;
    private XMPPResourceConnection session;
    private PresenceSubscription presenceSubscription;
    private RosterAbstract rosterUtil;

    @Override
    protected void registerBeans(Kernel kernel) {
        super.registerBeans(kernel);
        kernel.registerBean(PresenceSubscription.class).exec();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        Field f = RosterFactory.class.getDeclaredField("shared");
        f.setAccessible(true);
        f.set(null, RosterFactory.newRosterInstance((String)RosterFactory.ROSTER_IMPL_PROP_VAL));
        super.setUp();
        this.registerBeans(this.getKernel());
        DummyVHostManager vHostManager = this.getInstance(DummyVHostManager.class);
        vHostManager.addVhost("localhost");
        this.presenceSubscription = this.getInstance(PresenceSubscription.class);
        this.rosterUtil = RosterFactory.getRosterImplementation((boolean)true);
        this.connID = JID.jidInstanceNS((String)UUID.randomUUID().toString(), (String)"localhost");
        this.userJID = JID.jidInstanceNS((String)UUID.randomUUID().toString(), (String)"localhost");
        this.buddyJID = JID.jidInstanceNS((String)UUID.randomUUID().toString(), (String)"localhost");
        this.session = this.getSession(this.connID, this.userJID, true);
    }

    @Test
    public void test_nonePreApproval_noRosterItem() throws XMPPException, TigaseStringprepException, TigaseDBException {
        Queue<Packet> results = this.processPresence(this.userJID, this.buddyJID, StanzaType.subscribed);
        System.out.println(results);
        Assert.assertTrue((boolean)this.rosterUtil.isPreApproved(this.session, this.buddyJID));
        Assert.assertEquals((Object)RosterAbstract.SubscriptionType.none_pre_approved, (Object)this.getSubscription(this.buddyJID));
    }

    @Test
    public void test_nonePreApproval_withRosterItem() throws XMPPException, TigaseStringprepException, TigaseDBException, PolicyViolationException {
        this.rosterUtil.addBuddy(this.session, this.buddyJID, "test", null, RosterAbstract.SubscriptionType.none, null);
        Queue<Packet> results = this.processPresence(this.userJID, this.buddyJID, StanzaType.subscribed);
        System.out.println(results);
        Assert.assertTrue((boolean)this.rosterUtil.isPreApproved(this.session, this.buddyJID));
        Assert.assertEquals((Object)RosterAbstract.SubscriptionType.none_pre_approved, (Object)this.getSubscription(this.buddyJID));
    }

    @Test
    public void test_subscribingBothPreapproval() throws XMPPException, TigaseStringprepException, TigaseDBException {
        Queue<Packet> results = this.processPresence(this.userJID, this.buddyJID, StanzaType.subscribe);
        Assert.assertEquals((Object)StanzaType.subscribe, (Object)results.poll().getType());
        results = this.processPresence(this.userJID, this.buddyJID, StanzaType.subscribed);
        Assert.assertTrue((boolean)this.rosterUtil.isPreApproved(this.session, this.buddyJID));
        Assert.assertEquals((Object)RosterAbstract.SubscriptionType.none_pending_out_pre_approved, (Object)this.getSubscription(this.buddyJID));
        results = this.processPresence(this.buddyJID, this.userJID, StanzaType.subscribed);
        Assert.assertEquals((Object)RosterAbstract.SubscriptionType.to_pre_approved, (Object)this.getSubscription(this.buddyJID));
        results = this.processPresence(this.buddyJID, this.userJID, StanzaType.subscribe);
        Assert.assertEquals((Object)RosterAbstract.SubscriptionType.both, (Object)this.getSubscription(this.buddyJID));
    }

    @Test
    public void test_subscribingBothPreapproval2() throws XMPPException, TigaseStringprepException, TigaseDBException {
        Queue<Packet> results = this.processPresence(this.userJID, this.buddyJID, StanzaType.subscribe);
        Assert.assertEquals((Object)StanzaType.subscribe, (Object)results.poll().getType());
        results = this.processPresence(this.userJID, this.buddyJID, StanzaType.subscribed);
        Assert.assertTrue((boolean)this.rosterUtil.isPreApproved(this.session, this.buddyJID));
        Assert.assertEquals((Object)RosterAbstract.SubscriptionType.none_pending_out_pre_approved, (Object)this.getSubscription(this.buddyJID));
        results = this.processPresence(this.buddyJID, this.userJID, StanzaType.subscribe);
        Assert.assertEquals((Object)RosterAbstract.SubscriptionType.from_pending_out, (Object)this.getSubscription(this.buddyJID));
        results = this.processPresence(this.buddyJID, this.userJID, StanzaType.subscribed);
        Assert.assertEquals((Object)RosterAbstract.SubscriptionType.both, (Object)this.getSubscription(this.buddyJID));
    }

    private RosterAbstract.SubscriptionType getSubscription(JID jid) throws TigaseDBException, NotAuthorizedException {
        return this.rosterUtil.getBuddySubscription(this.session, jid);
    }

    private Queue<Packet> processPresence(JID from, JID to, StanzaType stanzaType) throws XMPPException {
        Packet packet = Packet.packetInstance((Element)new Element("presence", new String[]{"type"}, new String[]{stanzaType.name()}), (JID)from, (JID)to);
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        this.presenceSubscription.process(packet, this.session, null, results, new HashMap());
        return results;
    }
}

