/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.time.Duration;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Before;
import tigase.TestLogger;
import tigase.kernel.AbstractKernelWithUserRepositoryTestCase;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.server.PacketWriterWithTimeout;
import tigase.server.xmppsession.SessionManagerHandler;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.vhosts.DummyVHostManager;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostItemImpl;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public abstract class ProcessorTestCase
extends AbstractKernelWithUserRepositoryTestCase {
    private static final Logger log = TestLogger.getLogger(ProcessorTestCase.class);
    private SessionManagerHandler loginHandler;

    public SessionManagerHandler getSessionManagerHandler() {
        return this.loginHandler;
    }

    @Before
    public void setSessionManager() throws Exception {
        this.loginHandler = new SessionManagerHandlerImpl(this);
    }

    @Override
    protected void registerBeans(Kernel kernel) {
        super.registerBeans(kernel);
        kernel.registerBean("vHostManager").asClass(DummyVHostManager.class).exportable().setActive(true).exec();
    }

    @After
    public void tearDownSessionManager() throws Exception {
        this.loginHandler = null;
    }

    @Deprecated
    public void setUp() throws Exception {
    }

    @Deprecated
    public void tearDown() throws Exception {
    }

    protected XMPPResourceConnection getSession(JID connId, JID userJid) throws NotAuthorizedException, TigaseStringprepException {
        return this.getSession(connId, userJid, true);
    }

    protected XMPPResourceConnection getSession(JID connId, JID userJid, boolean authorised) throws NotAuthorizedException, TigaseStringprepException {
        XMPPResourceConnection conn = new XMPPResourceConnection(connId, this.getUserRepository(), this.getAuthRepository(), this.loginHandler);
        VHostItemImpl vhost = new VHostItemImpl();
        vhost.setVHost(userJid.getDomain());
        conn.setDomain((VHostItem)vhost);
        if (authorised) {
            conn.authorizeJID(userJid.getBareJID(), false);
            conn.setResource(userJid.getResource());
        }
        return conn;
    }

    public class SessionManagerHandlerImpl
    implements SessionManagerHandler,
    PacketWriterWithTimeout {
        Map<BareJID, XMPPSession> sessions = new HashMap<BareJID, XMPPSession>();
        private Queue<Item> outQueue = new ArrayDeque<Item>();

        public SessionManagerHandlerImpl(ProcessorTestCase this$0) {
        }

        public JID getComponentId() {
            return JID.jidInstanceNS((String)"sess-man@localhost");
        }

        public void handleLogin(BareJID userId, XMPPResourceConnection conn) {
            XMPPSession session = this.sessions.get(userId);
            if (session == null) {
                session = new XMPPSession(userId.getLocalpart());
                this.sessions.put(userId, session);
            }
            try {
                session.addResourceConnection(conn);
            }
            catch (TigaseStringprepException ex) {
                log.log(Level.SEVERE, null, ex);
            }
        }

        public void handleLogout(BareJID userId, XMPPResourceConnection conn) {
            XMPPSession session = this.sessions.get(conn);
            if (session != null) {
                session.removeResourceConnection(conn);
                if (session.getActiveResourcesSize() == 0) {
                    this.sessions.remove(userId);
                }
            }
        }

        public void handlePresenceSet(XMPPResourceConnection conn) {
        }

        public void handleResourceBind(XMPPResourceConnection conn) {
        }

        public boolean isLocalDomain(String domain, boolean includeComponents) {
            return !domain.contains("-ext");
        }

        public void handleDomainChange(String domain, XMPPResourceConnection conn) {
        }

        public Queue<Item> getOutQueue() {
            return this.outQueue;
        }

        public boolean addOutPacketWithTimeout(Packet packet, Duration timeout, PacketWriterWithTimeout.Handler handler) {
            return this.outQueue.offer(new Item(this, packet, handler));
        }

        public class Item {
            public final Packet packet;
            public final PacketWriterWithTimeout.Handler handler;

            Item(SessionManagerHandlerImpl this$1, Packet packet, PacketWriterWithTimeout.Handler handler) {
                this.packet = packet;
                this.handler = handler;
            }

            public Packet getPacket() {
                return this.packet;
            }
        }
    }
}

