/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.eventbus.EventBusFactory;
import tigase.kernel.core.Kernel;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.BindResource;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class BindResourceTest
extends ProcessorTestCase {
    private BindResource bindResource;

    @Override
    @Before
    public void setUp() throws Exception {
        this.bindResource = this.getInstance(BindResource.class);
        this.bindResource.init(new HashMap());
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.bindResource = null;
        super.tearDown();
    }

    @Test
    public void testNoEscaping() throws TigaseStringprepException, XMPPException {
        BareJID user = BareJID.bareJIDInstance((String)"test@example.com");
        this.testAuthentication(user, "test-1", "test-1");
    }

    @Test
    public void testEscapingApos() throws TigaseStringprepException, XMPPException {
        BareJID user = BareJID.bareJIDInstance((String)"test@example.com");
        this.testAuthentication(user, "test's", "test&apos;s");
    }

    @Test
    public void testEscapingQuote() throws TigaseStringprepException, XMPPException {
        BareJID user = BareJID.bareJIDInstance((String)"test@example.com");
        this.testAuthentication(user, "test \"cat\"", "test &quot;cat&quot;");
    }

    private void testAuthentication(BareJID user, String resource, String expectedResource) throws TigaseStringprepException, XMPPException {
        XMPPResourceConnection conn = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), JID.jidInstance((BareJID)user, (String)"res"), false);
        conn.authorizeJID(user, false);
        ArrayDeque results = new ArrayDeque();
        Element iq = new Element("iq").withAttribute("type", "set").withAttribute("id", "test-1").withElement("bind", "urn:ietf:params:xml:ns:xmpp-bind", bindEl -> bindEl.withElement("resource", null, resource));
        this.bindResource.process((Packet)new Iq(iq), conn, null, results, null);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)expectedResource, (Object)conn.getResource());
        Packet result = (Packet)results.poll();
        Assert.assertEquals((Object)StanzaType.result, (Object)result.getType());
        Assert.assertEquals((Object)JID.jidInstance((BareJID)user, (String)expectedResource).toString(), (Object)result.getElemChild("bind", "urn:ietf:params:xml:ns:xmpp-bind").getChild("jid").getCData());
    }

    @Override
    protected void registerBeans(Kernel kernel) {
        super.registerBeans(kernel);
        kernel.registerBean("eventbus").asInstance((Object)EventBusFactory.getInstance()).exportable().exec();
        kernel.registerBean(BindResource.class).setActive(true).exportable().exec();
    }
}

