/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.TestLogger;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.AddressingSanitizer;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class AddressingSanitizerTest
extends ProcessorTestCase {
    private static final Logger log = TestLogger.getLogger(AddressingSanitizerTest.class);
    private AddressingSanitizer addressingSanitizer;
    private JID recipientJid = JID.jidInstanceNS((String)"recipient@example.com/res-2");
    private Queue<Packet> results;
    private JID senderJid = JID.jidInstanceNS((String)"sender@example.com/res-1");
    private XMPPResourceConnection senderSession;
    private Map<String, Object> settings = new HashMap<String, Object>();

    @Override
    @Before
    public void setUp() throws Exception {
        this.addressingSanitizer = new AddressingSanitizer();
        this.senderSession = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), this.senderJid);
        this.results = new ArrayDeque<Packet>();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.addressingSanitizer = null;
        this.senderSession = null;
        this.results = null;
    }

    @Test
    public void testMessageWithFromAndTo() throws TigaseStringprepException, NotAuthorizedException, NoConnectionIdException {
        Packet p = this.getPacket("message", null, null);
        p.setPacketFrom(this.senderSession.getConnectionId());
        p.getElement().setAttribute("from", this.senderJid.getBareJID().toString());
        p.getElement().setAttribute("to", this.recipientJid.toString());
        p.initVars();
        Assert.assertFalse((boolean)this.addressingSanitizer.preProcess(p, this.senderSession, null, this.results, this.settings));
        Assert.assertEquals((long)0L, (long)this.results.size());
        Assert.assertEquals((Object)this.senderJid, (Object)p.getStanzaFrom());
        Assert.assertEquals((Object)this.recipientJid, (Object)p.getStanzaTo());
    }

    @Test
    public void testMessageWithIncorrectFromInStanza() throws TigaseStringprepException, NotAuthorizedException, NoConnectionIdException {
        Packet p = this.getPacket("message", null, "my_user@domain.com");
        p.setPacketFrom(this.senderSession.getConnectionId());
        Assert.assertFalse((boolean)this.addressingSanitizer.preProcess(p, this.senderSession, null, this.results, this.settings));
        Assert.assertEquals((long)0L, (long)this.results.size());
        Assert.assertEquals((Object)this.senderJid, (Object)p.getStanzaFrom());
        Assert.assertEquals((Object)this.senderJid.copyWithoutResource(), (Object)p.getStanzaTo());
    }

    @Test
    public void testMessageWithSameFromInStanza() throws TigaseStringprepException, NotAuthorizedException, NoConnectionIdException {
        Packet p = this.getPacket("message", null, this.senderJid.toString());
        p.setPacketFrom(this.senderSession.getConnectionId());
        Assert.assertFalse((boolean)this.addressingSanitizer.preProcess(p, this.senderSession, null, this.results, this.settings));
        Assert.assertEquals((long)0L, (long)this.results.size());
        Assert.assertEquals((Object)this.senderJid, (Object)p.getStanzaFrom());
        Assert.assertEquals((Object)this.senderJid.copyWithoutResource(), (Object)p.getStanzaTo());
    }

    @Test
    public void testMessageWithoutFrom() throws TigaseStringprepException, NotAuthorizedException, NoConnectionIdException {
        Packet p = this.getPacket("message", null, null);
        p.setPacketFrom(this.senderSession.getConnectionId());
        Assert.assertFalse((boolean)this.addressingSanitizer.preProcess(p, this.senderSession, null, this.results, this.settings));
        Assert.assertEquals((long)0L, (long)this.results.size());
        Assert.assertEquals((Object)this.senderJid, (Object)p.getStanzaFrom());
        Assert.assertEquals((Object)this.senderJid.copyWithoutResource(), (Object)p.getStanzaTo());
    }

    @Test
    public void testPresenceSubscriptionWithFromBareJid() throws TigaseStringprepException, NotAuthorizedException, NoConnectionIdException {
        Packet p = this.getPacket("presence", StanzaType.subscribe, this.senderJid.getBareJID().toString());
        p.getElement().setAttribute("type", "subscribe");
        p.setPacketFrom(this.senderSession.getConnectionId());
        Assert.assertFalse((boolean)this.addressingSanitizer.preProcess(p, this.senderSession, null, this.results, this.settings));
        Assert.assertEquals((long)0L, (long)this.results.size());
        Assert.assertEquals((Object)JID.jidInstance((BareJID)this.senderJid.getBareJID()), (Object)p.getStanzaFrom());
        Assert.assertNull((Object)p.getStanzaTo());
        p.setServerAuthorisedStanzaFrom(JID.jidInstanceNS((BareJID)this.senderJid.getBareJID()));
        Assert.assertFalse((boolean)this.addressingSanitizer.preProcess(p, this.senderSession, null, this.results, this.settings));
        Assert.assertEquals((long)0L, (long)this.results.size());
        Assert.assertEquals((Object)JID.jidInstance((BareJID)this.senderJid.getBareJID()), (Object)p.getStanzaFrom());
        Assert.assertNull((Object)p.getStanzaTo());
    }

    @Test
    public void testPresenceSubscriptionWithFromFullJid() throws TigaseStringprepException, NotAuthorizedException, NoConnectionIdException {
        Packet p = this.getPacket("presence", StanzaType.subscribe, this.senderJid.toString());
        p.getElement().setAttribute("type", "subscribe");
        p.setPacketFrom(this.senderSession.getConnectionId());
        Assert.assertFalse((boolean)this.addressingSanitizer.preProcess(p, this.senderSession, null, this.results, this.settings));
        Assert.assertEquals((long)0L, (long)this.results.size());
        Assert.assertEquals((Object)JID.jidInstance((BareJID)this.senderJid.getBareJID()), (Object)p.getStanzaFrom());
        p.setServerAuthorisedStanzaFrom(this.senderJid);
        Assert.assertFalse((boolean)this.addressingSanitizer.preProcess(p, this.senderSession, null, this.results, this.settings));
        Assert.assertEquals((long)0L, (long)this.results.size());
        Assert.assertEquals((Object)JID.jidInstance((BareJID)this.senderJid.getBareJID()), (Object)p.getStanzaFrom());
        Assert.assertNull((Object)p.getStanzaTo());
    }

    @Test
    public void testPresenceSubscriptionWithIncorrectFrom() throws TigaseStringprepException, NotAuthorizedException, NoConnectionIdException {
        JID from = JID.jidInstanceNS((String)"my_user@domain.com");
        Packet p = this.getPacket("presence", StanzaType.subscribe, from.toString());
        p.getElement().setAttribute("type", "subscribe");
        p.setPacketFrom(this.senderSession.getConnectionId());
        Assert.assertFalse((boolean)this.addressingSanitizer.preProcess(p, this.senderSession, null, this.results, this.settings));
        Assert.assertEquals((long)0L, (long)this.results.size());
        Assert.assertEquals((Object)JID.jidInstance((BareJID)this.senderJid.getBareJID()), (Object)p.getStanzaFrom());
        Assert.assertNull((Object)p.getStanzaTo());
        p.setServerAuthorisedStanzaFrom(this.senderJid);
        Assert.assertFalse((boolean)this.addressingSanitizer.preProcess(p, this.senderSession, null, this.results, this.settings));
        Assert.assertEquals((long)0L, (long)this.results.size());
        Assert.assertEquals((Object)JID.jidInstance((BareJID)this.senderJid.getBareJID()), (Object)p.getStanzaFrom());
        Assert.assertNull((Object)p.getStanzaTo());
    }

    @Test
    public void testPresenceSubscriptionWithoutFrom() throws TigaseStringprepException, NotAuthorizedException, NoConnectionIdException {
        Packet p = this.getPacket("presence", StanzaType.subscribe, null);
        p.setPacketFrom(this.senderSession.getConnectionId());
        p.initVars();
        Assert.assertFalse((boolean)this.addressingSanitizer.preProcess(p, this.senderSession, null, this.results, this.settings));
        Assert.assertEquals((long)0L, (long)this.results.size());
        Assert.assertEquals((Object)JID.jidInstance((BareJID)this.senderJid.getBareJID()), (Object)p.getStanzaFrom());
        Assert.assertNull((Object)p.getStanzaTo());
        p.setServerAuthorisedStanzaFrom(null);
        Assert.assertFalse((boolean)this.addressingSanitizer.preProcess(p, this.senderSession, null, this.results, this.settings));
        Assert.assertEquals((long)0L, (long)this.results.size());
        Assert.assertEquals((Object)JID.jidInstance((BareJID)this.senderJid.getBareJID()), (Object)p.getStanzaFrom());
        Assert.assertNull((Object)p.getStanzaTo());
    }

    @Test
    public void testPresenceWithFrom() throws TigaseStringprepException, NotAuthorizedException, NoConnectionIdException {
        Packet p = this.getPacket("presence", null, this.senderJid.getBareJID().toString());
        p.setPacketFrom(this.senderSession.getConnectionId());
        Assert.assertFalse((boolean)this.addressingSanitizer.preProcess(p, this.senderSession, null, this.results, this.settings));
        Assert.assertEquals((long)0L, (long)this.results.size());
        Assert.assertEquals((Object)this.senderJid, (Object)p.getStanzaFrom());
        Assert.assertNull((Object)p.getStanzaTo());
    }

    @Test
    public void testPresenceWithWrongFrom() throws TigaseStringprepException, NotAuthorizedException, NoConnectionIdException {
        Packet p = this.getPacket("presence", null, "my_user@domain.com");
        p.setPacketFrom(this.senderSession.getConnectionId());
        Assert.assertFalse((boolean)this.addressingSanitizer.preProcess(p, this.senderSession, null, this.results, this.settings));
        Assert.assertEquals((long)0L, (long)this.results.size());
        Assert.assertEquals((Object)this.senderJid, (Object)p.getStanzaFrom());
        Assert.assertNull((Object)p.getStanzaTo());
    }

    @Test
    public void testPresenceWithoutFrom() throws TigaseStringprepException, NotAuthorizedException, NoConnectionIdException {
        Packet p = this.getPacket("presence", null, null);
        p.setPacketFrom(this.senderSession.getConnectionId());
        Assert.assertFalse((boolean)this.addressingSanitizer.preProcess(p, this.senderSession, null, this.results, this.settings));
        Assert.assertEquals((long)0L, (long)this.results.size());
        Assert.assertEquals((Object)this.senderJid, (Object)p.getStanzaFrom());
        Assert.assertNull((Object)p.getStanzaTo());
    }

    private Packet getPacket(String elementName, StanzaType type, String from) throws TigaseStringprepException {
        Element element = new Element(elementName);
        if (from != null && !from.isEmpty()) {
            element.setAttribute("from", from);
        }
        if (type != null) {
            element.setAttribute("type", type.toString());
        }
        return Packet.packetInstance((Element)element);
    }
}

