/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.util.LinkedHashMap;
import java.util.logging.Level;
import org.junit.Assert;
import org.junit.Test;
import tigase.stats.StatisticsList;

public class StatisticsListTest {
    @Test
    public void testNonZeroRecords() {
        String compName = "comp";
        StatisticsList statRecords = new StatisticsList(Level.INFO);
        statRecords.add("comp", "long", 1L, Level.INFO);
        statRecords.add("comp", "int", 2, Level.INFO);
        statRecords.add("comp", "string", "string", Level.INFO);
        statRecords.add("comp", "float", 3.4f, Level.INFO);
        statRecords.add("comp", "long-zero", 0L, Level.INFO);
        statRecords.add("comp", "int-zero", 0, Level.INFO);
        statRecords.add("comp", "string-zero", "", Level.INFO);
        statRecords.add("comp", "float-zero", 0.0f, Level.INFO);
        LinkedHashMap compStats = statRecords.getCompStats("comp");
        Assert.assertTrue((String)"Wrong collection size!", (compStats.size() == 4 ? 1 : 0) != 0);
        Assert.assertNotNull(compStats.get("long"));
        Assert.assertNotNull(compStats.get("int"));
        Assert.assertNotNull(compStats.get("string"));
        Assert.assertNotNull(compStats.get("float"));
        Assert.assertNull(compStats.get("long-zero"));
        Assert.assertNull(compStats.get("int-zero"));
        Assert.assertNull(compStats.get("string-zero"));
        Assert.assertNull(compStats.get("float-zero"));
        statRecords = new StatisticsList(Level.FINEST);
        statRecords.add("comp", "long", 1L, Level.INFO);
        statRecords.add("comp", "int", 2, Level.INFO);
        statRecords.add("comp", "string", "string", Level.INFO);
        statRecords.add("comp", "float", 3.4f, Level.INFO);
        statRecords.add("comp", "long-zero", 0L, Level.INFO);
        statRecords.add("comp", "int-zero", 0, Level.INFO);
        statRecords.add("comp", "string-zero", "", Level.INFO);
        statRecords.add("comp", "float-zero", 0.0f, Level.INFO);
        compStats = statRecords.getCompStats("comp");
        Assert.assertTrue((String)"Wrong collection size!", (compStats.size() == 8 ? 1 : 0) != 0);
        Assert.assertNotNull(compStats.get("long"));
        Assert.assertNotNull(compStats.get("int"));
        Assert.assertNotNull(compStats.get("string"));
        Assert.assertNotNull(compStats.get("float"));
        Assert.assertNotNull(compStats.get("long-zero"));
        Assert.assertNotNull(compStats.get("int-zero"));
        Assert.assertNotNull(compStats.get("string-zero"));
        Assert.assertNotNull(compStats.get("float-zero"));
    }
}

