/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppsession.adhoc;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.component.DSLBeanConfiguratorWithBackwardCompatibility;
import tigase.eventbus.EventBusFactory;
import tigase.form.Form;
import tigase.io.CertificateContainer;
import tigase.io.SSLContextContainer;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.core.Kernel;
import tigase.server.ConnectionManager;
import tigase.server.xmppserver.CID;
import tigase.server.xmppserver.CIDConnections;
import tigase.server.xmppserver.KnownDomainsListProvider;
import tigase.server.xmppserver.S2SConnManAbstractTest;
import tigase.server.xmppserver.S2SConnectionHandlerIfc;
import tigase.server.xmppserver.S2SIOService;
import tigase.server.xmppserver.S2SRandomSelector;
import tigase.server.xmppserver.proc.AuthenticatorSelectorManager;
import tigase.server.xmppsession.adhoc.SuggestedDomainsListAdhoc;
import tigase.vhosts.DefaultAwareVHostManagerIfc;
import tigase.vhosts.DummyVHostManager;

public class SuggestedDomainsListAdhocTest {
    public static Kernel kernel;
    private static AuthenticatorSelectorManager authenticatorSelectorManager;
    private static CID cid;
    private static DummyVHostManager dummyVHostManager;
    private static S2SConnManAbstractTest.S2SConnectionHandlerImpl handler;
    private static SuggestedDomainsListAdhoc suggestedDomainsListAdhoc;

    protected static void addCID(String localHostname, String remoteHostname) {
        CID cid = new CID(localHostname, remoteHostname);
        S2SConnManAbstractTest.fastCIDConnections fastCIDConnections2 = new S2SConnManAbstractTest.fastCIDConnections(cid, (S2SConnectionHandlerIfc<S2SIOService>)handler);
        authenticatorSelectorManager.authenticateConnection(new S2SIOService(), (CIDConnections)fastCIDConnections2, cid);
        if (dummyVHostManager.getVHostItem(localHostname) == null) {
            dummyVHostManager.addVhost(localHostname);
        }
    }

    private static DSLBeanConfiguratorWithBackwardCompatibility prepareKernel() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("name", "s2s");
        kernel = new Kernel();
        kernel.setName("s2s");
        kernel.setForceAllowNull(true);
        kernel.registerBean(DefaultTypesConverter.class).exec();
        kernel.registerBean(DSLBeanConfiguratorWithBackwardCompatibility.class).exportable().exec();
        DSLBeanConfiguratorWithBackwardCompatibility config = (DSLBeanConfiguratorWithBackwardCompatibility)kernel.getInstance(DSLBeanConfiguratorWithBackwardCompatibility.class);
        config.setProperties(props);
        kernel.registerBean("eventBus").asInstance((Object)EventBusFactory.getInstance()).exportable().exec();
        kernel.registerBean(ConnectionManager.PortsConfigBean.class).exec();
        kernel.registerBean(CIDConnections.CIDConnectionsOpenerService.class).exportable().exec();
        kernel.registerBean(S2SRandomSelector.class).exportable().exec();
        kernel.registerBean(CertificateContainer.class).exportable().exec();
        kernel.registerBean(KnownDomainsListProvider.class).exportable().setActive(true).exec();
        kernel.registerBean(AuthenticatorSelectorManager.class).exportable().setActive(true).exec();
        kernel.registerBean("vHostManager").asClass(DummyVHostManager.class).exportable().setActive(true).exec();
        kernel.registerBean(SSLContextContainer.class).exportable().setActive(true).exec();
        kernel.registerBean("service").asClass(S2SConnManAbstractTest.S2SConnectionHandlerImpl.class).setActive(true).exec();
        kernel.registerBean(SuggestedDomainsListAdhoc.class).setActive(true).exec();
        return config;
    }

    @Test
    public void prepareForm() {
        Form form = suggestedDomainsListAdhoc.prepareForm();
        List<String> knownRemoteDomains = Arrays.asList(form.getAsStrings("knownRemoteDomains"));
        List<String> localDomains = Arrays.asList(form.getAsStrings("localDomains"));
        Assert.assertTrue((boolean)knownRemoteDomains.contains("tigase.org"));
        Assert.assertTrue((boolean)knownRemoteDomains.contains("tigase.net"));
        Assert.assertTrue((boolean)knownRemoteDomains.contains("tigase.im"));
        Assert.assertTrue((boolean)knownRemoteDomains.contains("sure.im"));
        Assert.assertTrue((boolean)knownRemoteDomains.contains("jabber.today"));
        Assert.assertTrue((boolean)localDomains.contains("my-other-local-domain.org"));
        Assert.assertTrue((boolean)localDomains.contains("my-local-domain.net"));
        Assert.assertFalse((boolean)localDomains.contains("default"));
    }

    @Before
    public void setUp() throws Exception {
        SuggestedDomainsListAdhocTest.prepareKernel();
        authenticatorSelectorManager = (AuthenticatorSelectorManager)kernel.getInstance(AuthenticatorSelectorManager.class);
        dummyVHostManager = (DummyVHostManager)kernel.getInstance(DefaultAwareVHostManagerIfc.class);
        handler = (S2SConnManAbstractTest.S2SConnectionHandlerImpl)((Object)kernel.getInstance(S2SConnManAbstractTest.S2SConnectionHandlerImpl.class));
        suggestedDomainsListAdhoc = (SuggestedDomainsListAdhoc)kernel.getInstance(SuggestedDomainsListAdhoc.class);
        dummyVHostManager.addVhost("default");
        SuggestedDomainsListAdhocTest.addCID("my-local-domain.net", "tigase.org");
        SuggestedDomainsListAdhocTest.addCID("my-local-domain.net", "tigase.net");
        SuggestedDomainsListAdhocTest.addCID("my-local-domain.net", "tigase.im");
        SuggestedDomainsListAdhocTest.addCID("my-local-domain.net", "sure.im");
        SuggestedDomainsListAdhocTest.addCID("my-other-local-domain.org", "tigase.org");
        SuggestedDomainsListAdhocTest.addCID("my-other-local-domain.org", "tigase.net");
        SuggestedDomainsListAdhocTest.addCID("my-other-local-domain.org", "tigase.im");
        SuggestedDomainsListAdhocTest.addCID("my-other-local-domain.org", "jabber.today");
    }

    static {
        handler = null;
    }
}

