/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver;

import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import tigase.server.xmppserver.S2SConnManAbstractTest;

@Ignore
public class S2SConnManTest
extends S2SConnManAbstractTest {
    @BeforeClass
    public static void setup() {
        S2SConnManAbstractTest.setup();
        S2SConnManTest.setupCID();
    }

    private static void setupCID() {
        String localHostname = S2SConnManTest.localHostname();
        String remoteHostname = System.getProperty("test-remote-hostname", "wojtek-local.tigase.eu");
        S2SConnManTest.setupCID(localHostname, remoteHostname);
    }

    private static String localHostname() {
        return System.getProperty("test-local-hostname", "tigase.im");
    }

    @Test
    public void testS2STigase_defaults() {
        this.testS2STigaseConnectionManager(S2SConnManTest.localHostname(), null);
    }

    @Test
    public void testS2STigase_default_w_TLS13_only() {
        this.testS2STigaseConnectionManager(S2SConnManTest.localHostname(), new String[]{"TLSv1.3"});
    }

    @Test
    public void testS2STigase_default_w_TLS13_w_SSLv2Hello() {
        this.testS2STigaseConnectionManager(S2SConnManTest.localHostname(), new String[]{"TLSv1.3", "TLSv1.2", "TLSv1.1", "TLSv1", "SSLv2Hello"});
    }

    @Test
    public void testS2STigase_default_w_TLS13_wo_SSLv2Hello() {
        this.testS2STigaseConnectionManager(S2SConnManTest.localHostname(), new String[]{"TLSv1.3", "TLSv1.2", "TLSv1.1", "TLSv1"});
    }

    @Test
    public void testS2STigase_default_wo_TLS13_wo_SSLv2Hello() {
        this.testS2STigaseConnectionManager(S2SConnManTest.localHostname(), new String[]{"TLSv1.2", "TLSv1.1", "TLSv1"});
    }

    @Test
    public void testS2STigase_default_wo_TLS13_w_SSLv2Hello() {
        this.testS2STigaseConnectionManager(S2SConnManTest.localHostname(), new String[]{"TLSv1.2", "TLSv1.1", "TLSv1", "SSLv2Hello"});
    }
}

