/*
 * Decompiled with CFR 0.152.
 */
package tigase.kernel;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Test;
import tigase.TestLogger;
import tigase.component.DSLBeanConfigurator;
import tigase.kernel.Bean1;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.KernelException;
import tigase.kernel.KernelTest;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.core.DependencyGrapher;
import tigase.kernel.core.Kernel;
import tigase.kernel.core.RegistrarKernel;

public class RegistrarBeanKernelTest {
    private static final Logger log = TestLogger.getLogger(KernelTest.class);

    @Test
    public void test01() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        RegistrarKernel krnl = new RegistrarKernel();
        krnl.setName("root");
        krnl.registerBean(DefaultTypesConverter.class).exec();
        krnl.registerBean(DSLBeanConfigurator.class).exec();
        krnl.registerBean(RegistrarBeanImpl.class).exec();
        DependencyGrapher dg = new DependencyGrapher((Kernel)krnl);
        log.log(Level.FINE, dg.getDependencyGraph());
        Assert.assertNotNull((Object)krnl.getInstance("RegistrarBean"));
        Kernel rb1k = (Kernel)krnl.getInstance("RegistrarBean#KERNEL");
        Assert.assertNotEquals(null, (Object)rb1k.getInstance(Bean1.class));
        Assert.assertEquals((Object)krnl.getInstance("RegistrarBean"), (Object)rb1k.getInstance(RegistrarBeanImpl.class));
        Assert.assertNotNull((Object)rb1k.getInstance("service"));
        krnl.setBeanActive("RegistrarBean", false);
        krnl.gc();
        dg = new DependencyGrapher((Kernel)krnl);
        log.log(Level.FINE, dg.getDependencyGraph());
        Assert.assertTrue((boolean)krnl.isBeanClassRegistered("RegistrarBean"));
        boolean exception = false;
        try {
            Assert.assertNull((Object)krnl.getInstance("RegistrarBean#KERNEL"));
        }
        catch (KernelException ex) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void test02() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        RegistrarKernel krnl = new RegistrarKernel();
        krnl.setName("root");
        krnl.registerBean(DefaultTypesConverter.class).exec();
        krnl.registerBean(DSLBeanConfigurator.class).exec();
        krnl.registerBean(DummyBean.class).exec();
        krnl.registerBean(RegistrarBeanImplWithLink.class).exec();
        DependencyGrapher dg = new DependencyGrapher((Kernel)krnl);
        log.log(Level.FINE, dg.getDependencyGraph());
        Assert.assertNotNull((Object)krnl.getInstance("RegistrarBean"));
        Kernel rb1k = (Kernel)krnl.getInstance("RegistrarBean#KERNEL");
        Assert.assertNotEquals(null, (Object)rb1k.getInstance(Bean1.class));
        Assert.assertEquals((Object)krnl.getInstance("RegistrarBean"), (Object)rb1k.getInstance(RegistrarBeanImplWithLink.class));
        Assert.assertNotNull((Object)rb1k.getInstance("service"));
        Assert.assertNotNull((Object)rb1k.getInstance("dummy"));
        Assert.assertNotNull((Object)rb1k.getInstance("DummyBeanUser"));
        Assert.assertNotNull((Object)((DummyBeanUser)rb1k.getInstance((String)"DummyBeanUser")).dummyBean);
        krnl.unregister("DummyBean");
        try {
            Assert.assertNull((Object)rb1k.getDependencyManager().getBeanConfig("dummy"));
            rb1k.getInstance("dummy");
            Assert.assertTrue((boolean)false);
        }
        catch (KernelException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("Unknown bean"));
        }
        Assert.assertNull((Object)((DummyBeanUser)rb1k.getInstance((String)"DummyBeanUser")).dummyBean);
        dg = new DependencyGrapher((Kernel)krnl);
        log.log(Level.FINE, dg.getDependencyGraph());
    }

    @Test
    public void test03() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        RegistrarKernel krnl = new RegistrarKernel();
        krnl.setName("root");
        krnl.registerBean(DefaultTypesConverter.class).exec();
        krnl.registerBean(DSLBeanConfigurator.class).exec();
        krnl.registerBean(DummyBean2.class).exec();
        krnl.registerBean(RegistrarBeanImplWithLink2.class).exec();
        DependencyGrapher dg = new DependencyGrapher((Kernel)krnl);
        log.log(Level.FINE, dg.getDependencyGraph());
        Assert.assertNotNull((Object)krnl.getInstance("RegistrarBean"));
        Kernel rb1k = (Kernel)krnl.getInstance("RegistrarBean#KERNEL");
        Assert.assertNotEquals(null, (Object)rb1k.getInstance(Bean1.class));
        Assert.assertEquals((Object)krnl.getInstance("RegistrarBean"), (Object)rb1k.getInstance(RegistrarBeanImplWithLink2.class));
        Assert.assertNotNull((Object)rb1k.getInstance("service"));
        Assert.assertNotNull((Object)rb1k.getInstance(DummyBean2.class));
        Assert.assertNotNull((Object)rb1k.getInstance("DummyBean2User"));
        Assert.assertNotNull((Object)((DummyBean2User)rb1k.getInstance((String)"DummyBean2User")).dummyBean);
        krnl.unregister("DummyBean2");
        try {
            rb1k.getInstance("DummyBean2");
            Assert.assertTrue((boolean)false);
        }
        catch (KernelException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("Unknown bean"));
        }
        Assert.assertNull((Object)((DummyBean2User)rb1k.getInstance((String)"DummyBean2User")).dummyBean);
        dg = new DependencyGrapher((Kernel)krnl);
        log.log(Level.FINE, dg.getDependencyGraph());
    }

    @Test
    public void test04() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        RegistrarKernel krnl = new RegistrarKernel();
        krnl.setName("root");
        krnl.registerBean(DefaultTypesConverter.class).exec();
        krnl.registerBean(DSLBeanConfigurator.class).exec();
        krnl.registerBean(DummyBean3.class).exec();
        krnl.registerBean(RegistrarBeanImplWithLink3.class).exec();
        DependencyGrapher dg = new DependencyGrapher((Kernel)krnl);
        log.log(Level.FINE, dg.getDependencyGraph());
        Assert.assertNotNull((Object)krnl.getInstance("RegistrarBean"));
        Kernel rb1k = (Kernel)krnl.getInstance("RegistrarBean#KERNEL");
        Assert.assertNotEquals(null, (Object)rb1k.getInstance(Bean1.class));
        Assert.assertEquals((Object)krnl.getInstance("RegistrarBean"), (Object)rb1k.getInstance(RegistrarBeanImplWithLink3.class));
        Assert.assertNotNull((Object)rb1k.getInstance("service"));
        Assert.assertNotNull((Object)rb1k.getInstance("dummy"));
        Assert.assertNotNull((Object)rb1k.getInstance("DummyBean3User"));
        Assert.assertNotNull((Object)rb1k.getInstance("DummyBean34User"));
        Assert.assertNotNull((Object)((DummyBean3User)rb1k.getInstance((String)"DummyBean3User")).dummyBean);
        Assert.assertNotNull((Object)((DummyBean34User)rb1k.getInstance((String)"DummyBean34User")).dummyBean3User);
        krnl.unregister("DummyBean3");
        try {
            Assert.assertNull((Object)rb1k.getDependencyManager().getBeanConfig("dummy"));
            rb1k.getInstance("dummy");
            Assert.assertTrue((boolean)false);
        }
        catch (KernelException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("Unknown bean"));
        }
        try {
            rb1k.getInstance("DummyBean3User");
            Assert.assertTrue((boolean)false);
        }
        catch (KernelException ex) {
            Assert.assertTrue((boolean)true);
        }
        Assert.assertNull((Object)((DummyBean34User)rb1k.getInstance((String)"DummyBean34User")).dummyBean3User);
        krnl.registerBean(DummyBean3.class).exec();
        krnl.ln("DummyBean3", rb1k, "dummy");
        Assert.assertNotNull((Object)((DummyBean3User)rb1k.getInstance((String)"DummyBean3User")).dummyBean);
        Assert.assertNotNull((Object)((DummyBean34User)rb1k.getInstance((String)"DummyBean34User")).dummyBean3User);
        dg = new DependencyGrapher((Kernel)krnl);
        log.log(Level.FINE, dg.getDependencyGraph());
    }

    @Test
    public void test05() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        RegistrarKernel krnl = new RegistrarKernel();
        krnl.registerBean(DefaultTypesConverter.class).exportable().exec();
        krnl.setName("root");
        krnl.registerBean(DSLBeanConfigurator.class).exec();
        krnl.registerBean(DummyBean4.class).exec();
        krnl.registerBean(RegistrarBeanImplWithLink4.class).exec();
        DependencyGrapher dg = new DependencyGrapher((Kernel)krnl);
        log.log(Level.FINE, dg.getDependencyGraph());
        Assert.assertNotNull((Object)krnl.getInstance("RegistrarBean"));
        Kernel rb1k = (Kernel)krnl.getInstance("RegistrarBean#KERNEL");
        Assert.assertNotEquals(null, (Object)rb1k.getInstance(Bean1.class));
        Assert.assertEquals((Object)krnl.getInstance("RegistrarBean"), (Object)rb1k.getInstance(RegistrarBeanImplWithLink4.class));
        Assert.assertNotNull((Object)rb1k.getInstance("service"));
        Assert.assertNotNull((Object)rb1k.getInstance(DummyBean4.class));
        Assert.assertNotNull((Object)rb1k.getInstance("DummyBean4User"));
        Assert.assertNotNull((Object)rb1k.getInstance("DummyBean34User"));
        Assert.assertNotNull((Object)((DummyBean4User)rb1k.getInstance((String)"DummyBean4User")).dummyBean);
        Assert.assertNotNull((Object)((DummyBean34User)rb1k.getInstance((String)"DummyBean34User")).dummyBean4User);
        krnl.unregister("DummyBean4");
        try {
            rb1k.getInstance("DummyBean4");
            Assert.assertTrue((boolean)false);
        }
        catch (KernelException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("Unknown bean"));
        }
        try {
            rb1k.getInstance("DummyBean4User");
            Assert.assertTrue((boolean)false);
        }
        catch (KernelException ex) {
            Assert.assertTrue((boolean)true);
        }
        Assert.assertNull((Object)((DummyBean34User)rb1k.getInstance((String)"DummyBean34User")).dummyBean4User);
        krnl.registerBean(DummyBean4.class).exec();
        Assert.assertNotNull((Object)((DummyBean34User)rb1k.getInstance((String)"DummyBean34User")).dummyBean4User);
        Assert.assertNotNull((Object)((DummyBean4User)rb1k.getInstance((String)"DummyBean4User")).dummyBean);
        dg = new DependencyGrapher((Kernel)krnl);
        log.log(Level.FINE, dg.getDependencyGraph());
    }

    @Bean(name="RegistrarBean", active=true)
    public static class RegistrarBeanImpl
    implements RegistrarBean {
        public void register(Kernel kernel) {
            kernel.registerBean(Bean1.class).exec();
        }

        public void unregister(Kernel kernel) {
            kernel.unregister("bean1");
        }
    }

    @Bean(name="DummyBean", active=true)
    public static class DummyBean {
    }

    @Bean(name="RegistrarBean", active=true)
    public static class RegistrarBeanImplWithLink
    implements RegistrarBean {
        public void register(Kernel kernel) {
            kernel.getParent().ln("DummyBean", kernel, "dummy");
            kernel.registerBean(DummyBeanUser.class).exec();
            kernel.registerBean(Bean1.class).exec();
        }

        public void unregister(Kernel kernel) {
            kernel.unregister("bean1");
        }
    }

    @Bean(name="DummyBeanUser", active=true)
    public static class DummyBeanUser {
        @Inject(nullAllowed=true)
        public DummyBean dummyBean;
    }

    @Bean(name="DummyBean2", active=true, exportable=true)
    public static class DummyBean2 {
    }

    @Bean(name="RegistrarBean", active=true)
    public static class RegistrarBeanImplWithLink2
    implements RegistrarBean {
        public void register(Kernel kernel) {
            kernel.registerBean(DummyBean2User.class).exec();
            kernel.registerBean(Bean1.class).exec();
        }

        public void unregister(Kernel kernel) {
            kernel.unregister("bean1");
        }
    }

    @Bean(name="DummyBean2User", active=true)
    public static class DummyBean2User {
        @Inject(nullAllowed=true)
        public DummyBean2 dummyBean;
    }

    @Bean(name="DummyBean3", active=true)
    public static class DummyBean3 {
    }

    @Bean(name="RegistrarBean", active=true)
    public static class RegistrarBeanImplWithLink3
    implements RegistrarBean {
        public void register(Kernel kernel) {
            kernel.getParent().ln("DummyBean3", kernel, "dummy");
            kernel.registerBean(DummyBean3User.class).exec();
            kernel.registerBean(DummyBean34User.class).exec();
            kernel.registerBean(Bean1.class).exec();
        }

        public void unregister(Kernel kernel) {
            kernel.unregister("bean1");
        }
    }

    @Bean(name="DummyBean3User", active=true)
    public static class DummyBean3User {
        @Inject
        public DummyBean3 dummyBean;
    }

    @Bean(name="DummyBean34User", active=true)
    public static class DummyBean34User {
        @Inject(nullAllowed=true)
        public DummyBean3User dummyBean3User;
        @Inject(nullAllowed=true)
        public DummyBean4User dummyBean4User;
    }

    @Bean(name="DummyBean4", active=true, exportable=true)
    public static class DummyBean4 {
    }

    @Bean(name="RegistrarBean", active=true)
    public static class RegistrarBeanImplWithLink4
    implements RegistrarBean {
        public void register(Kernel kernel) {
            kernel.registerBean(DummyBean4User.class).exec();
            kernel.registerBean(DummyBean34User.class).exec();
            kernel.registerBean(Bean1.class).exec();
        }

        public void unregister(Kernel kernel) {
            kernel.unregister("bean1");
        }
    }

    @Bean(name="DummyBean4User", active=true)
    public static class DummyBean4User {
        @Inject
        public DummyBean4 dummyBean;
    }
}

