/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.credentials.entries;

import org.junit.Assert;
import org.junit.Test;
import tigase.auth.credentials.entries.ScramCredentialsEntry;
import tigase.util.Base64;
import tigase.xmpp.jid.BareJID;

public class ScramCredentialsEntryTest {
    @Test
    public void testDecoding() {
        BareJID user = BareJID.bareJIDInstanceNS((String)"user@domain");
        String encPassword = "s=QSXCR+Q6sek8bf92,i=123,t=6dlGYMOdZcOPutkcNY8U2g7vK9Y=,e=D+CSWLOshSulAsxiupA+qs2/fTE=";
        ScramCredentialsEntry.Decoder decoder = new ScramCredentialsEntry.Decoder("SHA1");
        ScramCredentialsEntry entry = decoder.decode(user, encPassword);
        Assert.assertEquals((Object)"6dlGYMOdZcOPutkcNY8U2g7vK9Y=", (Object)Base64.encode((byte[])entry.getStoredKey()));
        Assert.assertEquals((Object)"D+CSWLOshSulAsxiupA+qs2/fTE=", (Object)Base64.encode((byte[])entry.getServerKey()));
        Assert.assertEquals((Object)"QSXCR+Q6sek8bf92", (Object)Base64.encode((byte[])entry.getSalt()));
        Assert.assertEquals((long)123L, (long)entry.getIterations());
    }

    @Test
    public void testDecodingOfStoredKeysValue() {
        String testPassword = "pencil";
        BareJID user = BareJID.bareJIDInstanceNS((String)"user@domain");
        String encPassword = "s=QSXCR+Q6sek8bf92,i=4096,t=6dlGYMOdZcOPutkcNY8U2g7vK9Y=,e=D+CSWLOshSulAsxiupA+qs2/fTE=";
        ScramCredentialsEntry.Decoder decoder = new ScramCredentialsEntry.Decoder("SHA1");
        ScramCredentialsEntry entry = decoder.decode(user, encPassword);
        Assert.assertEquals((Object)"6dlGYMOdZcOPutkcNY8U2g7vK9Y=", (Object)Base64.encode((byte[])entry.getStoredKey()));
        Assert.assertEquals((Object)"D+CSWLOshSulAsxiupA+qs2/fTE=", (Object)Base64.encode((byte[])entry.getServerKey()));
        Assert.assertEquals((Object)"QSXCR+Q6sek8bf92", (Object)Base64.encode((byte[])entry.getSalt()));
        Assert.assertEquals((long)4096L, (long)entry.getIterations());
        Assert.assertTrue((boolean)entry.verifyPlainPassword(testPassword));
    }

    @Test
    public void testDecodingOfStoredValue() {
        String testPassword = "some-password-do-protect";
        BareJID user = BareJID.bareJIDInstanceNS((String)"user@domain");
        String encPassword = "s=a526P5eUQMim7g==,i=4096,p=lMVlJo/obJ9xI7P9+vZdbwrHjoA=";
        ScramCredentialsEntry.Decoder decoder = new ScramCredentialsEntry.Decoder("SHA1");
        ScramCredentialsEntry entry = decoder.decode(user, encPassword);
        Assert.assertTrue((boolean)entry.verifyPlainPassword(testPassword));
    }

    @Test
    public void testDecodingOfValueWithTranscoding() {
        String testPassword = "pencil";
        BareJID user = BareJID.bareJIDInstanceNS((String)"user@domain");
        String encPassword = "s=QSXCR+Q6sek8bf92,i=4096,p=HZbuOlKbWl+eR8AfIposuKbhX30=";
        ScramCredentialsEntry.Decoder decoder = new ScramCredentialsEntry.Decoder("SHA1");
        ScramCredentialsEntry entry = decoder.decode(user, encPassword);
        Assert.assertEquals((Object)"6dlGYMOdZcOPutkcNY8U2g7vK9Y=", (Object)Base64.encode((byte[])entry.getStoredKey()));
        Assert.assertEquals((Object)"D+CSWLOshSulAsxiupA+qs2/fTE=", (Object)Base64.encode((byte[])entry.getServerKey()));
        Assert.assertEquals((Object)"QSXCR+Q6sek8bf92", (Object)Base64.encode((byte[])entry.getSalt()));
        Assert.assertEquals((long)4096L, (long)entry.getIterations());
        Assert.assertTrue((boolean)entry.verifyPlainPassword(testPassword));
    }

    @Test
    public void testEncodingAndDecoding() {
        String testPassword = "some-password-do-protect";
        BareJID user = BareJID.bareJIDInstanceNS((String)"user@domain");
        ScramCredentialsEntry.Encoder encoder = new ScramCredentialsEntry.Encoder("SHA1");
        String encPassword = encoder.encode(user, testPassword);
        ScramCredentialsEntry.Decoder decoder = new ScramCredentialsEntry.Decoder("SHA1");
        ScramCredentialsEntry entry = decoder.decode(user, encPassword);
        Assert.assertTrue((boolean)entry.verifyPlainPassword(testPassword));
        Assert.assertEquals((Object)encPassword, (Object)encoder.encode(user, entry));
    }

    @Test
    public void testInvalidPassword() {
        BareJID user = BareJID.bareJIDInstanceNS((String)"user@domain");
        String encPassword = "s=QSXCR+Q6sek8bf92,i=4096,t=6dlGYMOdZcOPutkcNY8U2g7vK9Y=,e=D+CSWLOshSulAsxiupA+qs2/fTE=";
        ScramCredentialsEntry.Decoder decoder = new ScramCredentialsEntry.Decoder("SHA1");
        ScramCredentialsEntry entry = decoder.decode(user, encPassword);
        Assert.assertFalse((boolean)entry.verifyPlainPassword("crayon"));
    }

    @Test
    public void testTranscodingEntries() {
        BareJID user = BareJID.bareJIDInstanceNS((String)"user@domain");
        String encPassword = "s=QSXCR+Q6sek8bf92,i=4096,p=HZbuOlKbWl+eR8AfIposuKbhX30=";
        ScramCredentialsEntry.Decoder decoder = new ScramCredentialsEntry.Decoder("SHA1");
        ScramCredentialsEntry.Encoder encoder = new ScramCredentialsEntry.Encoder("SHA1");
        ScramCredentialsEntry entry = decoder.decode(user, encPassword);
        String encAuthData = encoder.encode(user, entry);
        Assert.assertEquals((Object)"s=QSXCR+Q6sek8bf92,i=4096,t=6dlGYMOdZcOPutkcNY8U2g7vK9Y=,e=D+CSWLOshSulAsxiupA+qs2/fTE=", (Object)encAuthData);
        Assert.assertEquals((Object)"6dlGYMOdZcOPutkcNY8U2g7vK9Y=", (Object)Base64.encode((byte[])entry.getStoredKey()));
        Assert.assertEquals((Object)"D+CSWLOshSulAsxiupA+qs2/fTE=", (Object)Base64.encode((byte[])entry.getServerKey()));
        Assert.assertEquals((Object)"QSXCR+Q6sek8bf92", (Object)Base64.encode((byte[])entry.getSalt()));
        Assert.assertEquals((long)4096L, (long)entry.getIterations());
    }
}

