/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import tigase.auth.BruteForceLockerBean;
import tigase.eventbus.impl.EventBusSerializer;
import tigase.kernel.DefaultTypesConverter;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;

public class BruteForceLockerBeanTest {
    @Test
    public void testKeyValueSerialization() {
        BruteForceLockerBean.Key k1 = new BruteForceLockerBean.Key("1.2.3.4", "a@b.c", "c.d");
        BruteForceLockerBean.Value v1 = new BruteForceLockerBean.Value("c.d", "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@b.c"));
        v1.setBadLoginCounter(412);
        v1.setInvalidateAtTime(8352L);
        DefaultTypesConverter converter = new DefaultTypesConverter();
        String k1s = converter.toString((Object)k1);
        String v1s = converter.toString((Object)v1);
        BruteForceLockerBean.Key k2 = (BruteForceLockerBean.Key)converter.convert((Object)k1s, k1.getClass());
        BruteForceLockerBean.Value v2 = (BruteForceLockerBean.Value)converter.convert((Object)v1s, v1.getClass());
        Assert.assertEquals((Object)"1.2.3.4", (Object)k2.getIp());
        Assert.assertEquals((Object)"a@b.c", (Object)k2.getJid());
        Assert.assertEquals((Object)k1, (Object)k2);
        Assert.assertEquals((long)412L, (long)v2.getBadLoginCounter());
        Assert.assertEquals((long)v1.getBadLoginCounter(), (long)v2.getBadLoginCounter());
        Assert.assertEquals((long)8352L, (long)v2.getInvalidateAtTime());
        Assert.assertEquals((long)v1.getInvalidateAtTime(), (long)v2.getInvalidateAtTime());
    }

    @Test
    public void testStatsSerializer() {
        BruteForceLockerBean.StatHolder sh1 = new BruteForceLockerBean.StatHolder();
        sh1.addIP("1.2.3.4");
        sh1.addIP("1.2.3.4");
        sh1.addIP("1.2.3.5");
        sh1.addIP("2.2.3.4");
        sh1.addIP("3.2.3.4");
        sh1.addIP("4.2.3.4");
        sh1.addIP("5.2.3.4");
        sh1.addIP("6.2.3.4");
        sh1.addIP("7.2.3.4");
        sh1.addIP("8.2.3.4");
        sh1.addIP("9.2.3.4");
        sh1.addIP("10.2.3.4");
        sh1.addJID(BareJID.bareJIDInstanceNS((String)"a@b.c"));
        sh1.addJID(BareJID.bareJIDInstanceNS((String)"b@b.c"));
        sh1.addJID(BareJID.bareJIDInstanceNS((String)"c@b.c"));
        sh1.addJID(BareJID.bareJIDInstanceNS((String)"c@b.c"));
        sh1.addJID(BareJID.bareJIDInstanceNS((String)"c@b.c"));
        String[] parcel = sh1.encodeToStrings();
        BruteForceLockerBean.StatHolder sh2 = new BruteForceLockerBean.StatHolder();
        sh2.fillFromString(parcel);
        Assert.assertEquals((long)sh1.getIps().size(), (long)sh2.getIps().size());
        Assert.assertEquals((long)sh1.getJids().size(), (long)sh2.getJids().size());
        Assert.assertEquals((long)11L, (long)sh2.getIps().size());
        Assert.assertEquals((long)3L, (long)sh2.getJids().size());
        sh1.getIps().forEach((ip, count) -> Assert.assertEquals((Object)count, sh2.getIps().get(ip)));
        sh1.getJids().forEach((jid, count) -> Assert.assertEquals((Object)count, sh2.getJids().get(jid)));
    }

    @Test
    public void testStatsSerializer_empty() {
        BruteForceLockerBean.StatHolder sh1 = new BruteForceLockerBean.StatHolder();
        String[] parcel = sh1.encodeToStrings();
        BruteForceLockerBean.StatHolder sh2 = new BruteForceLockerBean.StatHolder();
        sh2.fillFromString(parcel);
        Assert.assertEquals((long)sh1.getIps().size(), (long)sh2.getIps().size());
        Assert.assertEquals((long)sh1.getJids().size(), (long)sh2.getJids().size());
        Assert.assertEquals((long)0L, (long)sh2.getIps().size());
        Assert.assertEquals((long)0L, (long)sh2.getJids().size());
        sh1.getIps().forEach((ip, count) -> Assert.assertEquals((Object)count, sh2.getIps().get(ip)));
        sh1.getJids().forEach((jid, count) -> Assert.assertEquals((Object)count, sh2.getJids().get(jid)));
    }

    @Test
    public void testStatsSerializer_noips() {
        BruteForceLockerBean.StatHolder sh1 = new BruteForceLockerBean.StatHolder();
        sh1.addJID(BareJID.bareJIDInstanceNS((String)"a@b.c"));
        sh1.addJID(BareJID.bareJIDInstanceNS((String)"b@b.c"));
        String[] parcel = sh1.encodeToStrings();
        BruteForceLockerBean.StatHolder sh2 = new BruteForceLockerBean.StatHolder();
        sh2.fillFromString(parcel);
        Assert.assertEquals((long)sh1.getIps().size(), (long)sh2.getIps().size());
        Assert.assertEquals((long)sh1.getJids().size(), (long)sh2.getJids().size());
        Assert.assertEquals((long)0L, (long)sh2.getIps().size());
        Assert.assertEquals((long)2L, (long)sh2.getJids().size());
        sh1.getIps().forEach((ip, count) -> Assert.assertEquals((Object)count, sh2.getIps().get(ip)));
        sh1.getJids().forEach((jid, count) -> Assert.assertEquals((Object)count, sh2.getJids().get(jid)));
    }

    @Test
    public void testStatsSerializer_nojids() {
        BruteForceLockerBean.StatHolder sh1 = new BruteForceLockerBean.StatHolder();
        sh1.addIP("1.2.3.4");
        sh1.addIP("1.2.3.4");
        sh1.addIP("1.2.3.5");
        sh1.addIP("2.2.3.4");
        sh1.addIP("3.2.3.4");
        sh1.addIP("4.2.3.4");
        String[] parcel = sh1.encodeToStrings();
        BruteForceLockerBean.StatHolder sh2 = new BruteForceLockerBean.StatHolder();
        sh2.fillFromString(parcel);
        Assert.assertEquals((long)sh1.getIps().size(), (long)sh2.getIps().size());
        Assert.assertEquals((long)sh1.getJids().size(), (long)sh2.getJids().size());
        Assert.assertEquals((long)5L, (long)sh2.getIps().size());
        Assert.assertEquals((long)0L, (long)sh2.getJids().size());
        sh1.getIps().forEach((ip, count) -> Assert.assertEquals((Object)count, sh2.getIps().get(ip)));
        sh1.getJids().forEach((jid, count) -> Assert.assertEquals((Object)count, sh2.getJids().get(jid)));
    }

    @Test
    public void test3InvalidLoginsAndWait() {
        BruteForceLockerBean bean = new BruteForceLockerBean();
        bean.setMap(new HashMap());
        bean.clearAll();
        bean.addInvalidLogin(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100000L);
        Assert.assertTrue((boolean)bean.isLoginAllowed(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100001L));
        bean.addInvalidLogin(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100002L);
        Assert.assertTrue((boolean)bean.isLoginAllowed(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100003L));
        bean.addInvalidLogin(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100004L);
        Assert.assertTrue((boolean)bean.isLoginAllowed(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100005L));
        bean.addInvalidLogin(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 110006L);
        Assert.assertTrue((boolean)bean.isLoginAllowed(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100007L));
    }

    @Test
    public void testEventSerialization() {
        BruteForceLockerBean.StatHolder holder = new BruteForceLockerBean.StatHolder();
        holder.addIP("1.2.3.4");
        holder.addIP("1.2.3.4");
        holder.addIP("1.2.3.5");
        holder.addIP("2.2.3.4");
        holder.addIP("3.2.3.4");
        holder.addIP("4.2.3.4");
        holder.addIP("5.2.3.4");
        holder.addIP("6.2.3.4");
        holder.addIP("7.2.3.4");
        holder.addIP("8.2.3.4");
        holder.addIP("9.2.3.4");
        holder.addIP("10.2.3.4");
        holder.addJID(BareJID.bareJIDInstanceNS((String)"a@b.c"));
        holder.addJID(BareJID.bareJIDInstanceNS((String)"b@b.c"));
        holder.addJID(BareJID.bareJIDInstanceNS((String)"c@b.c"));
        holder.addJID(BareJID.bareJIDInstanceNS((String)"c@b.c"));
        holder.addJID(BareJID.bareJIDInstanceNS((String)"c@b.c"));
        BruteForceLockerBean.StatisticsEmitEvent event1 = new BruteForceLockerBean.StatisticsEmitEvent();
        event1.setNodeName("name-node-123");
        event1.setStatHolder(holder);
        EventBusSerializer serializer = new EventBusSerializer();
        Element element = serializer.serialize((Object)event1);
        BruteForceLockerBean.StatisticsEmitEvent event2 = (BruteForceLockerBean.StatisticsEmitEvent)serializer.deserialize(element);
        Assert.assertEquals((Object)event2.getNodeName(), (Object)"name-node-123");
        Assert.assertEquals((Object)event1.getNodeName(), (Object)event2.getNodeName());
        Assert.assertEquals((long)event1.getStatHolder().getIps().size(), (long)event2.getStatHolder().getIps().size());
        Assert.assertEquals((long)event1.getStatHolder().getJids().size(), (long)event2.getStatHolder().getJids().size());
        event1.getStatHolder().getIps().forEach((ip, count) -> Assert.assertEquals((Object)count, event2.getStatHolder().getIps().get(ip)));
        event1.getStatHolder().getJids().forEach((jid, count) -> Assert.assertEquals((Object)count, event2.getStatHolder().getJids().get(jid)));
    }

    @Test
    public void test4InvalidLogins() {
        BruteForceLockerBean bean = new BruteForceLockerBean();
        bean.setMap(new HashMap());
        bean.clearAll();
        Assert.assertTrue((boolean)bean.isLoginAllowed(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 99999L));
        bean.addInvalidLogin(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100000L);
        Assert.assertTrue((boolean)bean.isLoginAllowed(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100001L));
        bean.addInvalidLogin(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100002L);
        Assert.assertTrue((boolean)bean.isLoginAllowed(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100003L));
        bean.addInvalidLogin(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100004L);
        Assert.assertTrue((boolean)bean.isLoginAllowed(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100005L));
        bean.addInvalidLogin(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100006L);
        Assert.assertFalse((boolean)bean.isLoginAllowed(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100007L));
        Assert.assertTrue((boolean)bean.isLoginAllowed(null, "1.2.3.5", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100007L));
        Assert.assertTrue((boolean)bean.isLoginAllowed(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"b@bc.d"), 100007L));
        Assert.assertTrue((boolean)bean.isLoginAllowed(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 110007L));
    }
}

