--
-- Tigase Push - Push notifications component for Tigase
-- Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
-- Unauthorized copying of this file, via any medium is strictly prohibited
-- Proprietary and confidential
--

-- QUERY START:
do $$
begin
if exists (select 1 where (select to_regclass('public.tig_push_devices_provider_user_jid')) is null) then
    create index tig_push_devices_provider_user_jid on tig_push_devices ( provider, user_jid );
end if;
end$$;
-- QUERY END:

-- QUERY START:
create or replace function Tig_Push_Stats()
    returns table(
        "type" varchar(100),
        "provider" varchar(100),
        "count" bigint) as '
    select ''all'', provider, count(1) from tig_push_devices group by provider union all select ''accounts'', provider, count(distinct user_jid) from tig_push_devices group by provider;
' LANGUAGE 'sql';
-- QUERY END:
