/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.fcm;

import groovy.json.JsonOutput;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventBusEvent;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.push.AbstractProvider;
import tigase.push.PushNotificationsComponent;
import tigase.push.api.IEncryptedNotification;
import tigase.push.api.INotification;
import tigase.push.api.IPlainNotification;
import tigase.push.api.IPushProvider;
import tigase.push.api.IPushSettings;
import tigase.push.fcm.AccessToken;
import tigase.push.fcm.Credentials;
import tigase.push.fcm.FcmBodyHandler;
import tigase.push.fcm.FcmException;
import tigase.push.fcm.FcmUtil;
import tigase.push.fcm.HttpException;
import tigase.push.utils.ExceptionHelper;

@Bean(name="fcm-http-v1", parent=PushNotificationsComponent.class, active=false)
public class FcmHttpV1Provider
extends AbstractProvider
implements Initializable,
UnregisterAware,
ConfigurationChangedAware,
IPushProvider {
    private static final Logger a = Logger.getLogger(FcmHttpV1Provider.class.getCanonicalName());
    @ConfigField(desc="Provider description")
    private String description = "Push provider for FCM - HTTP v1";
    @ConfigField(desc="Service account file path")
    private String serviceAccountPath;
    @Inject
    private EventBus eventBus;
    private final HttpClient b = HttpClient.newHttpClient();
    private Credentials c;
    private URI d;
    private CompletableFuture<AccessToken> e = null;
    private AccessToken f = null;
    private String g = null;

    public FcmHttpV1Provider() {
        super("fcm-http-v1");
    }

    public void beanConfigurationChanged(Collection<String> collection) {
        if (collection.contains("serviceAccountContent") || collection.contains("serviceAccountPath")) {
            try {
                if (this.g != null) {
                    this.a(Credentials.fromString(this.g));
                } else if (this.serviceAccountPath != null) {
                    this.a(Credentials.fromFile(new File(this.serviceAccountPath)));
                }
            }
            catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException exception) {
                throw new RuntimeException("Could not configure APNs provider!", exception);
            }
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void initialize() {
        if (this.eventBus != null) {
            this.eventBus.registerAll((Object)this);
        }
        this.b();
    }

    public void beforeUnregister() {
        if (this.eventBus != null) {
            this.eventBus.unregisterAll((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Credentials credentials) {
        a.log(Level.CONFIG, "Configuring FCM provider credentials for project: " + credentials.getProjectId());
        FcmHttpV1Provider fcmHttpV1Provider = this;
        synchronized (fcmHttpV1Provider) {
            this.c = credentials;
            this.d = URI.create("https://fcm.googleapis.com/v1/projects/" + credentials.getProjectId() + "/messages:send");
            this.f = null;
            if (this.e != null) {
                this.e.completeExceptionally(new RuntimeException());
            }
        }
    }

    public void setServiceAccountContent(String serviceAccountContent) throws TigaseDBException {
        this.g = serviceAccountContent;
        this.beanConfigurationChanged(List.of("serviceAccountContent"));
        this.setData("service-account", serviceAccountContent);
        this.eventBus.fire((EventBusEvent)new FcmSecretsChangedEvent("push", this.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<AccessToken> getCurrentAccessToken() {
        if (this.c == null) {
            a.log(Level.WARNING, "No FCM credentials configured!");
        }
        FcmHttpV1Provider fcmHttpV1Provider = this;
        synchronized (fcmHttpV1Provider) {
            if (this.f == null || this.f.getExpiresAt().isBefore(LocalDateTime.now())) {
                return this.a();
            }
            if (this.f.getExpiresAt().isBefore(LocalDateTime.now().plusMinutes(10L))) {
                this.a();
            }
            return CompletableFuture.completedFuture(this.f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<AccessToken> a() {
        FcmHttpV1Provider fcmHttpV1Provider = this;
        synchronized (fcmHttpV1Provider) {
            if (this.e == null) {
                this.e = this.c.refreshToken(this.b);
                this.e.whenComplete((accessToken, throwable) -> {
                    FcmHttpV1Provider fcmHttpV1Provider = this;
                    synchronized (fcmHttpV1Provider) {
                        if (accessToken != null) {
                            this.f = accessToken;
                        }
                        if (throwable != null && !this.shouldRetry((Throwable)throwable)) {
                            Throwable throwable2 = throwable;
                            while (throwable.getCause() != null) {
                                throwable2 = throwable.getCause();
                            }
                            if (throwable2 instanceof HttpException) {
                                HttpException httpException = (HttpException)throwable2;
                                a.log(Level.WARNING, "Failed to retrive access token for " + this.c.getProjectId() + ", got error " + String.valueOf(httpException.getMessage() != null ? httpException.getMessage() : Integer.valueOf(httpException.getStatusCode())));
                            } else {
                                a.log(Level.WARNING, "Failed to retrieve access token for " + this.c.getProjectId(), (Throwable)throwable);
                            }
                        }
                        this.e = null;
                    }
                });
            }
            return this.e;
        }
    }

    @Override
    public CompletableFuture<String> pushNotification(IPushSettings.IDevice device, INotification notification) {
        Map<String, Object> map = Map.of("android", this.preparePayload(notification), "token", device.getDeviceId());
        this.sendingPush();
        return this.sendWithRetry(map, 1).whenComplete((string, throwable) -> {
            if (throwable == null) {
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "sent push notification = " + String.valueOf(notification));
                }
            } else {
                this.pushFailed();
                if (a.isLoggable(Level.FINEST)) {
                    Throwable throwable2 = ExceptionHelper.findLoggableException(throwable);
                    if (throwable2 instanceof FcmException) {
                        a.log(Level.FINEST, "failed to send push notification = " + String.valueOf(notification) + ", error: " + throwable2.getMessage());
                    } else {
                        a.log(Level.FINEST, "failed to send push notification = " + String.valueOf(notification), throwable2);
                    }
                }
                Optional.ofNullable(ExceptionHelper.findThrowable(throwable, FcmException.class)).filter(fcmException -> fcmException.getStatus() == FcmException.Status.UNREGISTERED).ifPresent(fcmException -> this.unregisterDevice(device.getDeviceId()));
            }
        });
    }

    protected CompletableFuture<String> sendWithRetry(Map<String, Object> fcmNotification, int tryNo) {
        CompletableFuture<String> completableFuture = new CompletableFuture<String>();
        ((CompletableFuture)this.send(fcmNotification).thenAccept(completableFuture::complete)).exceptionally(throwable2 -> {
            if (tryNo <= 3 && this.shouldRetry((Throwable)throwable2)) {
                ((CompletableFuture)this.sendWithRetry(fcmNotification, tryNo + 1).thenAccept(completableFuture::complete)).exceptionally(throwable -> {
                    completableFuture.completeExceptionally((Throwable)throwable);
                    return null;
                });
            } else {
                completableFuture.completeExceptionally((Throwable)throwable2);
            }
            return null;
        });
        return completableFuture;
    }

    protected boolean shouldRetry(Throwable ex) {
        if (ex instanceof CompletionException) {
            return this.shouldRetry(ex.getCause());
        }
        if (ex instanceof FcmException) {
            switch (((FcmException)ex).getStatus()) {
                case UNAUTHENTICATED: 
                case UNAVAILABLE: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    protected CompletableFuture<String> send(Map<String, Object> fcmNotification) {
        return ((CompletableFuture)this.getCurrentAccessToken().thenCompose(accessToken -> {
            String string = JsonOutput.toJson(Map.of("message", fcmNotification));
            HttpRequest httpRequest = HttpRequest.newBuilder(this.d).setHeader("Authorization", "Bearer " + accessToken.getToken()).POST(HttpRequest.BodyPublishers.ofString(string, StandardCharsets.UTF_8)).build();
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "trying to send push notification " + String.valueOf(fcmNotification) + " at " + String.valueOf(this) + ", request: " + httpRequest.toString());
            }
            return this.b.sendAsync(httpRequest, FcmBodyHandler.ofMap());
        })).thenApply(httpResponse -> FcmUtil.validateString((Map)httpResponse.body(), "name"));
    }

    protected Map<String, Object> preparePayload(INotification notification) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("priority", "high");
        if (notification instanceof IPlainNotification) {
            IPlainNotification iPlainNotification = (IPlainNotification)notification;
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("account", notification.getAccount().toString());
            iPlainNotification.ifMessageCount(l -> hashMap2.put("unread-messages", String.valueOf(l)));
            iPlainNotification.ifLastMessageSender(jID -> hashMap2.put("sender", jID.toString()));
            iPlainNotification.ifGroupchatSenderNickname(string -> hashMap2.put("nickname", (String)string));
            iPlainNotification.ifLastMessageBody(object -> {
                if (((String)object).length() > 512) {
                    object = ((String)object).substring(0, 500) + "...";
                }
                hashMap2.put("body", (String)object);
            });
            iPlainNotification.ifEventName(string -> hashMap2.put("event-name", (String)string));
            hashMap.put("data", hashMap2);
        } else if (notification instanceof IEncryptedNotification) {
            IEncryptedNotification iEncryptedNotification = (IEncryptedNotification)notification;
            HashMap<String, String> hashMap3 = new HashMap<String, String>();
            hashMap3.put("account", notification.getAccount().toString());
            hashMap3.put("encrypted", iEncryptedNotification.getEncrypted());
            hashMap.put("data", hashMap3);
        }
        return hashMap;
    }

    @HandleEvent(filter=HandleEvent.Type.remote)
    public void reloadSecrets(FcmSecretsChangedEvent event) {
        this.b();
    }

    private void b() {
        a.log(Level.CONFIG, "Reloading FCM provider credentials From repository");
        try {
            this.g = this.getData("service-account");
            if (this.g == null) {
                a.log(Level.CONFIG, "No credentials found in repository!");
            }
        }
        catch (TigaseDBException tigaseDBException) {
            a.log(Level.WARNING, "Reloading FCM service account failed", tigaseDBException);
        }
        this.beanConfigurationChanged(List.of("serviceAccountContent"));
    }

    public static class FcmSecretsChangedEvent
    implements Serializable,
    EventBusEvent {
        private String a;
        private String b;

        public FcmSecretsChangedEvent() {
        }

        public FcmSecretsChangedEvent(String componentId, String name) {
            this.a = componentId;
            this.b = name;
        }
    }
}

