/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.apns;

import groovy.json.JsonSlurper;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import tigase.push.apns.APNSUtil;
import tigase.push.apns.ApnsDelegate;
import tigase.push.apns.ApnsNotification;
import tigase.push.apns.ApnsServiceException;
import tigase.util.Algorithms;
import tigase.xmpp.Authorization;

public class ApnsService {
    private static final Logger a = Logger.getLogger(ApnsService.class.getCanonicalName());
    public static final String[] WHITELISTED_HASHES = new String[]{"c0554bde87a075ec13a61f275983ae023957294b454caf0a9724e3b21b7935bc", "56e98deac006a729afa2ed79f9e419df69f451242596d2aaf284c74a855e352e", "7289c06dedd16b71a7dcca66578572e2e109b11d70ad04c2601b6743bc66d07b", "fae46000d8f7042558541e98acf351279589f83b6d3001c18442e4403d111849", "b5cf82d47ef9823f9aa78f123186c52e8879ea84b0f822c91d83e04279b78fd5", "e24f8e8c2185da2f5e88d4579e817c47bf6eafbc8505f0f960fd5a0df4473ad3", "3174d9092f9531c06026ba489891016b436d5ec02623f9aafe2009ecc3e4d557", "c784333d20bcd742b9fdc3236f4e509b8937070e73067e254dd3bf9c45bf4dde"};
    private final Builder b;
    private final String c;
    private HttpClient d;
    private final APNSTokenManager e;
    private long f = 0L;

    public static SSLContext createSSLContext(KeyManager[] keyManagers, String[] whitelistedCertificateHashes) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("sunx509");
        trustManagerFactory.init((KeyStore)null);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        if (whitelistedCertificateHashes != null && whitelistedCertificateHashes.length > 0) {
            TrustManager[] trustManagerArray2 = new TrustManager[trustManagerArray.length + 1];
            for (int i = 0; i < trustManagerArray.length; ++i) {
                trustManagerArray2[i + 1] = trustManagerArray[i];
            }
            trustManagerArray2[0] = new SSLTrustManager(whitelistedCertificateHashes, trustManagerFactory.getTrustManagers());
            sSLContext.init(keyManagers, trustManagerArray2, null);
        } else {
            sSLContext.init(keyManagers, trustManagerArray, null);
        }
        return sSLContext;
    }

    private static HttpClient.Builder a(Builder builder) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLContext sSLContext = ApnsService.createSSLContext(Optional.ofNullable(builder.h).map(KeyManagerFactory::getKeyManagers).orElse(null), builder.i);
        if (builder.h == null && builder.e == null) {
            throw new IllegalArgumentException("Missing encryption key or certificate configuration!");
        }
        SSLParameters sSLParameters = sSLContext.getSupportedSSLParameters();
        sSLParameters.setApplicationProtocols(new String[]{"h2"});
        return HttpClient.newBuilder().sslContext(sSLContext).sslParameters(sSLParameters);
    }

    private ApnsService(Builder builder) throws IOException {
        try {
            this.b = builder;
            this.c = builder.c;
            this.b();
            this.e = builder.e == null ? null : new APNSTokenManager(builder.e);
        }
        catch (Exception exception) {
            throw new IOException("Could not initialize HttpClient", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpClient a() throws IOException, GeneralSecurityException {
        if (this.b.g <= 0L) {
            return this.d;
        }
        ApnsService apnsService = this;
        synchronized (apnsService) {
            if (System.currentTimeMillis() - this.f < TimeUnit.SECONDS.toMillis(this.b.g)) {
                this.f = System.currentTimeMillis();
                return this.d;
            }
            a.log(Level.INFO, () -> "HTTP client expired due to being idle, creating a new instance...");
            this.b();
            if (this.e != null) {
                this.e.regenerateToken();
            }
            this.f = System.currentTimeMillis();
            return this.d;
        }
    }

    private void b() throws IOException {
        try {
            HttpClient.Builder builder = ApnsService.a(this.b);
            if (this.b.f != null) {
                builder.executor(this.b.f);
            }
            this.d = builder.version(HttpClient.Version.HTTP_2).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
            throw new IOException("Could not initialize HttpClient", generalSecurityException);
        }
    }

    public AuthorizationType getAuthorizationType() {
        if (this.e != null) {
            return AuthorizationType.token;
        }
        return AuthorizationType.certificate;
    }

    public CompletableFuture<String> push(ApnsNotification notification) {
        CompletableFuture<String> completableFuture = new CompletableFuture<String>();
        this.push(notification, completableFuture);
        return completableFuture;
    }

    public void push(ApnsNotification notification, CompletableFuture<String> future) {
        HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create("https://" + this.c + "/3/device/" + notification.getDeviceId())).POST(HttpRequest.BodyPublishers.ofString(notification.getPayload().toPayloadString())).header("apns-id", notification.getId()).header("apns-priority", String.valueOf(notification.getPriority()));
        if (notification.getExpiration() > 0L) {
            builder = builder.header("apns-expiration", String.valueOf(notification.getExpiration()));
        }
        try {
            Object object;
            HttpClient httpClient = this.a();
            if (this.e != null) {
                try {
                    object = this.e.getToken();
                    if (a.isLoggable(Level.FINEST)) {
                        a.finest("authenticating request with token " + (String)object);
                    }
                    builder.header("authorization", "bearer " + (String)object);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    a.log(Level.FINEST, "failed to send notification: " + notification.toString() + " at " + String.valueOf(this) + ", exception thrown during auth token generation", generalSecurityException);
                    future.completeExceptionally(generalSecurityException);
                    return;
                }
            }
            builder.header("apns-push-type", notification.getPushType().name());
            if (notification.getCollapseId() != null) {
                builder.header("apns-collapse-id", notification.getCollapseId());
            }
            if (notification.getTopic() != null) {
                builder.header("apns-topic", notification.getTopic());
            }
            object = builder.build();
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "trying to send push notification " + String.valueOf(notification) + " at " + String.valueOf(this) + ", request: " + object.toString() + ", headers: " + String.valueOf(((HttpRequest)object).headers()));
            }
            ((CompletableFuture)httpClient.sendAsync((HttpRequest)object, responseInfo -> HttpResponse.BodySubscribers.ofString(Charset.forName("UTF-8"))).thenAccept(httpResponse -> {
                Object object;
                String string = httpResponse.headers().firstValue("apns-id").get();
                if (a.isLoggable(Level.FINEST)) {
                    object = httpResponse.headers().firstValue("apns-unique-id");
                    a.log(Level.FINEST, "GOT response " + httpResponse.statusCode() + " " + (String)httpResponse.body() + " apns-id " + string + ", apns-unique-id " + String.valueOf(object));
                }
                if ((object = ErrorCode.fromStatus(httpResponse.statusCode())) == null) {
                    if (a.isLoggable(Level.FINEST)) {
                        a.log(Level.FINEST, "sent notification: " + notification.toString() + " at " + String.valueOf(this));
                    }
                    future.complete(string);
                } else {
                    Map map2 = (Map)new JsonSlurper().parse((Reader)new StringReader((String)httpResponse.body()));
                    ErrorType errorType = Optional.ofNullable(map2).map(map -> map.get("reason")).map(Object::toString).map(ErrorType::from).orElse(ErrorType.unknownError);
                    a.log(Level.FINEST, "failed to send notification: " + notification.toString() + " at " + String.valueOf(this) + ", error: " + ((Enum)object).name() + ", response: " + (String)httpResponse.body());
                    future.completeExceptionally((Throwable)((Object)new ApnsServiceException((ErrorCode)((Object)((Object)object)), errorType)));
                }
            })).exceptionally(throwable -> {
                a.log(Level.FINEST, "failed to send notification: " + notification.toString() + " at " + String.valueOf(this) + ", exception thrown!", (Throwable)throwable);
                future.completeExceptionally((Throwable)throwable);
                return null;
            });
        }
        catch (IOException | GeneralSecurityException exception) {
            future.completeExceptionally(exception);
        }
    }

    public void stop() {
    }

    public String toString() {
        return "ApnsService{apnsEndoint='" + this.c + "'}";
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class SSLTrustManager
    implements X509TrustManager {
        private final byte[][] a;
        private final TrustManager[] b;

        public SSLTrustManager(String[] whitelisted, TrustManager[] trustManagers) {
            this.b = trustManagers;
            this.a = (byte[][])Arrays.stream(whitelisted).map(SSLTrustManager::hexDecode).toArray(n -> new byte[n][]);
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            Optional<X509TrustManager> optional = Arrays.stream(this.b).filter(X509TrustManager.class::isInstance).map(X509TrustManager.class::cast).findFirst();
            if (optional.isEmpty()) {
                throw new CertificateException("Could not verify certificate validity");
            }
            optional.get().checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (this.checkCertificateChainFingerprint(chain)) {
                return;
            }
            Optional<X509TrustManager> optional = Arrays.stream(this.b).filter(X509TrustManager.class::isInstance).map(X509TrustManager.class::cast).findFirst();
            if (optional.isEmpty()) {
                throw new CertificateException("Could not verify certificate validity");
            }
            optional.get().checkServerTrusted(chain, authType);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        protected boolean checkCertificateChainFingerprint(X509Certificate[] chain) {
            try {
                for (int i = 0; i < chain.length; ++i) {
                    if (!this.checkCertificateFingerprint(chain[i])) continue;
                    return true;
                }
            }
            catch (Throwable throwable) {
                a.log(Level.FINEST, "Could not check certificate fingerprint", throwable);
            }
            return false;
        }

        protected boolean checkCertificateFingerprint(X509Certificate certificate) throws NoSuchAlgorithmException, CertificateEncodingException {
            byte[] byArray = SSLTrustManager.sha256(certificate.getPublicKey().getEncoded());
            a.finest(() -> "comparing certificate " + String.valueOf(certificate.getSubjectDN()) + " hash " + Algorithms.bytesToHex((byte[])byArray));
            return Arrays.stream(this.a).anyMatch(byArray2 -> Arrays.equals(byArray2, byArray));
        }

        public static byte[] hexDecode(String hex) {
            int n = hex.length();
            byte[] byArray = new byte[n / 2];
            for (int i = 0; i < n; i += 2) {
                byArray[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
            }
            return byArray;
        }

        public static byte[] sha256(byte[] data) throws NoSuchAlgorithmException {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            return messageDigest.digest(data);
        }
    }

    public static class Builder {
        private static final String a = "api.sandbox.push.apple.com";
        private static final String b = "api.push.apple.com";
        private String c = "api.push.apple.com";
        private ApnsDelegate d;
        private EncryptionKey e;
        private Executor f;
        private long g;
        private KeyManagerFactory h;
        private String[] i = new String[0];

        private Builder() {
        }

        public Builder withWhitelistedCertificates(String[] certificateHashes) {
            this.i = certificateHashes;
            return this;
        }

        public Builder withAppleDestination(boolean value) {
            this.c = value ? b : a;
            return this;
        }

        public Builder withCert(String certificatePath, String base64certificate, String certificatePassword) throws IOException {
            if (base64certificate != null) {
                return this.withBase64Cert(base64certificate, certificatePassword);
            }
            if (certificatePath != null) {
                return this.withCert(certificatePath, certificatePassword);
            }
            return this;
        }

        public Builder withCert(String certPath, String certPass) throws IOException {
            try (FileInputStream fileInputStream = new FileInputStream(certPath);){
                Builder builder = this.withCert(fileInputStream, certPass);
                return builder;
            }
        }

        public Builder withCert(InputStream is, String certPass) throws IOException {
            KeyStore keyStore = APNSUtil.loadCertificate(is, certPass);
            return this.withCertificateKeyStore(keyStore, certPass);
        }

        public Builder withEncryptionKey(String encryptionKeyId, String encryptionKey, String encryptionKeyPath, String teamId) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException {
            if (encryptionKey != null) {
                return this.withEncryptionKey(encryptionKeyId, encryptionKey, teamId);
            }
            if (encryptionKeyPath != null) {
                return this.withEncryptionKeyFile(encryptionKeyId, encryptionKeyPath, teamId);
            }
            return this;
        }

        public Builder withEncryptionKey(String encryptionKeyId, String encryptionKey, String teamId) throws InvalidKeySpecException, NoSuchAlgorithmException {
            PrivateKey privateKey = APNSUtil.loadPrivateKey(encryptionKey);
            return this.withEncryptionKey(encryptionKeyId, privateKey, teamId);
        }

        public Builder withEncryptionKeyFile(String encryptionKeyId, String encryptionKeyPath, String teamId) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException {
            try (FileInputStream fileInputStream = new FileInputStream(encryptionKeyPath);){
                Builder builder = this.withEncryptionKey(encryptionKeyId, new String(fileInputStream.readAllBytes(), StandardCharsets.UTF_8), teamId);
                return builder;
            }
        }

        public Builder withEncryptionKey(String encryptionKeyId, PrivateKey encryptionKey, String teamId) {
            this.e = new EncryptionKey(encryptionKeyId, encryptionKey, teamId);
            return this;
        }

        public Builder withCertificateKeyStore(KeyStore keyStore, String keyStorePassword) throws IOException {
            try {
                this.h = KeyManagerFactory.getInstance("sunx509");
                this.h.init(keyStore, keyStorePassword.toCharArray());
                return this;
            }
            catch (Exception exception) {
                throw new IOException("Could not initialize key manager factory", exception);
            }
        }

        public ApnsService build() throws IOException {
            return new ApnsService(this);
        }

        public Builder withBase64Cert(String base64certificate, String certificatePassword) throws IOException {
            return this.withCert(APNSUtil.inputStreamFromBase64(base64certificate), certificatePassword);
        }

        public Builder withKeepAliveTimeout(long keepAliveTimeout) {
            this.g = keepAliveTimeout;
            return this;
        }
    }

    public static class EncryptionKey {
        private final String a;
        private final PrivateKey b;
        private final String c;

        public EncryptionKey(String id, PrivateKey key, String teamId) {
            this.a = id;
            this.b = key;
            this.c = teamId;
        }

        public String getId() {
            return this.a;
        }

        public PrivateKey getKey() {
            return this.b;
        }

        public String getTeamId() {
            return this.c;
        }
    }

    public static class APNSTokenManager {
        private final EncryptionKey a;
        private volatile APNSToken b = new APNSToken(Instant.MIN, "");

        public APNSTokenManager(EncryptionKey encryptionKey) throws GeneralSecurityException {
            this.a = encryptionKey;
            this.a();
        }

        public String getToken() throws GeneralSecurityException {
            this.a();
            return this.b.getToken();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a() throws GeneralSecurityException {
            if (this.b.shouldRegenerate()) {
                APNSTokenManager aPNSTokenManager = this;
                synchronized (aPNSTokenManager) {
                    if (this.b.shouldRegenerate()) {
                        this.regenerateToken();
                    }
                }
            }
        }

        public synchronized void regenerateToken() throws GeneralSecurityException {
            Instant instant = Instant.now();
            long l = instant.getEpochSecond();
            String string = "{\"alg\":\"ES256\",\"kid\":\"" + this.a.getId() + "\"}";
            String string2 = "{\"iss\":\"" + this.a.getTeamId() + "\",\"iat\":" + l + "}";
            String string3 = Base64.getUrlEncoder().withoutPadding().encodeToString(string.getBytes(StandardCharsets.UTF_8)) + "." + Base64.getUrlEncoder().withoutPadding().encodeToString(string2.getBytes(StandardCharsets.UTF_8));
            Signature signature = Signature.getInstance("SHA256withECDSA");
            signature.initSign(this.a.getKey());
            signature.update(string3.getBytes(StandardCharsets.UTF_8));
            String string4 = Base64.getUrlEncoder().withoutPadding().encodeToString(signature.sign());
            this.b = new APNSToken(instant, string3 + "." + string4);
        }
    }

    public static final class AuthorizationType
    extends Enum<AuthorizationType> {
        public static final /* enum */ AuthorizationType certificate = new AuthorizationType();
        public static final /* enum */ AuthorizationType token = new AuthorizationType();
        private static final /* synthetic */ AuthorizationType[] a;

        public static AuthorizationType[] values() {
            return (AuthorizationType[])a.clone();
        }

        public static AuthorizationType valueOf(String name) {
            return Enum.valueOf(AuthorizationType.class, name);
        }

        private static /* synthetic */ AuthorizationType[] a() {
            return new AuthorizationType[]{certificate, token};
        }

        static {
            a = AuthorizationType.a();
        }
    }

    public static final class ErrorCode
    extends Enum<ErrorCode> {
        public static final /* enum */ ErrorCode badRequest = new ErrorCode();
        public static final /* enum */ ErrorCode authenticationFailure = new ErrorCode();
        public static final /* enum */ ErrorCode invalidMethod = new ErrorCode();
        public static final /* enum */ ErrorCode deviceTokenInactive = new ErrorCode();
        public static final /* enum */ ErrorCode payloadTooLarge = new ErrorCode();
        public static final /* enum */ ErrorCode tooManyRequestsForDeviceToken = new ErrorCode();
        public static final /* enum */ ErrorCode internalServerError = new ErrorCode();
        public static final /* enum */ ErrorCode serverShutdown = new ErrorCode();
        private static final /* synthetic */ ErrorCode[] a;

        public static ErrorCode[] values() {
            return (ErrorCode[])a.clone();
        }

        public static ErrorCode valueOf(String name) {
            return Enum.valueOf(ErrorCode.class, name);
        }

        public static ErrorCode fromStatus(int statusCode) {
            switch (statusCode) {
                case 200: {
                    return null;
                }
                case 400: {
                    return badRequest;
                }
                case 403: {
                    return authenticationFailure;
                }
                case 405: {
                    return invalidMethod;
                }
                case 410: {
                    return deviceTokenInactive;
                }
                case 413: {
                    return payloadTooLarge;
                }
                case 429: {
                    return tooManyRequestsForDeviceToken;
                }
                case 500: {
                    return internalServerError;
                }
                case 503: {
                    return serverShutdown;
                }
            }
            return internalServerError;
        }

        private static /* synthetic */ ErrorCode[] a() {
            return new ErrorCode[]{badRequest, authenticationFailure, invalidMethod, deviceTokenInactive, payloadTooLarge, tooManyRequestsForDeviceToken, internalServerError, serverShutdown};
        }

        static {
            a = ErrorCode.a();
        }
    }

    public static final class ErrorType
    extends Enum<ErrorType> {
        public static final /* enum */ ErrorType badCollapseId = new ErrorType();
        public static final /* enum */ ErrorType badDeviceToken = new ErrorType();
        public static final /* enum */ ErrorType badExpirationDate = new ErrorType();
        public static final /* enum */ ErrorType badMessageId = new ErrorType();
        public static final /* enum */ ErrorType badPriority = new ErrorType();
        public static final /* enum */ ErrorType badTopic = new ErrorType();
        public static final /* enum */ ErrorType deviceTokenNotForTopic = new ErrorType();
        public static final /* enum */ ErrorType duplicatedHeaders = new ErrorType();
        public static final /* enum */ ErrorType idleTimeout = new ErrorType();
        public static final /* enum */ ErrorType invalidPushType = new ErrorType();
        public static final /* enum */ ErrorType missingDeviceToken = new ErrorType();
        public static final /* enum */ ErrorType missingTopic = new ErrorType();
        public static final /* enum */ ErrorType payloadEmpty = new ErrorType();
        public static final /* enum */ ErrorType topicDisallowed = new ErrorType();
        public static final /* enum */ ErrorType badCertificate = new ErrorType();
        public static final /* enum */ ErrorType badCertificateEnvironment = new ErrorType();
        public static final /* enum */ ErrorType expiredProviderToken = new ErrorType();
        public static final /* enum */ ErrorType forbidden = new ErrorType();
        public static final /* enum */ ErrorType invalidProviderToken = new ErrorType();
        public static final /* enum */ ErrorType missingProviderToken = new ErrorType();
        public static final /* enum */ ErrorType badPath = new ErrorType();
        public static final /* enum */ ErrorType methodNotAllowed = new ErrorType();
        public static final /* enum */ ErrorType unregistred = new ErrorType();
        public static final /* enum */ ErrorType payloadTooLarge = new ErrorType();
        public static final /* enum */ ErrorType tooManyProviderTokenUpdates = new ErrorType();
        public static final /* enum */ ErrorType tooManyRequests = new ErrorType();
        public static final /* enum */ ErrorType internalServerError = new ErrorType();
        public static final /* enum */ ErrorType serviceUnavailable = new ErrorType();
        public static final /* enum */ ErrorType shutdown = new ErrorType();
        public static final /* enum */ ErrorType unknownError = new ErrorType();
        private static final /* synthetic */ ErrorType[] a;

        public static ErrorType[] values() {
            return (ErrorType[])a.clone();
        }

        public static ErrorType valueOf(String name) {
            return Enum.valueOf(ErrorType.class, name);
        }

        public static ErrorType from(String type) {
            if (type == null) {
                return unknownError;
            }
            switch (type) {
                case "BadCollapseId": {
                    return badCollapseId;
                }
                case "BadDeviceToken": {
                    return badDeviceToken;
                }
                case "BadExpirationDate": {
                    return badExpirationDate;
                }
                case "BadMessageId": {
                    return badMessageId;
                }
                case "BadPriority": {
                    return badPriority;
                }
                case "BadTopic": {
                    return badTopic;
                }
                case "DeviceTokenNotForTopic": {
                    return deviceTokenNotForTopic;
                }
                case "DuplicateHeaders": {
                    return duplicatedHeaders;
                }
                case "IdleTimeout": {
                    return idleTimeout;
                }
                case "InvalidPushType": {
                    return invalidPushType;
                }
                case "MissingDeviceToken": {
                    return missingDeviceToken;
                }
                case "MissingTopic": {
                    return missingTopic;
                }
                case "PayloadEmpty": {
                    return payloadEmpty;
                }
                case "TopicDisallowed": {
                    return topicDisallowed;
                }
                case "BadCertificate": {
                    return badCertificate;
                }
                case "BadCertificateEnvironment": {
                    return badCertificateEnvironment;
                }
                case "ExpiredProviderToken": {
                    return expiredProviderToken;
                }
                case "Forbidden": {
                    return forbidden;
                }
                case "InvalidProviderToken": {
                    return invalidProviderToken;
                }
                case "MissingProviderToken": {
                    return missingProviderToken;
                }
                case "BadPath": {
                    return badPath;
                }
                case "MethodNotAllowed": {
                    return methodNotAllowed;
                }
                case "Unregistered": {
                    return unregistred;
                }
                case "PayloadTooLarge": {
                    return payloadTooLarge;
                }
                case "TooManyProviderTokenUpdates": {
                    return tooManyProviderTokenUpdates;
                }
                case "TooManyRequests": {
                    return tooManyRequests;
                }
                case "InternalServerError": {
                    return internalServerError;
                }
                case "ServiceUnavailable": {
                    return serviceUnavailable;
                }
                case "Shutdown": {
                    return shutdown;
                }
            }
            return unknownError;
        }

        public Authorization getErrorCondition() {
            switch (this.ordinal()) {
                case 1: 
                case 6: 
                case 22: {
                    return Authorization.ITEM_NOT_FOUND;
                }
                case 13: {
                    return Authorization.NOT_ALLOWED;
                }
                case 23: {
                    return Authorization.POLICY_VIOLATION;
                }
                case 25: {
                    return Authorization.RESOURCE_CONSTRAINT;
                }
            }
            return Authorization.INTERNAL_SERVER_ERROR;
        }

        public boolean shouldRetry() {
            switch (this.ordinal()) {
                case 26: 
                case 27: 
                case 28: {
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ ErrorType[] a() {
            return new ErrorType[]{badCollapseId, badDeviceToken, badExpirationDate, badMessageId, badPriority, badTopic, deviceTokenNotForTopic, duplicatedHeaders, idleTimeout, invalidPushType, missingDeviceToken, missingTopic, payloadEmpty, topicDisallowed, badCertificate, badCertificateEnvironment, expiredProviderToken, forbidden, invalidProviderToken, missingProviderToken, badPath, methodNotAllowed, unregistred, payloadTooLarge, tooManyProviderTokenUpdates, tooManyRequests, internalServerError, serviceUnavailable, shutdown, unknownError};
        }

        static {
            a = ErrorType.a();
        }
    }

    public static class APNSToken {
        private final Instant a;
        private final String b;

        public APNSToken(Instant createdAt, String token) {
            this.a = createdAt;
            this.b = token;
        }

        public String getToken() {
            return this.b;
        }

        public boolean isValid() {
            return this.a.isAfter(Instant.now().minus(1L, ChronoUnit.HOURS));
        }

        public boolean shouldRegenerate() {
            return this.a.isBefore(Instant.now().minus(50L, ChronoUnit.MINUTES));
        }
    }
}

