/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.apns;

import java.util.UUID;
import tigase.push.apns.ApnsPayload;

public class ApnsNotification {
    private final String a;
    private final String b;
    private final PushType c;
    private final ApnsPayload d;
    private final String e;
    private final String f;
    private final long g;

    private ApnsNotification(Builder builder) {
        this.d = builder.a;
        this.c = builder.b;
        this.b = builder.c;
        this.e = builder.d;
        this.f = builder.e;
        this.g = builder.f;
        if (this.b == null) {
            throw new IllegalArgumentException("DeviceID is required!");
        }
        if (this.c == null) {
            throw new IllegalArgumentException("Push Type can not be null!");
        }
        if (this.d == null) {
            throw new IllegalArgumentException("Payload is required!");
        }
        this.a = UUID.randomUUID().toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDeviceId() {
        return this.b;
    }

    public long getExpiration() {
        return this.g;
    }

    public String getId() {
        return this.a;
    }

    public PushType getPushType() {
        return this.c;
    }

    public int getPriority() {
        return this.c == PushType.background ? 5 : 10;
    }

    public ApnsPayload getPayload() {
        return this.d;
    }

    public String getCollapseId() {
        return this.e;
    }

    public String getTopic() {
        return this.f;
    }

    public String toString() {
        return "[id: " + this.getId() + ", deviceId: " + this.getDeviceId() + ", type: " + this.getPushType().name() + ", collapseId: " + this.getCollapseId() + ", payload: " + this.getPayload().toPayloadString() + " ]";
    }

    public static class Builder {
        private ApnsPayload a;
        private PushType b;
        private String c;
        private String d;
        private String e;
        private long f;

        private Builder() {
        }

        public Builder collapseId(String collapseId) {
            this.d = collapseId;
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.c = deviceId;
            return this;
        }

        public Builder pushType(PushType pushType) {
            this.b = pushType;
            return this;
        }

        public Builder payload(ApnsPayload payload) {
            this.a = payload;
            return this;
        }

        public Builder topic(String topic) {
            this.e = topic;
            return this;
        }

        public Builder expiration(long expiration) {
            this.f = expiration;
            return this;
        }

        public ApnsNotification build() {
            return new ApnsNotification(this);
        }
    }

    public static final class PushType
    extends Enum<PushType> {
        public static final /* enum */ PushType alert = new PushType();
        public static final /* enum */ PushType background = new PushType();
        public static final /* enum */ PushType voip = new PushType();
        private static final /* synthetic */ PushType[] a;

        public static PushType[] values() {
            return (PushType[])a.clone();
        }

        public static PushType valueOf(String name) {
            return Enum.valueOf(PushType.class, name);
        }

        private static /* synthetic */ PushType[] a() {
            return new PushType[]{alert, background, voip};
        }

        static {
            a = PushType.a();
        }
    }
}

