/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.apns;

import java.io.IOException;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.component.exceptions.ComponentException;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventBusEvent;
import tigase.eventbus.EventBusFactory;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigFieldType;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.push.AbstractProvider;
import tigase.push.PushNotificationsComponent;
import tigase.push.api.IEncryptedNotification;
import tigase.push.api.INotification;
import tigase.push.api.IPlainNotification;
import tigase.push.api.IPushProvider;
import tigase.push.api.IPushSettings;
import tigase.push.apns.APNS;
import tigase.push.apns.APNSUtil;
import tigase.push.apns.ApnsNotification;
import tigase.push.apns.ApnsPayload;
import tigase.push.apns.ApnsService;
import tigase.push.apns.ApnsServiceException;
import tigase.push.monitor.SSLCertificateExpirationAware;
import tigase.push.utils.ExceptionHelper;
import tigase.xmpp.Authorization;

@Bean(name="apns-binary-api", parent=PushNotificationsComponent.class, active=false)
public class APNsBinaryApiProvider
extends AbstractProvider
implements Initializable,
UnregisterAware,
ConfigurationChangedAware,
IPushProvider,
SSLCertificateExpirationAware {
    private static final Logger a = Logger.getLogger(APNsBinaryApiProvider.class.getCanonicalName());
    protected final EventBus eventBus = EventBusFactory.getInstance();
    @ConfigField(desc="Password for certificate file", alias="cert-password", type=ConfigFieldType.Password)
    private String certificatePassword;
    @ConfigField(desc="Path to certificate file (.p12)", alias="cert-file")
    private String certificatePath;
    @ConfigField(desc="Certificate in PEM format", alias="cert-base64")
    private String base64certificate;
    @ConfigField(desc="Path to PushKit certificate file (.p12)", alias="pushkit-cert-file")
    private String pushkitCertificatePath;
    @ConfigField(desc="Path to PushKit certificate file (.p12)", alias="pushkit-cert-base64")
    private String base64pushkitCertificate;
    @ConfigField(desc="Path to encryption file (.p12)", alias="key-file")
    private String encryptionKeyPath;
    @ConfigField(desc="ID of encryption key", alias="key-id")
    private String encryptionKeyId;
    private String b;
    @ConfigField(desc="Team ID", alias="team-id")
    private String teamId;
    @ConfigField(desc="Whitelisted SSL certificate hashes", alias="whitelisted-certificate-hashes")
    private String[] whitelistedCertificateHashes = ApnsService.WHITELISTED_HASHES;
    @ConfigField(desc="Provider description")
    private String description = "Push provider for APNs - Binary API";
    @ConfigField(desc="Fallback to sandbox")
    private boolean fallbackToSandbox = false;
    @ConfigField(desc="APNS-Topic", alias="apns-topic")
    private String apnsTopic;
    @ConfigField(desc="Sandbox")
    private boolean sandbox = false;
    @ConfigField(desc="APNS connection keepalive timeout in seconds", alias="keepalive-timeout")
    private int keepaliveTimeout = 0;
    @ConfigField(desc="Include account in payload", alias="with-account")
    private boolean includeAccountInPayload = true;
    @ConfigField(desc="Replace with static notification", alias="static-notification")
    private boolean staticNotification = false;
    @ConfigField(desc="Static notification title", alias="static-notification-title")
    private String notificationTitle = null;
    @ConfigField(desc="Static notification body", alias="static-notification-body")
    private String notificationBody = null;
    @ConfigField(desc="Static notification subtitle", alias="static-notification-subtitle")
    private String notificationSubtitle = null;
    @ConfigField(desc="Static notification badge number", alias="static-notification-badge")
    private Integer notificationBadge = null;
    @ConfigField(desc="Push notification type", alias="notification-type")
    private NotificationType notificationType = NotificationType.automatic;
    private ApnsService c;
    private ApnsService d;
    private ApnsService e;
    private ApnsService f;

    public APNsBinaryApiProvider() {
        super("apns-binary-api");
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void initialize() {
        if (this.eventBus != null) {
            this.eventBus.registerAll((Object)this);
        }
    }

    @Override
    public Optional<Integer> maxPayloadSize() {
        return Optional.of(3072);
    }

    @Override
    public Set<IPushProvider.Feature> supportedFeatures() {
        return Set.of(IPushProvider.Feature.plain, IPushProvider.Feature.encrypted);
    }

    @Override
    public CompletableFuture<String> pushNotification(IPushSettings.IDevice device, INotification notification) {
        String string;
        boolean bl = notification.getType() == INotification.Type.voip && notification.getPriority() == INotification.Priority.high;
        String string2 = string = !bl ? device.getDeviceId() : device.getDeviceSecondId();
        if (string == null) {
            a.log(Level.FINEST, "there is no device (second) id for push notification for account " + String.valueOf(notification.getAccount()));
            if (bl) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.failedFuture(new ComponentException(Authorization.ITEM_NOT_FOUND, "Unknown device ID"));
        }
        if (notification.getType() == INotification.Type.voip && notification.getPriority() != INotification.Priority.high) {
            return this.a(device, notification, bl, string, NotificationType.background);
        }
        CompletableFuture<String> completableFuture = this.a(device, notification, bl, string, this.notificationType);
        if (this.notificationType == NotificationType.both) {
            try {
                this.a(device, notification, bl, string, NotificationType.background);
            }
            catch (Throwable throwable) {
                a.log(Level.WARNING, "Exception while sending fetch-only notification, ignoring...", throwable);
            }
        }
        return completableFuture;
    }

    private CompletableFuture<String> a(IPushSettings.IDevice iDevice, INotification iNotification, boolean bl, String string, NotificationType notificationType) {
        Object object;
        ApnsPayload.Builder builder = this.preparePayload(APNS.newPayload(), iNotification, notificationType);
        ApnsNotification.Builder builder2 = APNS.newNotification();
        if (bl && this.e != null) {
            builder2.pushType(ApnsNotification.PushType.voip);
        } else {
            if (this.apnsTopic != null) {
                object = this.apnsTopic;
                if (bl) {
                    object = (String)object + ".voip";
                }
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "setting topic for notifications " + (String)object);
                }
                builder2.topic((String)object);
            }
            if (bl) {
                builder2.pushType(ApnsNotification.PushType.voip);
            } else if (notificationType == NotificationType.background) {
                builder2.pushType(ApnsNotification.PushType.background);
                builder.mutableContent(1);
            } else {
                switch (iNotification.getPriority()) {
                    case low: {
                        builder2.pushType(ApnsNotification.PushType.background);
                        break;
                    }
                    case high: {
                        if (!builder.hasBody()) {
                            builder = builder.body("New message!");
                        }
                        builder.sound("default").mutableContent(1).category("MESSAGE").threadId(iNotification.getAccount().toString());
                        builder2.pushType(ApnsNotification.PushType.alert);
                    }
                }
            }
        }
        object = builder2.deviceId(string).payload(builder.build()).build();
        this.sendingPush();
        if (bl && this.e != null) {
            return this.pushNotification(iDevice, (ApnsNotification)object, this.e, this.f);
        }
        return this.pushNotification(iDevice, (ApnsNotification)object, this.c, this.d);
    }

    @Override
    public Stream<SSLCertificateExpirationAware.Result> getSSLCertificatesValidPeriod() {
        Stream<SSLCertificateExpirationAware.Result> stream = Stream.empty();
        try {
            if (this.base64certificate != null) {
                stream = Stream.concat(stream, APNSUtil.getCertificateValidPeriodFromBase64(this.base64certificate, this.certificatePassword));
            } else if (this.certificatePath != null) {
                stream = Stream.concat(stream, APNSUtil.getCertificateValidPeriodFromFile(this.certificatePath, this.certificatePassword));
            }
        }
        catch (Throwable throwable) {
            a.log(Level.WARNING, throwable, () -> "Could not retrieve valid period for Push SSL certificate");
        }
        try {
            if (this.base64pushkitCertificate != null) {
                stream = Stream.concat(stream, APNSUtil.getCertificateValidPeriodFromBase64(this.base64pushkitCertificate, this.certificatePassword));
            } else if (this.pushkitCertificatePath != null) {
                stream = Stream.concat(stream, APNSUtil.getCertificateValidPeriodFromFile(this.pushkitCertificatePath, this.certificatePassword));
            }
        }
        catch (Throwable throwable) {
            a.log(Level.WARNING, throwable, () -> "Could not retrieve valid period for PushKit SSL certificate");
        }
        return stream;
    }

    protected CompletableFuture<String> pushNotification(IPushSettings.IDevice device, ApnsNotification apnsNotification, ApnsService service, ApnsService fallbackService) {
        return this.a(service, fallbackService, apnsNotification).whenComplete((string, throwable) -> {
            if (throwable != null) {
                this.pushFailed();
                Optional.ofNullable(ExceptionHelper.findThrowable(throwable, ApnsServiceException.class)).filter(apnsServiceException -> {
                    switch (apnsServiceException.getErrorType()) {
                        case badDeviceToken: 
                        case deviceTokenNotForTopic: 
                        case unregistred: {
                            return true;
                        }
                    }
                    return false;
                }).ifPresent(apnsServiceException -> this.unregisterDevice(device.getDeviceId()));
            }
        });
    }

    private CompletableFuture<String> a(ApnsService apnsService, ApnsNotification apnsNotification) {
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "sending push notification " + apnsNotification.getId() + " at service " + String.valueOf(apnsService));
        }
        return this.a(apnsService, apnsNotification, 1).whenComplete((string, throwable) -> {
            if (throwable == null) {
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "sent push notification = " + apnsNotification.getId() + " at service = " + String.valueOf(apnsService));
                }
            } else if (a.isLoggable(Level.FINEST)) {
                Throwable throwable2 = ExceptionHelper.findLoggableException(throwable);
                if (throwable instanceof ApnsServiceException) {
                    a.log(Level.FINEST, "failed to send push notification = " + apnsNotification.getId() + " at service = " + String.valueOf(apnsService) + ", error: " + String.valueOf(throwable2));
                } else {
                    a.log(Level.FINEST, "failed to send push notification = " + apnsNotification.getId() + " at service = " + String.valueOf(apnsService), throwable2);
                }
            }
        });
    }

    private CompletableFuture<String> a(ApnsService apnsService, ApnsNotification apnsNotification, int n) {
        CompletableFuture<String> completableFuture = new CompletableFuture<String>();
        try {
            ((CompletableFuture)apnsService.push(apnsNotification).thenAccept(string -> completableFuture.complete((String)string))).exceptionally(throwable2 -> {
                if (n <= 3 && APNsBinaryApiProvider.a(throwable2)) {
                    ((CompletableFuture)this.a(apnsService, apnsNotification, n + 1).thenAccept(string -> completableFuture.complete((String)string))).exceptionally(throwable -> {
                        completableFuture.completeExceptionally((Throwable)throwable);
                        return null;
                    });
                } else {
                    completableFuture.completeExceptionally((Throwable)throwable2);
                }
                return null;
            });
        }
        catch (Throwable throwable) {
            completableFuture.completeExceptionally(throwable);
        }
        return completableFuture;
    }

    private CompletableFuture<String> a(ApnsService apnsService, ApnsService apnsService2, ApnsNotification apnsNotification) {
        CompletableFuture<String> completableFuture = new CompletableFuture<String>();
        ((CompletableFuture)this.a(apnsService, apnsNotification).thenAccept(string -> completableFuture.complete((String)string))).exceptionally(throwable2 -> {
            if (apnsService2 != null && APNsBinaryApiProvider.a(throwable2, ApnsService.ErrorType.badDeviceToken)) {
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "trying to use fallback service " + String.valueOf(apnsService2) + " for notification " + apnsNotification.getId());
                }
                ((CompletableFuture)this.a(apnsService2, apnsNotification).thenAccept(string -> completableFuture.complete((String)string))).exceptionally(throwable -> {
                    completableFuture.completeExceptionally((Throwable)throwable);
                    return null;
                });
            } else {
                completableFuture.completeExceptionally((Throwable)throwable2);
            }
            return null;
        });
        return completableFuture;
    }

    private static boolean a(Throwable throwable) {
        if (throwable instanceof CompletionException) {
            return APNsBinaryApiProvider.a(throwable.getCause());
        }
        if (throwable instanceof IOException) {
            return true;
        }
        if (throwable instanceof ApnsServiceException) {
            return ((ApnsServiceException)((Object)throwable)).getErrorType().shouldRetry();
        }
        return false;
    }

    private static boolean a(Throwable throwable, ApnsService.ErrorType errorType) {
        if (throwable instanceof CompletionException) {
            return APNsBinaryApiProvider.a(throwable.getCause(), errorType);
        }
        if (throwable instanceof ApnsServiceException) {
            return ((ApnsServiceException)((Object)throwable)).isErrorType(errorType);
        }
        return false;
    }

    public void beforeUnregister() {
        if (this.eventBus != null) {
            this.eventBus.unregisterAll((Object)this);
        }
        this.a(null);
        this.b(null);
        this.c(null);
        this.d(null);
    }

    @HandleEvent(filter=HandleEvent.Type.remote)
    public void certificateChange(APNSCertificateChangedEvent event) {
        try {
            this.reloadAPNSSecretsFromRepository();
        }
        catch (TigaseDBException tigaseDBException) {
            a.log(Level.WARNING, "Reloading APNS certificate failed", tigaseDBException);
        }
    }

    public void reloadAPNSCertificateFromRepository() throws TigaseDBException {
        this.reloadAPNSSecretsFromRepository();
    }

    public void reloadAPNSSecretsFromRepository() throws TigaseDBException {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.base64certificate = this.getData("base64certificate");
        if (this.base64certificate != null) {
            arrayList.add("base64certificate");
        }
        this.base64pushkitCertificate = this.getData("base64pushkitCertificate");
        if (this.base64pushkitCertificate != null) {
            arrayList.add("base64pushkitCertificate");
        }
        if (this.base64certificate != null || this.base64pushkitCertificate != null) {
            this.certificatePassword = this.getData("certificatePassword");
            if (this.certificatePassword != null) {
                arrayList.add("certificatePassword");
            }
        }
        this.b = this.getData("encryptionKey");
        if (this.b != null) {
            arrayList.add("encryptionKey");
            this.encryptionKeyId = this.getData("encryptionKeyId");
            if (this.encryptionKeyId != null) {
                arrayList.add("encryptionKeyId");
            }
            this.teamId = this.getData("teamId");
            if (this.teamId != null) {
                arrayList.add("teamId");
            }
        }
        this.beanConfigurationChanged(arrayList);
    }

    public void setAPNSCertificate(String base64certificate, String base64pushkitCertificate, String certificatePassword) throws TigaseDBException {
        Objects.requireNonNull(base64certificate);
        Objects.requireNonNull(base64pushkitCertificate);
        Objects.requireNonNull(certificatePassword);
        this.b();
        this.base64certificate = base64certificate;
        this.base64pushkitCertificate = base64pushkitCertificate;
        this.certificatePassword = certificatePassword;
        this.beanConfigurationChanged(List.of("base64certificate", "base64pushkitCertificate", "certificatePassword"));
        this.b(base64certificate, base64pushkitCertificate, certificatePassword);
        this.eventBus.fire((EventBusEvent)new APNSCertificateChangedEvent("push", this.getName()));
    }

    private void a() {
        this.base64certificate = null;
        this.base64pushkitCertificate = null;
    }

    public void setAPNSEncryptionKey(String encryptionKeyId, String encryptionKey, String teamId) throws TigaseDBException {
        Objects.requireNonNull(encryptionKeyId);
        Objects.requireNonNull(encryptionKey);
        Objects.requireNonNull(teamId);
        this.a();
        this.encryptionKeyId = encryptionKeyId;
        this.b = encryptionKey;
        this.teamId = teamId;
        this.beanConfigurationChanged(List.of("encryptionKeyId", "encryptionKey", "teamId"));
        this.a(encryptionKeyId, encryptionKey, teamId);
        this.eventBus.fire((EventBusEvent)new APNSCertificateChangedEvent("push", this.getName()));
    }

    private void b() {
        this.b = null;
    }

    public void beanConfigurationChanged(Collection<String> changedFields) {
        if (changedFields.contains("certificatePath") || changedFields.contains("pushkitCertificatePath") || changedFields.contains("base64certificate") || changedFields.contains("base64pushkitCertificate") || changedFields.contains("certificatePassword") || changedFields.contains("poolSize") || changedFields.contains("fallbackToSandbox") || changedFields.contains("userRepository") || changedFields.contains("encryptionKey") || changedFields.contains("encryptionKeyId") || changedFields.contains("encryptionKeyPath") || changedFields.contains("teamId")) {
            try {
                if (!this.c()) {
                    this.b(null);
                    this.a(null);
                } else {
                    this.b(this.fallbackToSandbox ? this.a(false) : null);
                    this.a(this.a(!this.sandbox));
                }
                if (!this.d()) {
                    this.d(null);
                    this.c(null);
                } else {
                    this.d(this.fallbackToSandbox ? this.b(false) : null);
                    this.c(this.b(!this.sandbox));
                }
            }
            catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException exception) {
                throw new RuntimeException("Could not configure APNs provider!", exception);
            }
        }
    }

    private boolean c() {
        return this.certificatePath != null || this.base64certificate != null || this.b != null || this.encryptionKeyPath != null;
    }

    private boolean d() {
        return this.pushkitCertificatePath != null || this.base64pushkitCertificate != null;
    }

    private ApnsService a(boolean bl) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException {
        return APNS.newService().withWhitelistedCertificates(this.whitelistedCertificateHashes).withEncryptionKey(this.encryptionKeyId, this.b, this.encryptionKeyPath, this.teamId).withCert(this.certificatePath, this.base64certificate, this.certificatePassword).withAppleDestination(bl).withKeepAliveTimeout(this.keepaliveTimeout).build();
    }

    private ApnsService b(boolean bl) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException {
        return APNS.newService().withWhitelistedCertificates(this.whitelistedCertificateHashes).withCert(this.pushkitCertificatePath, this.base64pushkitCertificate, this.certificatePassword).withAppleDestination(bl).withKeepAliveTimeout(this.keepaliveTimeout).build();
    }

    void a(String string, String string2, String string3) throws TigaseDBException {
        this.setData("encryptionKeyId", string);
        this.setData("encryptionKey", string2);
        this.setData("teamId", string3);
        this.f();
    }

    private void e() throws TigaseDBException {
        this.removeData("encryptionKeyId", "encryptionKey", "teamId");
    }

    void b(String string, String string2, String string3) throws TigaseDBException {
        this.setData("base64certificate", string);
        this.setData("base64pushkitCertificate", string2);
        this.setData("certificatePassword", string3);
        this.e();
    }

    private void f() throws TigaseDBException {
        this.removeData("base64certificate", "base64pushkitCertificate", "certificatePassword");
    }

    protected ApnsPayload.Builder preparePayload(ApnsPayload.Builder builder, INotification notification, NotificationType notificationType) {
        if (notification instanceof IPlainNotification) {
            return this.preparePlainPayload(builder, (IPlainNotification)notification, notificationType);
        }
        if (notification instanceof IEncryptedNotification) {
            return this.prepareEncryptedPayload(builder, (IEncryptedNotification)notification);
        }
        throw new IllegalArgumentException("Not supported notification class:" + notification.getClass().getCanonicalName());
    }

    protected ApnsPayload.Builder preparePlainPayload(ApnsPayload.Builder builder, IPlainNotification notification, NotificationType notificationType) {
        if (notificationType == NotificationType.background || notificationType == NotificationType.automatic && notification.getPriority() != INotification.Priority.high) {
            builder.instantDeliveryOrSilentNotification();
        }
        if (this.includeAccountInPayload) {
            builder.customField("account", notification.getAccount().toString());
        }
        if (this.staticNotification) {
            if (notificationType != NotificationType.background) {
                builder.title(this.notificationTitle).subtitle(this.notificationSubtitle).body(this.notificationBody).badge(this.notificationBadge);
            }
        } else {
            notification.ifMessageCount(l -> builder.customField("unread-messages", l));
            notification.ifLastMessageSender(jID -> builder.customField("sender", jID.getBareJID().toString()));
            notification.ifGroupchatSenderNickname(string -> builder.customField("nickname", string));
            notification.ifLastMessageBody(object -> {
                if (((String)object).length() > 512) {
                    object = ((String)object).substring(0, 500) + "...";
                }
                builder.customField("body", object);
            });
            notification.ifJingle(jingle -> {
                builder.customField("type", "call");
                builder.customField("sid", jingle.sid());
                if (jingle.media() != null) {
                    builder.customField("media", String.join((CharSequence)",", jingle.media()));
                }
            });
            notification.ifMeet(meet -> {
                builder.customField("type", "meet");
                builder.customField("meet-jid", meet.jid());
                builder.customField("meet-id", meet.id());
                if (meet.media() != null) {
                    builder.customField("media", String.join((CharSequence)",", meet.media()));
                }
            });
            notification.ifEventName(string -> builder.customField("event-name", string));
        }
        return builder;
    }

    protected ApnsPayload.Builder prepareEncryptedPayload(ApnsPayload.Builder builder, IEncryptedNotification notification) {
        if (notification.getPriority() != INotification.Priority.high) {
            builder.instantDeliveryOrSilentNotification();
        }
        if (this.includeAccountInPayload) {
            builder.customField("account", notification.getAccount().toString());
        }
        builder.customField("encrypted", notification.getEncrypted()).customField("iv", notification.getIV());
        return builder;
    }

    private void a(ApnsService apnsService) {
        ApnsService apnsService2 = this.c;
        this.c = apnsService;
        if (apnsService2 != null) {
            apnsService2.stop();
        }
    }

    private void b(ApnsService apnsService) {
        ApnsService apnsService2 = this.d;
        this.d = apnsService;
        if (apnsService2 != null) {
            apnsService2.stop();
        }
    }

    private void c(ApnsService apnsService) {
        ApnsService apnsService2 = this.e;
        this.e = apnsService;
        if (apnsService2 != null) {
            apnsService2.stop();
        }
    }

    @Override
    public void setUserRepository(UserRepository userRepository) {
        super.setUserRepository(userRepository);
        try {
            this.reloadAPNSCertificateFromRepository();
        }
        catch (TigaseDBException tigaseDBException) {
            a.log(Level.WARNING, "Reloading APNS certificate failed", tigaseDBException);
        }
    }

    private void d(ApnsService apnsService) {
        ApnsService apnsService2 = this.f;
        this.f = apnsService;
        if (apnsService2 != null) {
            apnsService2.stop();
        }
    }

    public static final class NotificationType
    extends Enum<NotificationType> {
        public static final /* enum */ NotificationType alert = new NotificationType();
        public static final /* enum */ NotificationType background = new NotificationType();
        public static final /* enum */ NotificationType both = new NotificationType();
        public static final /* enum */ NotificationType automatic = new NotificationType();
        private static final /* synthetic */ NotificationType[] a;

        public static NotificationType[] values() {
            return (NotificationType[])a.clone();
        }

        public static NotificationType valueOf(String name) {
            return Enum.valueOf(NotificationType.class, name);
        }

        private static /* synthetic */ NotificationType[] a() {
            return new NotificationType[]{alert, background, both, automatic};
        }

        static {
            a = NotificationType.a();
        }
    }

    public static class APNSCertificateChangedEvent
    implements Serializable,
    EventBusEvent {
        private String a;
        private String b;

        public APNSCertificateChangedEvent() {
        }

        public APNSCertificateChangedEvent(String componentId, String name) {
            this.a = componentId;
            this.b = name;
        }
    }
}

