/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.adhoc;

import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocCommandManager;
import tigase.pubsub.Affiliation;
import tigase.push.adhoc.UnregisterDevice;
import tigase.push.api.INotification;
import tigase.push.api.IPushProvider;
import tigase.push.api.IPushSettings;
import tigase.push.modules.AffiliationChangedModule;
import tigase.push.repositories.InMemoryPushRepository;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class UnregisterDeviceTest {
    private UnregisterDevice adhoc;
    private DummyAffiliationChangedModule affiliationChangedModule;
    private AdHocCommandManager manager;
    private DummyPushProvider pushProvider;
    private JID pushServiceJid = JID.jidInstanceNS((String)"push.example.com");
    private InMemoryPushRepository repository;
    private JID userJid;

    @Before
    public void setUp() throws Exception {
        this.manager = new AdHocCommandManager();
        this.adhoc = new UnregisterDevice();
        this.affiliationChangedModule = new DummyAffiliationChangedModule();
        this.pushProvider = new DummyPushProvider();
        this.repository = new InMemoryPushRepository();
        Field f = UnregisterDevice.class.getDeclaredField("pushProviders");
        f.setAccessible(true);
        f.set(this.adhoc, Arrays.asList(this.pushProvider));
        f = UnregisterDevice.class.getDeclaredField("repository");
        f.setAccessible(true);
        f.set(this.adhoc, this.repository);
        this.manager.setAllCommands(new AdHocCommand[]{this.adhoc});
        f = UnregisterDevice.class.getDeclaredField("affiliationChangedModule");
        f.setAccessible(true);
        f.set(this.adhoc, (Object)this.affiliationChangedModule);
        this.userJid = JID.jidInstance((String)("user-" + String.valueOf(UUID.randomUUID()) + "@example.com/res-1"));
    }

    @After
    public void tearDown() {
        this.adhoc = null;
        this.manager = null;
    }

    @Test
    public void test_formRetrieval() throws Exception {
        Packet packet = Packet.packetInstance((Element)new Element("iq", new Element[]{new Element("command", new String[]{"xmlns", "action", "node"}, new String[]{"http://jabber.org/protocol/commands", "execute", "unregister-device"})}, new String[]{"type"}, new String[]{"set"}), (JID)this.userJid, (JID)this.pushServiceJid);
        Packet result = this.process(packet);
        Assert.assertEquals((Object)StanzaType.result, (Object)result.getType());
        this.affiliationChangedModule.assertNotificationGenerated(false);
    }

    @Test
    public void test_formSubmit() throws Exception {
        String deviceToken = UUID.randomUUID().toString();
        IPushSettings settings = this.repository.registerDevice(this.pushServiceJid.getBareJID(), this.userJid.getBareJID(), "dummy", deviceToken, null);
        String node = settings.getNode();
        Packet packet = Packet.packetInstance((Element)new Element("iq", new Element[]{new Element("command", new Element[]{new Element("x", new Element[]{new Element("field", new Element[]{new Element("value", this.pushProvider.getName())}, new String[]{"var"}, new String[]{"provider"}), new Element("field", new Element[]{new Element("value", deviceToken)}, new String[]{"var"}, new String[]{"device-token"})}, new String[]{"xmlns", "type"}, new String[]{"jabber:x:data", "submit"})}, new String[]{"xmlns", "action", "node"}, new String[]{"http://jabber.org/protocol/commands", "execute", "unregister-device"})}, new String[]{"type"}, new String[]{"set"}), (JID)this.userJid, (JID)this.pushServiceJid);
        Packet result = this.process(packet);
        Assert.assertEquals((Object)StanzaType.result, (Object)result.getType());
        settings = this.repository.getNodeSettings(this.pushServiceJid.getBareJID(), node);
        Assert.assertNull((Object)settings);
        this.affiliationChangedModule.assertNotificationGenerated(true);
    }

    protected Packet process(Packet packet) throws AdHocCommandException {
        ArrayDeque queue = new ArrayDeque();
        this.manager.process(packet, queue::offer);
        return (Packet)queue.poll();
    }

    public static class DummyAffiliationChangedModule
    extends AffiliationChangedModule {
        private boolean value = false;

        public void assertNotificationGenerated(boolean expected) {
            Assert.assertEquals((Object)expected, (Object)this.value);
        }

        public void notifyAffiliationChanged(BareJID pushServiceJid, BareJID userJid, String node, Affiliation affiliation) {
            this.value = true;
        }
    }

    public static class DummyPushProvider
    implements IPushProvider {
        public String getName() {
            return "dummy";
        }

        public String getDescription() {
            return "Dummy Push Provider";
        }

        public CompletableFuture<String> pushNotification(IPushSettings.IDevice device, INotification notification) {
            return CompletableFuture.completedFuture(UUID.randomUUID().toString());
        }
    }
}

