/*
 * Tigase Push - Push notifications component for Tigase
 * Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.push.fcm;

import org.junit.Test;
import tigase.push.Device;
import tigase.push.PlainNotification;
import tigase.push.api.INotification;
import tigase.push.api.IPushSettings;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.logging.LogManager;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

public class FcmHttpV1ProviderTest {

	private final String deviceId = System.getProperty("deviceId");

	private final String serviceAccountPath = System.getProperty("serviceAccountPath");
	@Test
	public void testProvider()
			throws TigaseStringprepException, ExecutionException, InterruptedException, NoSuchFieldException,
				   IllegalAccessException, IOException {

		if (deviceId == null || serviceAccountPath == null) {
			return;
		}

		LogManager.getLogManager()
				.readConfiguration(new ByteArrayInputStream(
						"handlers=java.util.logging.ConsoleHandler\ntigase.push.fcm.level=ALL\ntigase.jaxmpp.j2se.connectors.socket.SocketConnector.level=ALL\njava.util.logging.ConsoleHandler.level=FINEST"
								.getBytes()));
		
	    FcmHttpV1Provider provider = new FcmHttpV1Provider();
		Field f = provider.getClass().getDeclaredField("serviceAccountPath");
		f.setAccessible(true);
		f.set(provider, serviceAccountPath);
		provider.beanConfigurationChanged(List.of("serviceAccountPath"));

		PlainNotification plainNotification = new PlainNotification(BareJID.bareJIDInstance("test@example.com"), INotification.Priority.low, 5l,
																	JID.jidInstance("sender@example.com/resource-1"),
																	"Some very important message " + UUID.randomUUID().toString(), null);
		IPushSettings.IDevice device = new Device("dummy", deviceId, null);
		String id = provider.pushNotification(device, plainNotification).get();
		assertNotNull("Failed to sent notification, id was returned as NULL!", id);
	}

	@Test
	public void payloadGenerationTestAccountRemoved() throws TigaseStringprepException, NoSuchFieldException, IllegalAccessException {
		FcmHttpV1Provider provider = new FcmHttpV1Provider();

		PlainNotification plainNotification = new PlainNotification(BareJID.bareJIDInstance("andrzej.wojcik@tigase.org"), INotification.Priority.high, null,
																	null,
																	null,null, "account-removed", null, null);
		Map<String, Object> payload = provider.preparePayload(plainNotification);
		Map<String, Object> data = (Map<String, Object>) payload.get("data");
		assertNotNull(data);
		assertEquals(plainNotification.getAccount().toString(), data.get("account"));
		assertEquals(plainNotification.getMessageCount(), data.get("unread-messages"));
		assertEquals(plainNotification.getLastMessageBody(), data.get("body"));
		assertEquals(plainNotification.getEventName(), data.get("event-name"));
	}
}