/*
 * Tigase Push - Push notifications component for Tigase
 * Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.push.apns;

import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;

@RunWith(Parameterized.class)
public class SSLTrustTest {

	private final String host;
	private final int port;
	private final boolean useCustomTrustManager;

	@Parameterized.Parameters
	public static Collection<Object[]> data() {
		return Arrays.asList(new Object[][] {
				{ "sectigo.com", 443, false },
				{ "sectigo.com", 443, true },
				{ "api.sandbox.push.apple.com", 443, false },
				{ "api.sandbox.push.apple.com", 443, true },
				{ "api.push.apple.com", 443, false },
				{ "api.push.apple.com", 443, true },
				});
	}

	public SSLTrustTest(String host, int port, boolean useCustomTrustManager) {
		this.host = host;
		this.port = port;
		this.useCustomTrustManager = useCustomTrustManager;
	}

	@Test
	@Ignore
	public void test() throws IOException, NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
		SSLContext sslContext = ApnsService.createSSLContext(null, useCustomTrustManager ? ApnsService.WHITELISTED_HASHES : null);
		SocketFactory sslSocketFactory = sslContext.getSocketFactory();
		try (SSLSocket sslSocket = (SSLSocket) sslSocketFactory.createSocket(host, port)) {
			sslSocket.startHandshake();
		}
	}
	
}
